/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Intervencoes2;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.awt.Rectangle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;

class CBTabela_elaboracao
extends CBTabela {
    Frame_Intervencoes2 PAG = null;
    boolean showIVA;
    private int limite_meses = 3;
    private Calendar cal = Calendar.getInstance();
    private Date data_limite_inf;

    public String getPagina() {
        return "Intervencoes2";
    }

    CBTabela_elaboracao() {
        this.tag = "Elaboracao";
        this.PAG = (Frame_Intervencoes2)fmeFrame.Paginas.getPage("Intervencoes2");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.cal.add(2, -this.limite_meses);
        this.data_limite_inf = CFType_Data.parse_date(CFType_Data.FMT.format(this.cal.getTime()));
        this.updateUI();
    }

    void updateUI() {
        this.showIVA = this.PAG.showIVA;
        this.cols = new CHTabColModel[7];
        this.cols[0] = new CHTabColModel("dossier_d", "<html>N.\u00ba no Dossier</html>", true, false, true, null);
        this.cols[1] = new CHTabColModel("accao_d", "<html>Ac\u00e7\u00e3o</html>", true, false, true, null);
        this.cols[2] = new CHTabColModel("sem_iva", "<html>Custo s/ IVA</html>", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[3] = new CHTabColModel("taxa_iva", "<html>Taxa IVA</html>", true, true, false, CFLib.VLD_VALOR_0);
        this.cols[4] = new CHTabColModel("taxa_iva_d", "<html>Taxa IVA</html>", true, true, this.showIVA, CFLib.VLD_VALOR_0);
        this.cols[5] = new CHTabColModel("com_iva", "<html>Custo c/ IVA</html>", true, false, this.showIVA, CFLib.VLD_VALOR_0);
        this.cols[6] = new CHTabColModel("data_rel", "<html>Data de<br> Realiza\u00e7\u00e3o<br>(A-M)</html>", true, true, true, CFLib.VLD_ANO_MES);
        int count = 0;
        this.init_dados(count += !CBData.Operacao.getByName("a2311").isEmpty() ? 1 : 0);
        this.PAG.getJScrollPane_elab().setBounds(new Rectangle(14, 36, 529, 78 + (23 - count) * count));
        this.PAG.getJTable_elab().addKeyListener(new TableKeyListener(this));
        this.init_handler(new CHTabQuadro(), this.PAG.getJTable_elab());
        this.handler.width = this.PAG.getJScrollPane_elab().getWidth();
        this.force_xml = true;
        this.handler.set_col_text(0, 0.15, "C");
        this.handler.set_col_text(1, 0.2, "C");
        this.handler.set_col_text(2, 0.258, "C");
        if (this.showIVA) {
            this.handler.set_col_comboS(4, 0.1, null, CTabelas.Iva, 1, 100);
            this.handler.set_col_text(5, 0.258, "C");
        }
        this.handler.set_col_text(6, 0.12, "C");
        count = 0;
        if (!CBData.Operacao.getByName("a2311").isEmpty()) {
            this.setColValue("accao_d", count, "231.1");
            ++count;
        }
        ((CHTabQuadro)this.handler).start_rows();
        CBData.numerarMult(0);
    }

    public void calcTotal() {
        if (this.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String val = this.getColValue("sem_iva", i);
                if (val.equals("")) {
                    this.setColValue("com_iva", i, val);
                } else if (!this.showIVA) {
                    this.setColValue("com_iva", i, val);
                } else {
                    double rata = 0.0;
                    double perc = this.getColValue("taxa_iva_d", i).equals("") ? 0.0 : (double)Integer.parseInt(this.getColValue("taxa_iva_d", i)) / 100.0;
                    if (CBData.RegimeIva.getByName((String)"regime_iva").v.equals("2")) {
                        rata = CBData.RegimeIva.getByName("pro_rata").valueAsDouble() / 100.0;
                    }
                    perc = _lib.to_double(val) * (1.0 + perc * (1.0 - rata));
                    this.setColValue("com_iva", i, String.valueOf(perc));
                }
            }
            ++i;
        }
    }

    void on_update(String colname, int nRow, String v) {
        if (!CBData.reading_xml && colname.equals("data_rel") && !this.isEmpty() && !v.equalsIgnoreCase("")) {
            SimpleDateFormat data = new SimpleDateFormat("yyyy-MM");
            Date dt = new Date();
            try {
                dt = data.parse(this.getColValue(colname, nRow));
                if (CFType_Data.parse_date(CBData.Operacao.getByName((String)"inicio_investimento").v) == null || CFType_Data.parse_date(CBData.Operacao.getByName((String)"fim_investimento").v) == null) {
                    JOptionPane.showMessageDialog(null, "Preencher em primeiro as Datas de In\u00edcio e Termo de Opera\u00e7\u00e3o", "Erro", 0);
                    this.setColValue(colname, nRow, "");
                } else {
                    if (dt.before(data.parse(data.format(this.data_limite_inf).substring(0, 7)))) {
                        JOptionPane.showMessageDialog(null, "A Data inserida n\u00e3o pode ser anterior \u00e0 Data de submiss\u00e3o menos 3 meses.", "Erro", 0);
                        this.setColValue(colname, nRow, "");
                    }
                    if (dt.after(data.parse(CBData.Operacao.getByName((String)"fim_investimento").v))) {
                        JOptionPane.showMessageDialog(null, "A Data inserida n\u00e3o pode ser posterior \u00e0 Data de Termo de Opera\u00e7\u00e3o.", "Erro", 0);
                        this.setColValue(colname, nRow, "");
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (colname.equals("data_rel")) {
            colname = "sem_iva";
        }
        if (colname.equals("taxa_iva_d") || colname.equals("sem_iva")) {
            this.calcTotal();
            double totaliva = 0.0;
            double total = 0.0;
            int i = 0;
            while (i < this.dados.size()) {
                total += _lib.to_double(this.getColValue("sem_iva", i));
                totaliva += _lib.to_double(this.getColValue("com_iva", i));
                ++i;
            }
            CBData.calcInvestimentos(this.showIVA);
        }
        CBData.numerarMult(0);
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Elabora\u00e7\u00e3o e acompanhamento do projecto");
        }
        int i = 0;
        while (i < this.dados.size()) {
            String mask = this.getMask(i);
            SimpleDateFormat data = new SimpleDateFormat("yyyy-MM");
            TabError[] e = this.isIncompletAll(i, mask);
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o"), e[ii].row, e[ii].col));
                ++ii;
            }
            if (!CBData.Operacao.getByName("inicio_investimento").isEmpty() && !CBData.Operacao.getByName("fim_investimento").isEmpty()) {
                Date di = CFType_Data.parse_date(CBData.Operacao.getByName((String)"inicio_investimento").v);
                Date df = CFType_Data.parse_date(CBData.Operacao.getByName((String)"fim_investimento").v);
                Date d = null;
                if (!this.getColValue("data_rel", i).equals("")) {
                    String[] s = this.getColValue("data_rel", i).split("-");
                    d = CFType_Data.parse_date(String.valueOf(s[0]) + "-" + s[1] + "-01");
                }
                try {
                    if (this.data_limite_inf != null && d != null && data.parse(data.format(d)).before(data.parse(data.format(this.data_limite_inf)))) {
                        err_list.add_msg(new CHValid_Msg(new TabError(i, this.getColIndex("data_rel"), this), "Linha %L: Ano-m\u00eas de Realiza\u00e7\u00e3o anterior \u00e0 Data de submiss\u00e3o menos 3 meses"));
                    }
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                if (df != null && d != null && df.before(d)) {
                    err_list.add_msg(new CHValid_Msg("data2", 'E', "Linha " + (i + 1) + ": Data de realiza\u00e7\u00e3o posterior \u00e0 de conclus\u00e3o do investimento"));
                }
            }
            ++i;
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("--");
        if (!(this.getColValue("sem_iva", 0).isEmpty() && this.getColValue("taxa_iva_d", 0).isEmpty() && this.getColValue("com_iva", 0).isEmpty() && this.getColValue("data_rel", 0).isEmpty())) {
            mask.append("R");
            if (this.cols[this.getColIndex((String)"com_iva")].visible) {
                mask.append("---");
            } else {
                mask.append("---");
            }
            mask.append("R");
        } else {
            mask.append("-----");
        }
        return mask.toString();
    }
}

