/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabela;
import fme.CTabelas;
import fme.Frame_Intervencoes2;
import fme.SteppedComboBox;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

class CBTabela_OCE
extends CBTabela {
    Frame_Intervencoes2 PAG = null;
    boolean showIVA;

    public String getPagina() {
        return "Intervencoes";
    }

    CBTabela_OCE() {
        this.tag = "Investimentos";
        this.PAG = (Frame_Intervencoes2)fmeFrame.Paginas.getPage("Intervencoes2");
        if (this.PAG == null) {
            return;
        }
        this.PAG.getJTable_OCE().setName("OCE_Tabela");
        this.showIVA = this.PAG.showIVA;
        this.started = true;
        this.updateUI();
        this.PAG.getJTable_OCE().addKeyListener(new TableKeyListener(this));
        this.init_dados(11);
    }

    public void updateUI() {
        if (!this.started) {
            return;
        }
        this.showIVA = this.PAG.showIVA;
        this.cols = new CHTabColModel[16];
        this.cols[0] = new CHTabColModel("dossier", "N\u00ba <br>Dossier", true, false, true, null);
        this.cols[1] = new CHTabColModel("n_local", "Local", true, true, true, null);
        this.cols[2] = new CHTabColModel("id_tipologia", "", true, false, false, null);
        this.cols[3] = new CHTabColModel("tipologia", "Tipologia", true, true, true, null);
        this.cols[4] = new CHTabColModel("id_rubrica", "", true, true, false, null);
        this.cols[5] = new CHTabColModel("rubrica", "Rubrica", true, true, true, null);
        this.cols[6] = new CHTabColModel("designacao", "Designa\u00e7\u00e3o da Despesa", true, true, true, null);
        this.cols[7] = new CHTabColModel("unidade", "Unidade F\u00edsica", true, true, true, null);
        this.cols[8] = new CHTabColModel("quantidade", "Quantifica\u00e7\u00e3o", true, true, true, CFLib.VLD_VALOR);
        this.cols[9] = new CHTabColModel("valor", "Valor Unit\u00e1rio", true, true, true, CFLib.VLD_VALOR);
        this.cols[10] = new CHTabColModel("total_sem_iva", "Total S/IVA", true, false, true, CFLib.VLD_VALOR);
        this.cols[11] = new CHTabColModel("id_taxa_iva", "Taxa IVA", true, true, false, CFLib.VLD_PERC);
        this.cols[12] = new CHTabColModel("taxa_iva", "Taxa<br>IVA", true, true, this.showIVA, CFLib.VLD_PERC);
        this.cols[13] = new CHTabColModel("total_com_iva", "Total C/IVA", true, false, this.showIVA, CFLib.VLD_VALOR);
        this.cols[14] = new CHTabColModel("data", "<html>Data de<br> Realiza\u00e7\u00e3o<br>(A-M)</html>", true, true, true, CFLib.VLD_ANO_MES);
        this.cols[15] = new CHTabColModel("nparcelario", "N.\u00ba P3 PINV</html>", true, true, true, null);
        this.init_handler(this.PAG.getJTable_OCE());
        this.handler.width = this.PAG.getJScrollPane_OCE().getWidth();
        this.handler.set_col_text(0, 0.07, "C");
        this.handler.set_col_comboF(1, 0.06, null, CTabelas.N_Local1, 1, 60);
        this.handler.set_col_comboF(3, 0.2, null, CTabelas.TipoFlor, 1, 500);
        this.handler.set_col_comboF(5, 0.4, null, CTabelas.Despesas, 1, 300);
        this.handler.set_col_text(6, 0.5, "C");
        this.handler.set_col_comboS(7, 0.15, null, CTabelas.UniVend, 1, 100);
        this.handler.set_col_text(8, 0.24, "C");
        this.handler.set_col_text(9, 0.24, "C");
        this.handler.set_col_text(10, 0.24, "C");
        if (this.showIVA) {
            this.handler.set_col_comboS(12, 0.07, null, CTabelas.Iva, 1, 40);
            this.handler.set_col_text(13, 0.24, "C");
        }
        this.handler.set_col_text(14, 0.12, "C");
        this.handler.set_col_text(15, 0.25, "C");
        this.calcTotal();
    }

    void _populate_n_local2(SteppedComboBox cboFiltered, int row) {
        String n_local = this.getColValue("n_local", row);
        CTabela N_local = new CTabela();
        Vector<String> locs = new Vector<String>();
        N_local.dCol = 0;
        N_local.cCol = 0;
        if (CBData.preds.dados.isEmpty()) {
            N_local.data_table = new Vector();
        } else {
            int i = 0;
            while (i < CBData.preds.dados.size()) {
                if (!CBData.preds.getColValue("n_local", i).equalsIgnoreCase("") && !locs.contains(CBData.preds.getColValue("n_local", i))) {
                    N_local.data_table.add((String[])CBData.preds.dados.elementAt(i));
                    locs.add(CBData.preds.getColValue("n_local", i));
                }
                ++i;
            }
        }
        N_local._populateComboBox((JComboBox)cboFiltered, n_local);
    }

    void _populate_tipologia(SteppedComboBox cboFiltered, int row) {
        String n_local = this.getColValue("tipologia", row);
        CTabela tipo = new CTabela();
        String currLocal = this.getColValue("n_local", row);
        Vector<String> selTipos = new Vector<String>();
        tipo.dCol = 2;
        tipo.cCol = 0;
        if (CBData.preds.dados.isEmpty()) {
            tipo.data_table = new Vector();
        } else {
            int i = 0;
            while (i < CBData.preds.dados.size()) {
                if (CBData.preds.getColValue("n_local", i).equalsIgnoreCase(currLocal) && !CBData.preds.getColValue("tipo_invest_d", i).equals("") && !selTipos.contains(CBData.preds.getColValue("tipo_invest_d", i))) {
                    tipo.data_table.add((String[])CBData.preds.dados.elementAt(i));
                    selTipos.add(CBData.preds.getColValue("tipo_invest_d", i));
                }
                ++i;
            }
        }
        tipo._populateComboBox((JComboBox)cboFiltered, n_local);
    }

    void _populate_rubrica(SteppedComboBox cboFiltered, int row) {
        String tipologia = this.getColValue("tipologia", row);
        String currRubrica = this.getColValue("rubrica", row);
        if (tipologia.length() == 0) {
            CTabelas.RubricaF1.clear_combo();
        } else {
            String codDesp = CTabelas.TipoFlor.lookup(1, tipologia, 4);
            CTabelas.RubricaF1.set_filter(2, codDesp);
        }
        CTabelas.RubricaF1._populateComboBox((JComboBox)cboFiltered, currRubrica);
    }

    public void calcTotal() {
        if (this.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String val = _lib.to_string(_lib.to_double(this.getColValue("quantidade", i)) * _lib.to_double(this.getColValue("valor", i)));
                this.setColValue("total_sem_iva", i, val);
                if (val.equals("")) {
                    this.setColValue("total_com_iva", i, val);
                } else if (!this.showIVA) {
                    this.setColValue("total_com_iva", i, val);
                } else {
                    double rata = 0.0;
                    double perc = this.getColValue("id_taxa_iva", i).equals("") ? 0.0 : _lib.to_double(this.getColValue("taxa_iva", i)) / 100.0;
                    if (CBData.RegimeIva.getByName((String)"regime_iva").v.equals("2")) {
                        rata = CBData.RegimeIva.getByName("pro_rata").valueAsDouble() / 100.0;
                    }
                    perc = _lib.to_double(val) * (1.0 + perc * (1.0 - rata));
                    this.setColValue("total_com_iva", i, String.valueOf(_lib.round(perc, 2)));
                }
            }
            ++i;
        }
    }

    boolean on_del_row() {
        if (!super.on_del_row()) {
            return false;
        }
        CBData.numerarMult(0);
        CBData.calcInvestimentos(this.showIVA);
        return true;
    }

    boolean on_up_row() {
        if (!super.on_up_row()) {
            return false;
        }
        CBData.numerarMult(0);
        CBData.calcInvestimentos(this.showIVA);
        return true;
    }

    boolean on_copy_row() {
        if (!super.on_copy_row()) {
            return false;
        }
        CBData.numerarMult(0);
        CBData.calcInvestimentos(this.showIVA);
        return true;
    }

    void on_update(String colname, int nRow, String v) {
        String operacao;
        if (!CBData.reading_xml && colname.equals("data") && !this.isEmpty() && !v.equalsIgnoreCase("")) {
            SimpleDateFormat data = new SimpleDateFormat("yyyy-MM");
            Date dt = new Date();
            try {
                dt = data.parse(this.getColValue(colname, nRow));
                if (CFType_Data.parse_date(CBData.Operacao.getByName((String)"inicio_investimento").v) == null || CFType_Data.parse_date(CBData.Operacao.getByName((String)"fim_investimento").v) == null) {
                    JOptionPane.showMessageDialog(null, "Preencher em primeiro as Datas de In\u00edcio e Termo de Opera\u00e7\u00e3o", "Erro", 0);
                    this.setColValue(colname, nRow, "");
                } else {
                    if (dt.before(data.parse(CBData.Operacao.getByName((String)"inicio_investimento").v.substring(0, 7)))) {
                        JOptionPane.showMessageDialog(null, "A Data inserida n\u00e3o pode ser anterior \u00e0 Data de In\u00edcio de Opera\u00e7\u00e3o.", "Erro", 0);
                        this.setColValue(colname, nRow, "");
                    }
                    if (dt.after(data.parse(CBData.Operacao.getByName((String)"fim_investimento").v.substring(0, 7)))) {
                        JOptionPane.showMessageDialog(null, "A Data inserida n\u00e3o pode ser posterior \u00e0 Data de Termo de Opera\u00e7\u00e3o.", "Erro", 0);
                        this.setColValue(colname, nRow, "");
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (colname.equals("tipologia")) {
            operacao = CTabelas.TipoFlor.lookup(1, v, 0);
            this.setColValue("id_tipologia", nRow, operacao);
        }
        if (colname.equals("taxa_iva")) {
            operacao = CTabelas.Iva.lookup(1, v, 0);
            this.setColValue("id_taxa_iva", nRow, operacao);
        }
        if (colname.equals("total_sem_iva") || colname.equals("taxa_iva") || colname.equals("valor") || colname.equals("quantidade")) {
            this.calcTotal();
            CBData.calcInvestimentos(this.showIVA);
        }
        if (colname.equals("total_com_iva") && this.getColValue("total_sem_iva", nRow).length() == 0) {
            this.setColValue("total_com_iva", nRow, "");
        }
        if (colname.equals("rubrica")) {
            String uni = CTabelas.Despesas.lookup(1, v, 3);
            this.setColValue("unidade", nRow, uni);
            String despesa = CTabelas.Despesas.lookup(1, v, 0);
            this.setColValue("id_rubrica", nRow, despesa);
        }
        if (colname.equals("data")) {
            CBData.calcInvestimentos(this.showIVA);
        }
        CBData.numerarMult(0);
        CBData.calcInvestimentos(this.showIVA);
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o dos Investimentos");
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("Caracteriza\u00e7\u00e3o dos Investimentos", "Lista vazia"));
        }
        SimpleDateFormat data = new SimpleDateFormat("yyyy-MM");
        if (!CBData.Operacao.getByName("inicio_investimento").isEmpty() && !CBData.Operacao.getByName("fim_investimento").isEmpty()) {
            int i = 0;
            while (i < this.dados.size()) {
                Date di = null;
                Date df = null;
                Date d = null;
                try {
                    di = data.parse(CBData.Operacao.getByName((String)"inicio_investimento").v.substring(0, 7));
                    df = data.parse(CBData.Operacao.getByName((String)"fim_investimento").v.substring(0, 7));
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                if (!this.getColValue("data", i).equals("")) {
                    String[] s = this.getColValue("data", i).split("-");
                    d = CFType_Data.parse_date(String.valueOf(s[0]) + "-" + s[1]);
                }
                if (di != null && d != null && d.before(di)) {
                    err_list.add_msg(new CHValid_Msg("data1", 'E', "Linha " + (i + 1) + ": Data de realiza\u00e7\u00e3o anterior \u00e0 de Inicio do investimento"));
                }
                if (df != null && d != null && df.before(d)) {
                    err_list.add_msg(new CHValid_Msg("data2", 'E', "Linha " + (i + 1) + ": Data de realiza\u00e7\u00e3o posterior \u00e0 de Fim do investimento"));
                }
                ++i;
            }
        }
        int k = 0;
        while (k != this.dados.size()) {
            if (!(this.isRowEmpty(k) || this.getColValue("nparcelario", k).isEmpty() || this.getColValue("nparcelario", k).matches("9\\d{12}") || this.getColValue("nparcelario", k).matches("9\\d{12}-\\d{3}"))) {
                err_list.add_msg(new CHValid_Msg("nparcelario", "Linha " + (k + 1) + ": Formato de N.\u00ba P3 PINV incorrecto, deve come\u00e7ar por 9 e ter 13 d\u00edgitos ou 13 d\u00edgitos - (tra\u00e7o) 3 d\u00edgitos", k, this.getColIndex("nparcelario")));
            }
            ++k;
        }
        return err_list;
    }

    CHValid_Grp validar2(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o dos Investimentos");
        }
        this.asRubrica(CBData.LocalInter, "01", "02", "08", "09", 1, err_list);
        this.asRubrica(CBData.controlos, "03", "", "", "", 2, err_list);
        this.asRubrica(CBData.Podas, "39", "04", "", "", 3, err_list);
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("RR-R-RR-RR--");
        if (this.cols[12].visible) {
            mask.append("-");
        } else {
            mask.append("-");
        }
        if (this.getColValue("id_rubrica", nRow).equals("31")) {
            mask.append("-R");
        } else {
            mask.append("-R");
        }
        mask.append("-R");
        return mask.toString();
    }

    CHValid_Grp asRubrica(CBTabela tabela, String val1, String val2, String val3, String val4, int local, CHValid_Grp err_list) {
        boolean find = false;
        int _i = 0;
        while (_i < tabela.dados.size()) {
            find = false;
            if (!tabela.getColValue("n_local", _i).equals("")) {
                int nLocal = (int)_lib.to_double(tabela.getColValue("n_local", _i));
                int _j = 0;
                while (_j < CBData.OCE.dados.size()) {
                    if (nLocal == (int)_lib.to_double(CBData.OCE.getColValue("n_local", _j))) {
                        if (!val2.equals("")) {
                            if (CBData.OCE.getColValue("id_rubrica", _j).equals(val1) || CBData.OCE.getColValue("id_rubrica", _j).equals(val2) || CBData.OCE.getColValue("id_rubrica", _j).equals(val3) || CBData.OCE.getColValue("id_rubrica", _j).equals(val4)) {
                                find = true;
                            }
                        } else if (CBData.OCE.getColValue("id_rubrica", _j).equals(val1)) {
                            find = true;
                        }
                    }
                    if (find) break;
                    ++_j;
                }
                if (!find) {
                    if (local == 1) {
                        err_list.add_msg(new CHValid_Msg("id_rubrica", 'W', "\u00c9 necess\u00e1rio, para o local " + nLocal + ", seleccionar a rubrica Controlo da Vegeta\u00e7\u00e3o Espont\u00e2nea"));
                    } else if (local == 2) {
                        err_list.add_msg(new CHValid_Msg("id_rubrica", 'W', "\u00c9 necess\u00e1rio, para o local " + nLocal + ", seleccionar a rubrica Redu\u00e7\u00e3o de Densidades"));
                    } else if (local == 3) {
                        err_list.add_msg(new CHValid_Msg("id_rubrica", 'W', "\u00c9 necess\u00e1rio, para o local " + nLocal + ", seleccionar a rubrica Desrama\u00e7\u00f5es ou Podas"));
                    }
                }
            }
            ++_i;
        }
        return err_list;
    }
}

