/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.DateInv;
import fme.Frame_Financ;
import fme._lib;
import fme.fmeFrame;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CBTabela_FinancInd
extends CBTabela {
    Frame_Financ PAG = null;
    boolean showIVA;
    int financiamento = -1;
    int investimento = -1;
    int elegivel = -1;
    int ano_inicio;
    int ano_fim;

    @Override
    public String getPagina() {
        return "Financ";
    }

    CBTabela_FinancInd() {
        this.tag = "EstruturaFinanceira";
        this.PAG = (Frame_Financ)fmeFrame.Paginas.getPage("Financ");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.showIVA = this.PAG.showIVA;
        this.force_xml = true;
        this.PAG.getJTable_Financ().setName("Financ");
        int anoI = CFLib.VLD_ANO_CAND.ano_inicial;
        int anoF = anoI + 6 - 1;
        this.on_update_limites(anoI, anoF, !CBData.Operacao.getByName("a2311").isEmpty());
        int n = 0;
        this.PAG.setComponentSize(this.df_nlines, n);
    }

    @Override
    public String xmlPrint() {
        int nRows = this.dados.size();
        int nCols = this.cols.length;
        String xml = new String();
        xml = "";
        int i = 1;
        while (i < nRows) {
            String xml_reg = new String();
            boolean has_data = false;
            xml_reg = "<Reg>\n";
            int j = 0;
            while (j < nCols) {
                if (this.cols[j].xml_enabled) {
                    String v = ((String[])this.dados.elementAt(i))[j];
                    has_data = true;
                    String v2 = this.on_xml(this.cols[j].col_tag, i, v);
                    xml_reg = v2.length() == 0 ? String.valueOf(xml_reg) + _lib.xml_encode(this.cols[j].col_tag, v) : String.valueOf(xml_reg) + v2;
                }
                ++j;
            }
            xml_reg = String.valueOf(xml_reg) + this.xmlPrintInternal(i);
            xml_reg = String.valueOf(xml_reg) + "</Reg>\n";
            if (has_data) {
                xml = String.valueOf(xml) + "\n" + xml_reg;
            }
            ++i;
        }
        return xml;
    }

    void on_update_limites(int anoI, int anoF, boolean showComponent) {
        if (!this.started) {
            return;
        }
        this.ano_inicio = anoI;
        this.ano_fim = anoF;
        this.cols = new CHTabColModel[11];
        this.cols[0] = new CHTabColModel("conta", "", false, false, false, null);
        this.cols[1] = new CHTabColModel("sub", "", false, false, true, null);
        int c = 2;
        int n = 0;
        int ano = anoI;
        while (ano <= anoF) {
            this.cols[c++] = new CHTabColModel("val_" + n, Integer.toString(ano), true, n != 0, true, CFLib.VLD_VALOR_S);
            ++n;
            ++ano;
        }
        while (ano < anoI + 6) {
            this.cols[c++] = new CHTabColModel("val_" + n, null, true, false, false, null);
            ++n;
            ++ano;
        }
        this.cols[c++] = new CHTabColModel("total", "Total", true, false, true, CFLib.VLD_VALOR_S);
        this.cols[c++] = new CHTabColModel("perc", "%", true, false, true, CFLib.VLD_VALOR_S);
        this.cols[c++] = new CHTabColModel("n_ordem", null, false, false, false, null);
        this.init_handler(new CHTabQuadro(), this.PAG.getJTable_Financ());
        this.handler.width = this.PAG.getJScrollPane_Financ().getWidth();
        this.handler.set_col_text(1, 0.3, null);
        c = 2;
        ano = anoI;
        while (ano <= anoF) {
            this.handler.set_col_text(c++, 0.125, "R");
            ++ano;
        }
        while (ano < anoI + 6) {
            ++c;
            ++ano;
        }
        this.handler.set_col_text(c++, 0.125, "R");
        this.handler.set_col_text(c++, 0.072, "R");
        this.cols[0].disable_row_calc = true;
        this.cols[1].disable_row_calc = true;
        c = 8;
        this.cols[c++].disable_row_calc = true;
        this.cols[c++].disable_row_calc = true;
        this.cols[c++].disable_row_calc = true;
        this.init_dados(4);
        if (this.df_nlines == 0) {
            return;
        }
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[0] = false;
        ((CHTabQuadro)this.handler).row_editable[1] = showComponent;
        ((CHTabQuadro)this.handler).row_editable[2] = showComponent;
        ((CHTabQuadro)this.handler).row_editable[3] = false;
        this.setColValue("sub", 0, "<html><b>Subac\u00e7\u00e3o 2.3.1.1</b></html>");
        this.setColValue("sub", 1, "  Valor do Apoio");
        this.setColValue("sub", 2, "  Autofinanciamento");
        this.setColValue("sub", 3, "  Investimento");
        this.keyCol = 0;
        this.numerarAll(0);
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        ((String[])this.dados.elementAt((int)1))[2] = "";
        ((String[])this.dados.elementAt((int)2))[2] = "";
        if (colname.startsWith("val_")) {
            double inv = 0.0;
            double totalinv = 0.0;
            double totalapoio = 0.0;
            double totalauto = 0.0;
            int anos = this.ano_fim - this.ano_inicio;
            int i = 2;
            while (i <= 3 + anos) {
                totalapoio += _lib.to_double(this.getColValue(this.cols[i].col_tag, 1));
                totalauto += _lib.to_double(this.getColValue(this.cols[i].col_tag, 2));
                totalinv += _lib.to_double(this.getColValue(this.cols[i].col_tag, 3));
                ++i;
            }
            this.setColValue("total", 1, _lib.to_string(totalapoio));
            this.setColValue("total", 2, _lib.to_string(totalauto));
            this.setColValue("total", 3, _lib.to_string(totalinv));
            totalapoio = 0.0;
            totalauto = 0.0;
            totalinv = 0.0;
            i = 2;
            while (i < 3 + anos) {
                ++i;
            }
            totalapoio = 0.0;
            totalauto = 0.0;
            totalinv = 0.0;
            double invtotal = 0.0;
            double apoiototal = 0.0;
            double autototal = 0.0;
            double per = 0.0;
            double somaPer = 0.0;
            invtotal = _lib.to_double(this.getColValue("total", 3));
            if (invtotal != 0.0) {
                per = _lib.to_double(this.getColValue("total", 1)) / invtotal * 100.0;
            }
            this.setColValue("perc", 1, _lib.to_string(per));
            somaPer += per;
            if (invtotal != 0.0) {
                per = _lib.to_double(this.getColValue("total", 2)) / invtotal * 100.0;
            }
            this.setColValue("perc", 2, _lib.to_string(per));
            this.setColValue("perc", 3, _lib.to_string(somaPer += per));
            invtotal = 0.0;
            if (_lib.to_double(this.getColValue("total", 3)) != 0.0) {
                invtotal += _lib.to_double(this.getColValue("total", 3));
            }
            double _totalApoio = _lib.to_double(this.getColValue("total", 1));
            CBData.FinancIndR.getByName("totalApoio").setStringValue(_lib.to_string(_totalApoio));
        }
        this.numerarAll(0);
        CBData.calcInvestimentos(this.showIVA);
        this.handler.j.repaint();
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("--");
        int anoI = this.ano_inicio;
        while (anoI <= this.ano_fim) {
            mask.append("R");
            ++anoI;
        }
        mask.append("---");
        return mask.toString();
    }

    public void clear233Vals() {
        int i = 2;
        while (i < this.cols.length) {
            this.setColValue(this.cols[i].col_tag, 3, "");
            ++i;
        }
    }

    public void set2331Vals(Vector<DateInv> v) {
        double prev = 0.0;
        for (DateInv inv : v) {
            double dif;
            if (_lib.to_double(inv.getAno()) < (double)this.ano_inicio || !(2.0 + (dif = _lib.to_double(inv.getAno()) - (double)this.ano_inicio) < (double)this.cols.length)) continue;
            prev = _lib.to_double(this.getColValue(this.cols[2 + (int)dif].col_tag, 3));
            this.setColValue(this.cols[2 + (int)dif].col_tag, 3, _lib.to_string(prev + inv.getInv()));
        }
    }

    public void set2332Vals(Vector<DateInv> v) {
        for (DateInv inv : v) {
            double dif;
            if (_lib.to_double(inv.getAno()) < (double)this.ano_inicio || !(2.0 + (dif = _lib.to_double(inv.getAno()) - (double)this.ano_inicio) < (double)this.cols.length)) continue;
            this.setColValue(this.cols[2 + (int)dif].col_tag, 3, _lib.to_string(inv.getInv()));
        }
    }

    public void set2333Vals(Vector<DateInv> v) {
        double prev = 0.0;
        for (DateInv inv : v) {
            double dif;
            if (_lib.to_double(inv.getAno()) < (double)this.ano_inicio || !(2.0 + (dif = _lib.to_double(inv.getAno()) - (double)this.ano_inicio) < (double)this.cols.length)) continue;
            prev = _lib.to_double(this.getColValue(this.cols[2 + (int)dif].col_tag, 3));
            this.setColValue(this.cols[2 + (int)dif].col_tag, 3, _lib.to_string(prev + inv.getInv()));
        }
    }

    public void set2331Total(double t) {
        this.setColValue("total", 3, _lib.to_string(t));
    }

    public void setTotalInv(double t) {
        this.setColValue("total", 3, _lib.to_string(t));
        CBData.FinancIndR.getByName("totalSiva").setStringValue(_lib.to_string(t));
        CBData.Operacao.getByName("investimento_total").setStringValue(_lib.to_string(t));
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Estrutura de Financiamento");
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("Financiamento", "Lista vazia"));
        } else {
            double soma = 0.0;
            soma = _lib.round(_lib.to_double(this.getColValue("total", 1)), 2) + _lib.round(_lib.to_double(this.getColValue("total", 2)), 2);
            if (_lib.round(soma, 2) != _lib.round(_lib.to_double(this.getColValue("total", 3)), 2)) {
                err_list.add_msg(new CHValid_Msg("Total", "Valor de apoio e autofinancimanto n\u00e3o verificam o investimento!"));
            }
        }
        return err_list;
    }
}

