/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabela;
import fme.CTabelas;
import fme.Frame_Accoes4;
import fme.GroupableTableHeaderUI;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.util.Vector;
import javax.swing.JComboBox;

class CBTabela_plano_accao
extends CBTabela {
    Frame_Accoes4 PAG = (Frame_Accoes4)fmeFrame.Paginas.getPage("Accoes4");
    int n_anos = 1;
    int ano_i;

    @Override
    public String getPagina() {
        return "Accoes4";
    }

    CBTabela_plano_accao() {
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    void updateUI(int ano_i, int ano_f) {
        if (ano_f > 2020) {
            ano_f = 2020;
        }
        this.ano_i = 2013;
        this.n_anos = 3;
        this.cols = new CHTabColModel[17];
        this.cols[0] = new CHTabColModel("dossier", "N\u00ba Dossier", 3, false, true, null);
        this.cols[1] = new CHTabColModel("class", "Classifica\u00e7\u00e3o de despesas", 3, true, false, null);
        this.cols[2] = new CHTabColModel("class_d", "Classifica\u00e7\u00e3o de despesas", 3, true, true, null);
        this.cols[3] = new CHTabColModel("aquisicao", "Aquisi\u00e7\u00e3o (aaaa-mm)", 3, true, true, CFLib.VLD_ANO_MES);
        this.cols[4] = new CHTabColModel("unids", "N\u00ba de Unid.", 3, true, true, null);
        this.cols[5] = new CHTabColModel("desc", "Descritivo", 3, true, true, null);
        this.cols[6] = new CHTabColModel("iva", "Taxa de IVA", 3, true, true, null);
        this.cols[7] = new CHTabColModel("custo_ano1", "Custo - 2013", 3, true, true, CFLib.VLD_VALOR_0);
        this.cols[8] = new CHTabColModel("eleg_ano1", "Elegivel", 3, false, true, CFLib.VLD_VALOR_0);
        this.cols[9] = new CHTabColModel("custo_ano2", "Custo - 2014", 3, true, true, CFLib.VLD_VALOR_0);
        this.cols[10] = new CHTabColModel("eleg_ano2", "Elegivel", 3, false, true, CFLib.VLD_VALOR_0);
        this.cols[11] = new CHTabColModel("custo_ano3", "Custo - 2015", 3, true, true, CFLib.VLD_VALOR_0);
        this.cols[12] = new CHTabColModel("eleg_ano3", "Elegivel", 3, false, true, CFLib.VLD_VALOR_0);
        this.cols[13] = new CHTabColModel("custo_total", "Total", 3, false, true, CFLib.VLD_VALOR_0);
        this.cols[14] = new CHTabColModel("eleg_total", "Total", 3, false, true, CFLib.VLD_VALOR_0);
        this.cols[15] = new CHTabColModel("areatematica", "\u00c1rea Tem\u00e1tica", 3, false, false, null);
        this.cols[16] = new CHTabColModel("tema", "Requisitos legais", 3, true, false, null);
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(5, this.PAG.getJTable_Indicadores2());
        this.ui.add_col(0, 0, 1, 5, "<html>N\u00ba<br>Dossier</html>");
        this.ui.add_col(1, 0, 1, 5, "<html>Classifica\u00e7\u00e3o de despesas</html>");
        this.ui.add_col(2, 0, 1, 5, "<html>Aquisi\u00e7\u00e3o<br>(aaaa-mm)</html>");
        this.ui.add_col(3, 0, 1, 5, "<html>N\u00ba de Unid.</html>");
        this.ui.add_col(4, 0, 1, 5, "<html>Descritivo</html>");
        this.ui.add_col(5, 0, 1, 5, "<html>Taxa de IVA</html>");
        this.ui.add_col(6, 0, 2, 2, "<html>2014</html>");
        this.ui.add_col(6, 2, 1, 3, "<html>Custo</html>");
        this.ui.add_col(7, 2, 1, 3, "<html>Custo Eleg\u00edvel</html>");
        this.ui.add_col(8, 0, 2, 2, "<html>2015</html>");
        this.ui.add_col(8, 2, 1, 3, "<html>Custo</html>");
        this.ui.add_col(9, 2, 1, 3, "<html>Custo Eleg\u00edvel</html>");
        this.ui.add_col(10, 0, 2, 2, "<html>2016</html>");
        this.ui.add_col(10, 2, 1, 3, "<html>Custo</html>");
        this.ui.add_col(11, 2, 1, 3, "<html>Custo Eleg\u00edvel</html>");
        this.ui.add_col(12, 0, 2, 2, "<html>Total</html>");
        this.ui.add_col(12, 2, 1, 3, "<html>Custo Total</html>");
        this.ui.add_col(13, 2, 1, 3, "<html>Custo Eleg\u00edvel</html>");
        this.PAG.getJTable_Indicadores2().getTableHeader().setUI(this.ui);
        this.init_handler(this.PAG.getJTable_Indicadores2());
        this.PAG.getJTable_Indicadores2().tab = this;
        this.PAG.getJTable_Indicadores2().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Indicadores2().getWidth() - 2;
        this.handler.set_col_text(0, 0.08, "C");
        this.handler.set_col_comboS(2, 0.3, null, CTabelas.classdespesas, 1, 300);
        this.handler.set_col_text(3, 0.1, "L");
        this.handler.set_col_text(4, 0.1, "L");
        this.handler.set_col_text(5, 0.2, "L");
        this.handler.set_col_comboS(6, 0.15, null, CTabelas.Iva, 1, 100);
        this.handler.set_col_text(7, 0.15, "L");
        this.handler.set_col_text(8, 0.15, "L");
        this.handler.set_col_text(9, 0.15, "L");
        this.handler.set_col_text(10, 0.15, "L");
        this.handler.set_col_text(11, 0.15, "L");
        this.handler.set_col_text(12, 0.15, "L");
        this.handler.set_col_text(13, 0.15, "L");
        this.handler.set_col_text(14, 0.15, "L");
    }

    void _populate_reqs(SteppedComboBox cboFiltered, int row) {
        String n_local = this.getColValue("tema_d", row);
        CTabela N_local = new CTabela();
        Vector<String> locs = new Vector<String>();
        String areatematica = this.getColValue("areatematica", row);
        N_local.dCol = 4;
        N_local.cCol = 4;
        if (CBData.swot.dados.isEmpty()) {
            N_local.data_table = new Vector();
        } else {
            int i = 0;
            while (i < CBData.swot.dados.size()) {
                if (areatematica.equals(CBData.swot.getColValue("areatematica", i)) && !CBData.swot.getColValue("tema_d", i).equalsIgnoreCase("") && !locs.contains(CBData.swot.getColValue("tema_d", i))) {
                    N_local.data_table.add((String[])CBData.swot.dados.elementAt(i));
                    locs.add(CBData.swot.getColValue("tema_d", i));
                }
                ++i;
            }
        }
        N_local._populateComboBox((JComboBox)cboFiltered, n_local);
    }

    void updateIvas() {
        int i = 0;
        while (i < this.dados.size()) {
            int c = 11;
            while (c < this.cols.length - 2) {
                this.on_update(this.cols[c].col_tag, i, "");
                ++c;
            }
            ++i;
        }
        this.handler.j.repaint();
    }

    void initialize() {
        this.tag = "orcamento";
        this.started = true;
        this.updateUI(2008, 2012);
        this.init_dados(10);
    }

    public void updateAnos() {
        int i = 0;
        while (i < this.dados.size()) {
            int c = 11;
            while (c < 11 + this.n_anos * 2) {
                this.setColValue(this.cols[c].col_tag, i, "");
                ++c;
            }
            this.on_update("custo_n" + this.ano_i, i, "");
            ++i;
        }
    }

    private void calc(int c) {
        if (this.isEmpty()) {
            return;
        }
        boolean isPagante = CBData.RegimeIva.isStdIva() || CBData.RegimeIva.isRata();
        boolean isProRata = CBData.RegimeIva.isRata();
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String val = this.getColValue(c, i);
                if (val.equals("") || this.getColValue("iva", i).equals("") || !isPagante) {
                    this.setColValue(c + 1, i, val);
                } else {
                    double valor = _lib.to_double(val);
                    double perc = (double)Integer.parseInt(this.getColValue("iva", i)) / 100.0;
                    double rata = 1.0;
                    if (isProRata) {
                        rata = _lib.to_double(CBData.RegimeIva.getByName("pro_rata").getStringValue()) / 100.0;
                    }
                    this.setColValue(c + 1, i, String.valueOf(_lib.round(valor *= 1.0 - rata * perc / (1.0 + perc))));
                }
            }
            ++i;
        }
    }

    void _populate_areatematica(SteppedComboBox cboFiltered, int row) {
        String n_local = this.getColValue("areatematica_d", row);
        CTabela N_local = new CTabela();
        Vector<String> locs = new Vector<String>();
        N_local.dCol = 3;
        N_local.cCol = 3;
        if (CBData.swot.dados.isEmpty()) {
            N_local.data_table = new Vector();
        } else {
            int i = 0;
            while (i < CBData.swot.dados.size()) {
                if (!CBData.swot.getColValue("areatematica_d", i).equalsIgnoreCase("") && !locs.contains(CBData.swot.getColValue("areatematica_d", i))) {
                    N_local.data_table.add((String[])CBData.swot.dados.elementAt(i));
                    locs.add(CBData.swot.getColValue("areatematica_d", i));
                }
                ++i;
            }
        }
        N_local._populateComboBox((JComboBox)cboFiltered, n_local);
    }

    void _filter_populate_freguesias(SteppedComboBox cboFiltered, int row) {
        String freguesia = this.getColValue("freg", row);
        String concelho = this.getColValue("conc", row);
        if (concelho.length() == 0) {
            CTabelas.FreguesiasF1.clear_combo();
        } else {
            CTabelas.FreguesiasF1.set_filter(2, concelho);
        }
        CTabelas.FreguesiasF1._populateComboBox((JComboBox)cboFiltered, freguesia);
    }

    private double getTotalAno(String ano) {
        double val = 0.0;
        int i = 0;
        while (i < this.dados.size()) {
            val += _lib.to_double(this.getColValue(ano, i));
            ++i;
        }
        return val;
    }

    void _populate_entidade(SteppedComboBox cboFiltered, int row) {
        String n_local = this.getColValue("n_ent", row);
        CTabela N_local = new CTabela();
        Vector<String> locs = new Vector<String>();
        N_local.dCol = 0;
        N_local.cCol = 0;
        if (CBData.Organizacao.dados.isEmpty()) {
            N_local.data_table = new Vector();
        } else {
            int i = 0;
            while (i < CBData.Organizacao.dados.size()) {
                if (!CBData.Organizacao.getColValue("n_entidade", i).equalsIgnoreCase("") && !locs.contains(CBData.Organizacao.getColValue("n_entidade", i))) {
                    N_local.data_table.add((String[])CBData.Organizacao.dados.elementAt(i));
                    locs.add(CBData.Organizacao.getColValue("n_entidade", i));
                }
                ++i;
            }
        }
        N_local._populateComboBox((JComboBox)cboFiltered, n_local);
    }

    @Override
    void on_update(String tag, int row, String v) {
        int col;
        int c;
        if (tag.equals("class_d")) {
            this.setColValue("class", row, CTabelas.classdespesas.lookup(1, v, 0));
            this.on_update("custo_n" + this.ano_i, 0, "");
        }
        if (tag.equals("iva")) {
            c = 7;
            while (c < this.cols.length - 2) {
                this.on_update(this.cols[c].col_tag, row, "");
                ++c;
            }
        }
        if (tag.startsWith("custo_ano")) {
            col = 0;
            int c2 = 7;
            boolean idx = false;
            double total = 0.0;
            while (c2 < this.cols.length) {
                if (this.cols[c2].col_tag.startsWith("custo_ano")) {
                    total += _lib.to_double(this.getColValue(this.cols[c2].col_tag, row));
                    if (tag.equals(this.cols[c2].col_tag)) {
                        col = c2;
                    }
                }
                ++c2;
            }
            this.setColValue("custo_total", row, total == 0.0 ? "" : _lib.to_string(_lib.round(total)));
            this.on_update("custo_total", row, total == 0.0 ? "" : _lib.to_string(_lib.round(total)));
            this.calc(col);
        }
        if (tag.startsWith("custo_ano")) {
            c = 7;
            boolean idx = false;
            double total = 0.0;
            while (c < this.cols.length) {
                if (this.cols[c].col_tag.startsWith("eleg_ano")) {
                    total += _lib.to_double(this.getColValue(this.cols[c].col_tag, row));
                }
                ++c;
            }
            this.setColValue("eleg_total", row, total == 0.0 ? "" : _lib.to_string(_lib.round(total)));
            this.on_update("eleg_total", row, total == 0.0 ? "" : _lib.to_string(_lib.round(total)));
        }
        if (tag.startsWith("custo_ano")) {
            col = 7;
            boolean rHum = false;
            boolean aServ = true;
            int rMat = 2;
            int outros = 3;
            double[][] a = new double[4][this.cols.length - col];
            int i = 0;
            while (i < this.dados.size()) {
                int c3 = col;
                while (c3 < this.cols.length) {
                    int pos;
                    int n = this.getColValue("class", i).equals("09") || this.getColValue("class", i).equals("10") || this.getColValue("class", i).equals("11") || this.getColValue("class", i).equals("12") || this.getColValue("class", i).equals("14") || this.getColValue("class", i).equals("15") ? 0 : (this.getColValue("class", i).equals("08") || this.getColValue("class", i).equals("13") || this.getColValue("class", i).equals("16") ? 1 : (this.getColValue("class", i).equals("01") || this.getColValue("class", i).equals("02") || this.getColValue("class", i).equals("03") || this.getColValue("class", i).equals("04") || this.getColValue("class", i).equals("05") || this.getColValue("class", i).equals("06") ? 2 : (pos = this.getColValue("class", i).equals("07") ? 3 : -1)));
                    if (pos >= 0) {
                        double[] dArray = a[pos];
                        int n2 = c3 - col;
                        dArray[n2] = dArray[n2] + _lib.to_double(this.getColValue(this.cols[c3].col_tag, i));
                    }
                    ++c3;
                }
                ++i;
            }
            String ano = tag.split("custo_ano", 2)[1];
            CBData.prog_financ.setColValue("ano" + ano, 7, _lib.to_string(this.getTotalAno(tag)));
            CBData.prog_financ.setColValue("ano" + ano, 6, _lib.to_string(this.getTotalAno("eleg_ano" + ano)));
            CBData.prog_financ.on_update("ano", 0, v);
        }
        this.numerar(0);
    }

    public String getRubricaFromLine(int l) {
        return this.getColValue("rubrica_d", l);
    }

    public String getDescricaoFromLine(int l) {
        return this.getColValue("desc", l);
    }

    public String getTotalFromLine(int l) {
        return this.getColValue("total", l);
    }

    public String getEntidadeFromLine(int l) {
        return this.getColValue("n_ent", l);
    }

    public boolean getTotalFromYears() {
        double val_ano1 = 0.0;
        double val_ano2 = 0.0;
        double val_ano3 = 0.0;
        int i = 0;
        while (i < this.dados.size()) {
            val_ano1 += _lib.to_double(this.getColValue("custo_ano1", i));
            val_ano2 += _lib.to_double(this.getColValue("custo_ano2", i));
            val_ano3 += _lib.to_double(this.getColValue("custo_ano3", i));
            ++i;
        }
        return val_ano1 * val_ano2 * val_ano3 > 0.0;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Or\u00e7amento da Opera\u00e7\u00e3o" + nt);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("", "Tabela encontra-se vazia"));
        }
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.getColValue("dossier", i).isEmpty() && this.getColValue("class", i).isEmpty() && !this.getColValue("class_d", i).isEmpty()) {
                err_list.add_msg(new CHValid_Msg(new TabError(i, this.getColIndex("aquisicao"), this), "Linha %L: Classifica\u00e7\u00e3o de despesas - %o, o valor selecionado n\u00e3o se aplica a esta Medida "));
            }
            if (!(this.getColValue("aquisicao", i).equals("") || CBData.accoes4.getByName("data_i").isEmpty() || CBData.accoes4.getByName("data_f").isEmpty())) {
                double ano_i = _lib.to_double(CBData.accoes4.getByName((String)"data_i").v.split("-")[0]);
                double mes_i = _lib.to_double(CBData.accoes4.getByName((String)"data_i").v.split("-")[1]);
                double ano_f = _lib.to_double(CBData.accoes4.getByName((String)"data_f").v.split("-")[0]);
                double mes_f = _lib.to_double(CBData.accoes4.getByName((String)"data_f").v.split("-")[1]);
                double ano_c = _lib.to_double(this.getColValue("aquisicao", i).split("-")[0]);
                double mes_c = _lib.to_double(this.getColValue("aquisicao", i).split("-")[1]);
                if (ano_i <= ano_c && ano_c <= ano_f) {
                    if (ano_i == ano_c && mes_c < mes_i || ano_f == ano_c && mes_c > mes_f) {
                        err_list.add_msg(new CHValid_Msg("aquisicao", "Linha " + (i + 1) + ": Aquisi\u00e7\u00e3o fora do per\u00edodo indicado"));
                    }
                } else {
                    err_list.add_msg(new CHValid_Msg("aquisicao", "Linha " + (i + 1) + ": Aquisi\u00e7\u00e3o fora do per\u00edodo indicado"));
                }
            }
            if (!this.getColValue("class_d", i).isEmpty() && this.getColValue("custo_ano1", i).isEmpty() && this.getColValue("custo_ano2", i).isEmpty() && this.getColValue("custo_ano3", i).isEmpty()) {
                err_list.add_msg(new CHValid_Msg("custo_ano1", "Linha " + (i + 1) + " - Preenchimento Obrigat\u00f3rio de pelo menos um ano de despesas"));
            }
            String mask = this.getMask(i);
            TabError[] e = this.isIncompletAll(i, mask);
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg(e[ii]));
                ++ii;
            }
            ++i;
        }
        if (!this.getTotalFromYears()) {
            err_list.add_msg(new CHValid_Msg("custo_n2012", "Tem que existir despesas nos 3 anos da Opera\u00e7\u00e3o"));
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("");
        int j = this.getColIndex("iva");
        int i = 0;
        while (i < this.cols.length) {
            if (i == j || i > 6) {
                mask.append("-");
            } else {
                mask.append(this.cols[i].visible && this.cols[i].editable ? "R" : "-");
            }
            ++i;
        }
        return mask.toString();
    }
}

