/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Accoes5;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;

class CBTabela_FinancInd
extends CBTabela {
    Frame_Accoes5 PAG = null;
    int financiamento = -1;
    int investimento = -1;
    int div_instCred = -1;
    int div_outros = -1;
    int elegivel = -1;
    int ano_inicio;
    int ano_fim;
    int n_anos;

    @Override
    public String getPagina() {
        return "Accoes5";
    }

    CBTabela_FinancInd() {
        this.tag = "progFin";
        this.PAG = (Frame_Accoes5)fmeFrame.Paginas.getPage("Accoes5");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.PAG.getJTable_Indicadores3().addKeyListener(new TableKeyListener(this));
        int anoI = 2013;
        int anoF = 2015;
        this.on_update_limites(anoI, anoF);
        this.init_dados(CTabelas.Variacoes_2.data_table.size());
        ((CHTabQuadro)this.handler).start_rows();
        this.keyCol = 0;
        String nota = "";
        String s = "";
        int n = 0;
        int i = 0;
        while (i < this.df_nlines) {
            String[] row = CTabelas.Variacoes_2.data_table.elementAt(i);
            if (row[0].equals("0401")) {
                this.div_instCred = i;
            } else if (row[0].equals("0499")) {
                this.div_outros = i;
            } else if (row[0].equals("90")) {
                this.financiamento = i;
            } else if (row[0].equals("91")) {
                this.investimento = i;
            }
            if (row[0].equals("92")) {
                this.elegivel = i;
            }
            ((String[])this.dados.elementAt((int)i))[0] = row[0];
            ((String[])this.dados.elementAt((int)i))[1] = row[1];
            if (!row[2].equals("S")) {
                ((CHTabQuadro)this.handler).row_editable[i] = false;
            }
            if (!row[3].equals("*")) {
                ((CHTabQuadro)this.handler).row_autocalc[i] = row[3];
            }
            if (!row[4].equals("*")) {
                nota = String.valueOf(nota) + s + row[4];
                s = "<br>";
                ++n;
            }
            ++i;
        }
    }

    void on_update_limites(int ano_i, int ano_f) {
        if (!this.started) {
            return;
        }
        this.n_anos = ano_f - ano_i + 1;
        this.cols = new CHTabColModel[8];
        this.cols[0] = new CHTabColModel("cod", "", 3, false, false, null);
        this.cols[1] = new CHTabColModel("rub", "Rubricas", 3, false, true, null);
        this.cols[2] = new CHTabColModel("ano1", "2014", 3, true, true, CFLib.VLD_VALOR_0);
        this.cols[3] = new CHTabColModel("ano2", "2015", 3, true, true, CFLib.VLD_VALOR_0);
        this.cols[4] = new CHTabColModel("ano3", "2016", 3, true, true, CFLib.VLD_VALOR_0);
        this.cols[5] = new CHTabColModel("Total", "Total", 3, false, true, CFLib.VLD_VALOR_0);
        this.cols[6] = new CHTabColModel("perc", "%", 0, false, true, CFLib.VLD_VALOR_S);
        this.cols[7] = new CHTabColModel("n_ordem", null, 3, false, false, null);
        this.init_handler(new CHTabQuadro(), this.PAG.getJTable_Indicadores3());
        ((CHTabQuadro)this.handler).start_rows();
        this.handler.width = this.PAG.getJScrollPane_Indicadores3().getWidth();
        this.handler.set_col_text(0, 0.3, "L");
        this.handler.set_col_text(2, 0.1, "C");
        this.handler.set_col_text(3, 0.1, "C");
        this.handler.set_col_text(4, 0.1, "C");
        this.handler.set_col_text(5, 0.15, "C");
        this.handler.set_col_text(6, 0.15, "C");
        this.cols[0].disable_row_calc = true;
        this.cols[1].disable_row_calc = true;
        this.cols[this.cols.length - 3].disable_row_calc = true;
        this.cols[this.cols.length - 2].disable_row_calc = true;
        this.cols[this.cols.length - 1].disable_row_calc = true;
        if (this.df_nlines == 0) {
            return;
        }
        ((CHTabQuadro)this.handler).start_rows();
        int j = 0;
        while (j < this.df_nlines) {
            String[] row = CTabelas.Variacoes_2.data_table.elementAt(j);
            if (!row[2].equals("S")) {
                ((CHTabQuadro)this.handler).row_editable[j] = false;
            }
            if (!row[3].equals("*")) {
                ((CHTabQuadro)this.handler).row_autocalc[j] = row[3];
            }
            ++j;
        }
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        this.autocalc();
        if (colname.startsWith("ano")) {
            double tot = 0.0;
            int l = 0;
            while (l < this.dados.size()) {
                int i = 2;
                while (i < this.cols.length - 3) {
                    tot += _lib.to_double(this.getColValue(this.cols[i].col_tag, l));
                    ++i;
                }
                this.setColValue("Total", l, tot >= 0.0 ? _lib.to_string(tot) : "");
                tot = 0.0;
                ++l;
            }
            double totinv = _lib.to_double(this.getColValue("Total", 7));
            int l2 = 0;
            while (l2 < this.dados.size()) {
                double val = _lib.to_double(this.getColValue("Total", l2));
                if (totinv > 0.0) {
                    this.setColValue("perc", l2, _lib.to_string(val / totinv * 100.0));
                }
                ++l2;
            }
            boolean dic = this.getColValue("Total", this.div_instCred).length() > 0 && !this.getColValue("Total", this.div_instCred).equals("0");
            boolean bl = this.getColValue("Total", this.div_outros).length() > 0 && !this.getColValue("Total", this.div_outros).equals("0");
        }
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Programa\u00e7\u00e3o Financeira Anual - Fontes de Financiamento ");
        }
        int i = 0;
        while (i < this.dados.size()) {
            String mask = this.getMask(i);
            TabError[] e = this.isIncompletAll(i, mask);
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg(e[ii]));
                ++ii;
            }
            ++i;
        }
        double ft = _lib.to_double(this.getColValue("Total", this.financiamento));
        double it = _lib.to_double(this.getColValue("Total", this.investimento));
        double iet = _lib.to_double(this.getColValue("Total", this.elegivel));
        if (ft != it) {
            err_list.add_msg(new CHValid_Msg("Total", "O Financiamento Total (" + _lib.to_format(ft) + ") deve ser igual ao Investimento Total."));
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("");
        int i = 0;
        while (i < this.cols.length) {
            mask.append(((CHTabQuadro)this.handler).row_editable[nRow] && this.cols[i].visible && this.cols[i].editable ? "R" : "-");
            ++i;
        }
        return mask.toString();
    }
}

