/*
 * Decompiled with CFR 0.152.
 */
package fme;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JComboBox;

class CTabela {
    String name;
    String[] titles;
    Vector<String[]> data_table = new Vector();
    int cCol;
    int dCol;

    public CTabela() {
    }

    public CTabela(String nome) {
        this._init_tab(nome, nome);
        this.cCol = 0;
        this.dCol = 1;
    }

    public CTabela(String nome, String filename) {
        this._init_tab(nome, filename);
        this.cCol = 0;
        this.dCol = 1;
    }

    public String getCodeFromIndex(int idx) {
        return this.getColFromIndex(idx, this.cCol);
    }

    public String getDesignFromIndex(int idx) {
        return this.getColFromIndex(idx, this.dCol);
    }

    public String getColFromIndex(int idx, int nCol) {
        if (idx == 0) {
            return "";
        }
        String[] item = this.data_table.elementAt(idx - 1);
        return item[nCol];
    }

    String lookup(String codigo) {
        return this.lookup(this.cCol, codigo, this.dCol);
    }

    String lookup(int _cCol, String codigo, int _dCol) {
        if (codigo.length() > 0) {
            int i = 0;
            while (i < this.data_table.size()) {
                String[] item = this.data_table.elementAt(i);
                if (item[_cCol].equals(codigo)) {
                    return item[_dCol];
                }
                ++i;
            }
        }
        return "";
    }

    Vector<String> lookupMultiple(int _cCol, String codigo, int _dCol) {
        Vector<String> v = new Vector<String>();
        if (codigo.length() > 0) {
            int i = 0;
            while (i < this.data_table.size()) {
                String[] item = this.data_table.elementAt(i);
                if (item[_cCol].equals(codigo)) {
                    v.add(item[_dCol]);
                }
                ++i;
            }
        }
        return v;
    }

    int getIndexFromCode(String codigo) {
        return this.getIndexFromCol(this.cCol, codigo);
    }

    int getIndexFromDesign(String codigo) {
        return this.getIndexFromCol(this.dCol, codigo);
    }

    String getCodeFromDesign(String codigo) {
        int n = this.getIndexFromCol(this.dCol, codigo);
        return this.getCodeFromIndex(n);
    }

    int getIndexFromCol(int col, String codigo) {
        if (codigo == null || codigo.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < this.data_table.size()) {
            String[] item = this.data_table.elementAt(i);
            if (item[col].equals(codigo)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getDesign(String code) {
        int n = this.getIndexFromCode(code);
        return this.getDesignFromIndex(n + 1);
    }

    public void _populateComboBox(JComboBox cbo, String v) {
        this._populateComboBox(cbo, this.dCol, v);
    }

    public void _populateComboBox(JComboBox cbo, int nCol, String v) {
        int n;
        if (this._populateComboBox(cbo, nCol) && v.length() > 0 && (n = this.getIndexFromCode(v)) >= 0) {
            cbo.setSelectedIndex(n + 1);
        }
    }

    public boolean _populateComboBox(JComboBox cbo) {
        return this._populateComboBox(cbo, this.dCol);
    }

    public boolean _populateComboBox(JComboBox cbo, int nCol) {
        cbo.removeAllItems();
        cbo.addItem("");
        int i = 0;
        while (i < this.data_table.size()) {
            String[] item = this.data_table.elementAt(i);
            cbo.addItem(item[nCol]);
            ++i;
        }
        return true;
    }

    public boolean _init_tab(String tabname, String filename) {
        String s;
        BufferedReader in;
        block4: {
            this.name = tabname;
            in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(String.valueOf(filename) + ".tab"), "CP1252"));
            s = in.readLine();
            if (s != null) break block4;
            return false;
        }
        try {
            this.titles = this.explode(s);
            while ((s = in.readLine()) != null) {
                this.data_table.add(this.explode(s));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public String[] explode(String s) {
        int n_elem = 0;
        String[] temp = new String[20];
        int i = s.indexOf(124, 0);
        while (i > 0) {
            temp[n_elem] = new String(s.substring(0, i));
            ++n_elem;
            s = s.substring(i + 1);
            i = s.indexOf(124, 0);
        }
        if (s.length() > 0) {
            temp[n_elem] = new String(s);
            ++n_elem;
        }
        String[] a_row = new String[n_elem];
        i = 0;
        while (i < n_elem) {
            a_row[i] = temp[i];
            ++i;
        }
        return a_row;
    }
}

