/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelaF1;
import fme.CTabelas;
import fme.Frame_Orcamento;
import fme.GroupableTableHeaderUI;
import fme.SteppedComboBox;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

class CBTabela_Orcamento
extends CBTabela {
    double percFeader = 0.85;
    double percOe = 0.15;
    Frame_Orcamento PAG = null;
    String pag = "Orcamento";

    @Override
    public String getPagina() {
        return this.pag;
    }

    CBTabela_Orcamento() {
        this.tag = "OrcamentoProjectoTab";
        this.PAG = (Frame_Orcamento)fmeFrame.Paginas.getPage(this.pag);
        if (this.PAG == null) {
            return;
        }
        this.PAG.TabelaOrcamento = this;
        this.started = true;
        this.cols = new CHTabColModel[7];
        this.cols[0] = new CHTabColModel("classEconom", "Classe Econ\u00f3mica", 3, true, true, null);
        this.cols[1] = new CHTabColModel("descricao", "Descri\u00e7\u00e3o", 3, false, true, null);
        this.cols[2] = new CHTabColModel("despTotal", "Despesa Total", 3, true, true, CFLib.VLD_INT);
        this.cols[3] = new CHTabColModel("iva", "IVA", 3, true, true, CFLib.VLD_INT);
        this.cols[4] = new CHTabColModel("despPublica", "Despesa Publica", 3, false, true, CFLib.VLD_VALOR_02);
        this.cols[5] = new CHTabColModel("feader", "FEADER", 3, false, true, CFLib.VLD_VALOR_02);
        this.cols[6] = new CHTabColModel("oe", "OE", 3, false, true, CFLib.VLD_VALOR_02);
        this.init_dados(10);
        this.init_handler(this.PAG.getJTableTip_Orcamento());
        this.PAG.getJTableTip_Orcamento().tab = this;
        this.PAG.getJTableTip_Orcamento().setName("Tabela_Orcamento");
        this.PAG.getJTableTip_Orcamento().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Orcamento().getWidth() - 21;
        this.init_handler(this.PAG.getJTableTip_Orcamento());
        this.handler.width = this.PAG.getJScrollPane_Orcamento().getWidth();
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.PAG.getJTableTip_Orcamento());
        this.ui.add_col(0, 0, 1, 2, "<html>Classific.<br/> Econ\u00f3mica</html>");
        this.ui.add_col(1, 0, 1, 2, "<html>Descri\u00e7\u00e3o</html>");
        this.ui.add_col(2, 0, 1, 2, "<html>Despesa</html>");
        this.ui.add_col(3, 0, 1, 2, "<html>IVA</html>");
        this.ui.add_col(4, 0, 1, 2, "<html>Despesa<br/>P\u00fablica</html>");
        this.ui.add_col(5, 0, 2, 1, "<html>Fonte Financiamento</html>");
        this.ui.add_col(5, 1, 1, 1, "<html>FEADER</html>");
        this.ui.add_col(6, 1, 1, 1, "<html>OE</html>");
        this.PAG.getJTableTip_Orcamento().getTableHeader().setUI(this.ui);
        this.handler.set_col_comboF(0, 0.11, "L", CTabelas.ClassificEconomicaF1, 0, 90);
        this.handler.set_col_text(1, 0.2, "L");
        this.handler.set_col_text(2, 0.3, "R");
        this.handler.set_col_text(3, 0.2, "R");
        this.handler.set_col_text(4, 0.23, "R");
        this.handler.set_col_text(5, 0.23, "R");
        this.handler.set_col_text(6, 0.23, "R");
    }

    private double TotalOfCol(String colname) {
        double total = 0.0;
        int k = 0;
        while (k < this.dados.size()) {
            total += _lib.to_double(this.getColValue(colname, k));
            ++k;
        }
        return total;
    }

    public void _filter_populate_classificEconomica(SteppedComboBox combo, int row) {
        if (CBData.Promotor.PAG.getJCheckBox_AutonomiaFinanc_Nao().isSelected()) {
            CTabelaF1 filter = CTabelas.ClassificEconomicaF1;
            Vector<String[]> data_table = new Vector<String[]>();
            int k = 0;
            while (k < filter.data_table.size()) {
                String[] items = (String[])filter.data_table.elementAt(k);
                if (items[0].indexOf("04") != 0 && items[0].indexOf("08") != 0 && items[0].indexOf("03") != 0 && items[0].indexOf("05") != 0) {
                    data_table.add(items);
                }
                ++k;
            }
            if (data_table.size() > 0) {
                filter.data_table = data_table;
                filter._populateComboBox((JComboBox)combo, 0);
            }
        } else {
            CTabelas.ClassificEconomicaF1 = new CTabelaF1(CTabelas.ClassificEconomica, "ClassificEconomicaF1");
            CTabelas.ClassificEconomicaF1.set_filter(1, "Movimento");
            CTabelas.ClassificEconomicaF1._populateComboBox((JComboBox)combo, 0);
        }
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        super.on_update(colname, nRow, v);
        if ((colname.equals("classEconom") || colname.equals("descricao")) && this.getColValue(0, nRow).length() > 0) {
            String code = this.getColValue(0, nRow);
            String descricao = CTabelas.ClassificEconomicaF1.lookup(0, code, 2);
            this.setColValue(1, nRow, descricao);
            this.calcTotalPerRubrica();
            return;
        }
        if (this.getColValue(0, nRow).length() == 0) {
            this.setColValue(1, nRow, "");
            this.setColValue(4, nRow, "");
            this.setColValue(5, nRow, "");
            this.setColValue(6, nRow, "");
            this.setColValue("iva", nRow, "");
            this.setColValue("despTotal", nRow, "");
            this.calcTotalPerRubrica();
        }
        boolean calcularCampos = false;
        if (CBData.reading_xml && (colname.equals("despPublica") || colname.equals("feader") || colname.equals("oe"))) {
            calcularCampos = true;
        }
        if (colname.equals("despTotal") || colname.equals("iva") || calcularCampos) {
            double despTotal = 0.0;
            double iva = 0.0;
            try {
                despTotal = _lib.to_double(this.getColValue("despTotal", nRow));
                iva = _lib.to_double(this.getColValue("iva", nRow));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Use ponto (.) como separador decimal. Ex.: 4.7");
                this.setColValue(colname, nRow, "");
                return;
            }
            if (iva > despTotal) {
                this.setColValue("iva", nRow, "");
                iva = 0.0;
            }
            double despPub = despTotal - iva;
            double feader = Math.round(despPub * this.percFeader);
            double oe = Math.round(despPub * this.percOe);
            if (despPub == 0.0) {
                this.setColValue("despPublica", nRow, "");
            } else {
                this.setColValue("despPublica", nRow, String.valueOf(despPub));
            }
            if (feader == 0.0) {
                this.setColValue("feader", nRow, "");
            } else {
                this.setColValue("feader", nRow, String.valueOf(feader));
            }
            if (oe == 0.0) {
                this.setColValue("oe", nRow, "");
            } else {
                this.setColValue("oe", nRow, String.valueOf(oe));
            }
            this.calcTotalPerRubrica();
        }
    }

    @Override
    boolean on_copy_row() {
        super.on_del_row();
        this.calcTotalPerRubrica();
        return true;
    }

    @Override
    boolean on_del_row() {
        super.on_del_row();
        this.calcTotalPerRubrica();
        return true;
    }

    private void calcTotalPerRubrica() {
        double despesaTotal = this.TotalOfCol("despTotal");
        double despesaPublica = this.TotalOfCol("despPublica");
        double totalFeader = this.TotalOfCol("feader");
        double totalOe = this.TotalOfCol("oe");
        CBData.OrcamentoProjectoReg.getByName("totalDespTotal").setStringValue(String.valueOf(despesaTotal));
        CBData.OrcamentoProjectoReg.getByName("totalDespPublica").setStringValue(String.valueOf(despesaPublica));
        CBData.OrcamentoProjectoReg.getByName("totalFreader").setStringValue(String.valueOf(totalFeader));
        CBData.OrcamentoProjectoReg.getByName("totalOe").setStringValue(String.valueOf(totalOe));
        CBData.Calendarizacao.getByName("montanteTotal").setStringValue(String.valueOf(despesaTotal));
        CBData.Calendarizacao.getByName("montanteEleg").setStringValue(String.valueOf(despesaPublica));
        CBData.Calendarizacao.getByName("valorFeader").setStringValue(String.valueOf(totalFeader));
        CBData.Calendarizacao.getByName("valorOe").setStringValue(String.valueOf(totalOe));
        try {
            CBData.Calendarizacao.getByName("percOe").setStringValue(String.valueOf(this.percOe * 100.0));
            CBData.Calendarizacao.getByName("percFeader").setStringValue(String.valueOf(this.percFeader * 100.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        double despTotal = 0.0;
        double despPub = 0.0;
        double feader = 0.0;
        double oe = 0.0;
        double total_iva = 0.0;
        String value = "";
        int[] values = new int[]{1, 2, 4, 6, 7};
        boolean sumIva = true;
        int x = 0;
        while (x < values.length) {
            String ntotal = "desptotal0" + values[x];
            String npublica = "desppublica0" + values[x];
            String nfeader = "feader0" + values[x];
            String noe = "oe0" + values[x];
            int k = 0;
            while (k < this.dados.size()) {
                value = this.getColValue("classEconom", k);
                if (value.indexOf("0" + values[x]) == 0 || value.indexOf("00" + values[x]) == 0) {
                    despTotal += _lib.to_double(this.getColValue("despTotal", k));
                    despPub += _lib.to_double(this.getColValue("despPublica", k));
                    feader += _lib.to_double(this.getColValue("feader", k));
                    oe += _lib.to_double(this.getColValue("oe", k));
                }
                if (sumIva) {
                    total_iva += _lib.to_double(this.getColValue("iva", k));
                }
                ++k;
            }
            sumIva = false;
            CBData.OrcamentoProjectoReg.getByName(ntotal).setStringValue(String.valueOf(despTotal));
            CBData.OrcamentoProjectoReg.getByName(npublica).setStringValue(String.valueOf(despPub));
            CBData.OrcamentoProjectoReg.getByName(nfeader).setStringValue(String.valueOf(feader));
            CBData.OrcamentoProjectoReg.getByName(noe).setStringValue(String.valueOf(oe));
            oe = 0.0;
            feader = 0.0;
            despPub = 0.0;
            despTotal = 0.0;
            ++x;
        }
        CBData.OrcamentoProjectoReg.getByName("totalIva").setStringValue(String.valueOf(total_iva));
    }

    CHValid_Grp validar(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Or\u00e7amento do Projecto");
        }
        boolean isEmpty = true;
        boolean isPreviousRowEmpty = false;
        ArrayList emptyMiddleRows = new ArrayList();
        ArrayList<Integer> emptyConsecutiveRows = new ArrayList<Integer>();
        int k = 0;
        while (k < this.dados.size()) {
            if (this.getColValue("classEconom", k).length() == 0 && (this.getColValue("despTotal", k).length() > 0 || this.getColValue("iva", k).length() > 0)) {
                err_list.add_msg(new CHValid_Msg("classEconom", "A coluna \"Classific. Econ\u00f3mica nunca deve estar vazia quando a \"Despesa\" e/ou \"IVA\" est\u00e1 preenchido. - %o"));
                return err_list;
            }
            if (this.getColValue("classEconom", k).length() > 0 && (this.getColValue("despTotal", k).length() == 0 || this.getColValue("iva", k).length() == 0)) {
                err_list.add_msg(new CHValid_Msg("", "Sempre que uma c\u00e9lula da coluna \"Classific. Econ\u00f3mica\" \u00e9 preenchida toda a linha da tabela deve ser preenchida. - %o"));
                return err_list;
            }
            if (this.getColValue("classEconom", k).length() > 0 && this.getColValue("despTotal", k).length() > 0 && this.getColValue("iva", k).length() > 0) {
                isEmpty = false;
                if (isPreviousRowEmpty) {
                    emptyMiddleRows.addAll(emptyConsecutiveRows);
                    emptyConsecutiveRows.clear();
                    isPreviousRowEmpty = false;
                }
            } else {
                emptyConsecutiveRows.add(k + 1);
                isPreviousRowEmpty = true;
            }
            ++k;
        }
        if (isEmpty) {
            err_list.add_msg(new CHValid_Msg("", "A tabela encontra-se vazia. Deve ser preenchida pelo menos uma linha completa. - %o"));
        } else if (emptyMiddleRows.size() > 0) {
            StringBuilder sb = new StringBuilder();
            if (emptyMiddleRows.size() > 1) {
                sb.append("As linhas ");
            } else {
                sb.append("A linha ");
            }
            int i = 0;
            while (i < emptyMiddleRows.size()) {
                if (i == emptyMiddleRows.size() - 1 && emptyMiddleRows.size() > 1) {
                    sb.append(" e ");
                } else if (i != 0) {
                    sb.append(", ");
                }
                sb.append(emptyMiddleRows.get(i));
                ++i;
            }
            if (emptyMiddleRows.size() > 1) {
                sb.append(" est\u00e3o vazias e dever\u00e3o ser apagadas");
            } else {
                sb.append(" est\u00e1 vazia e dever\u00e1 ser apagada");
            }
            err_list.add_msg(new CHValid_Msg("", sb.toString()));
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("RRR");
        return mask.toString();
    }

    CHValid_Grp validar1(CHValid_Grp err_list, String err_text) {
        return err_list;
    }
}

