/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_Calendarizacao;
import fme.fmeFrame;
import java.text.SimpleDateFormat;
import java.util.Calendar;

class CBRegisto_Calendarizacao
extends CBRegisto {
    Frame_Calendarizacao PAG = null;

    CBRegisto_Calendarizacao() {
        this.tag = "Calendarizacao";
        this.PAG = (Frame_Calendarizacao)fmeFrame.Paginas.getPage("Calendarizacao");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("dataInicio", this.PAG.getJTextField_DataInicio(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("dataConclusao", this.PAG.getJTextField_DataConclusao(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("montanteTotal", this.PAG.getJTextField_MontanteTotal(), CFLib.VLD_VALOR_02, this));
        this.Campos.add(new CHCampo_Text("montanteEleg", this.PAG.getJTextField_MontanteElegivel(), CFLib.VLD_VALOR_02, this));
        this.Campos.add(new CHCampo_Text("valorFeader", this.PAG.getJTextField_ValorFeader(), CFLib.VLD_VALOR_02, this));
        this.Campos.add(new CHCampo_Text("percFeader", this.PAG.getJTextField_PercentagemFeader(), CFLib.VLD_VALOR_02, this));
        this.Campos.add(new CHCampo_Text("valorOe", this.PAG.getJTextField_ValorOE(), CFLib.VLD_VALOR_02, this));
        this.Campos.add(new CHCampo_Text("percOe", this.PAG.getJTextField_PercentagemOE(), CFLib.VLD_VALOR_02, this));
        this.Campos.add(new CHCampo_Text("programa", this.PAG.getJTextField_Programa(), null, this));
        this.Campos.add(new CHCampo_Text("medida", this.PAG.getJTextField_Medida(), null, this));
        this.Campos.add(new CHCampo_Text("projecto", this.PAG.getJTextField_Projecto(), null, this));
        this.Campos.add(new CHCampo_Text("designProjecto", this.PAG.getJTextField_DesignacaoProjecto(), null, this));
        this.getByName("percOe").setStringValue("");
    }

    public void init() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.getByName("dataInicio").setStringValue(sdf.format(CBData.calMinProjecto.getTime()));
        this.getByName("dataConclusao").setStringValue(sdf.format(CBData.calMaxProjecto.getTime()));
        this.on_update("dataInicio");
        this.on_update("dataConclusao");
    }

    public void clear_another() {
        this.getByName("montanteTotal").setStringValue("");
        this.getByName("montanteEleg").setStringValue("");
        this.getByName("valorFeader").setStringValue("");
        this.getByName("percFeader").setStringValue("");
        this.getByName("valorOe").setStringValue("");
        this.getByName("percOe").setStringValue("");
    }

    @Override
    public String getPagina() {
        return this.tag;
    }

    @Override
    void on_update(String tag) {
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        String[] arr;
        String data;
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Calendariza\u00e7\u00e3o e cobertura financeira");
        }
        this.extract();
        int ini_length = 0;
        int end_length = 0;
        String ano = CBData.Promotor.PAG.getjTextField_AnoCand().getText();
        if (this.PAG.getJTextField_DataInicio().getText().length() == 0) {
            err_list.add_msg(new CHValid_Msg("dataInicio", "Data Prevista Inicio - %o"));
        } else {
            data = this.PAG.getJTextField_DataInicio().getText();
            arr = data.split("-");
            ini_length = arr[0].length();
            if (arr[0].length() != 4) {
                err_list.add_msg(new CHValid_Msg("dataInicio", "Data Prevista Inicio: Formato correcto aaaa-mm-dd  - %o"));
            }
        }
        if (this.PAG.getJTextField_DataConclusao().getText().length() == 0) {
            err_list.add_msg(new CHValid_Msg("dataConclusao", "Data Prevista Conclus\u00e3o - %o"));
        } else {
            data = this.PAG.getJTextField_DataConclusao().getText();
            arr = data.split("-");
            end_length = arr[0].length();
            if (arr[0].length() != 4) {
                err_list.add_msg(new CHValid_Msg("dataConclusao", "Data Prevista Conclus\u00e3o: Formato correcto aaaa-mm-dd  - %o"));
            }
        }
        if (ini_length == 4 && end_length == 4 && this.PAG.getJTextField_DataConclusao().getText().length() == 10 && this.PAG.getJTextField_DataInicio().getText().length() == 10) {
            try {
                String[] dtInicio = this.PAG.getJTextField_DataInicio().getText().split("-");
                String[] dtFim = this.PAG.getJTextField_DataConclusao().getText().split("-");
                int ano1 = Integer.parseInt(dtInicio[0]);
                int ano2 = Integer.parseInt(dtFim[0]);
                int mes1 = Integer.parseInt(dtInicio[1]);
                int mes2 = Integer.parseInt(dtFim[1]);
                int dia1 = Integer.parseInt(dtInicio[2]);
                int dia2 = Integer.parseInt(dtFim[2]);
                Calendar calInicio = Calendar.getInstance();
                calInicio.clear();
                calInicio.set(ano1, mes1 - 1, dia1, 0, 0, 0);
                Calendar calFim = Calendar.getInstance();
                calFim.clear();
                calFim.set(ano2, mes2 - 1, dia2, 0, 0, 0);
                if (calFim.before(calInicio)) {
                    err_list.add_msg(new CHValid_Msg("dataConclusao", "A \"Data Prevista Conclus\u00e3o\" (dia) n\u00e3o pode ser anterior \u00e0 \"Data Prevista Inicio\" - %o"));
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (CBData.calMinProjecto != null && calInicio.before(CBData.calMinProjecto)) {
                    err_list.add_msg(new CHValid_Msg("dataInicio", "A \"Data Prevista Inicio\" n\u00e3o pode ser anterior a " + sdf.format(CBData.calMinProjecto.getTime())));
                }
                if (CBData.calMaxProjecto != null && calFim.after(CBData.calMaxProjecto)) {
                    err_list.add_msg(new CHValid_Msg("dataConclusao", "A \"Data Prevista Conclus\u00e3o\" n\u00e3o pode ser posterior a " + sdf.format(CBData.calMaxProjecto.getTime())));
                }
            }
            catch (Exception e) {
                err_list.add_msg(new CHValid_Msg("dataInicio", "\"Data Prevista Inicio\" ou \"Data Prevista Conclus\u00e3o\" inv\u00e1lida. Formato correcto: aaaa-mm-dd  - %o"));
            }
        }
        if (this.PAG.getJTextField_Programa().getText().length() == 0) {
            err_list.add_msg(new CHValid_Msg("programa", "Programa - %o"));
        }
        if (this.PAG.getJTextField_Medida().getText().length() == 0) {
            err_list.add_msg(new CHValid_Msg("medida", "Medida - %o"));
        }
        if (this.PAG.getJTextField_Projecto().getText().length() == 0) {
            err_list.add_msg(new CHValid_Msg("projecto", "Projecto - %o"));
        }
        if (this.PAG.getJTextField_DesignacaoProjecto().getText().length() == 0) {
            err_list.add_msg(new CHValid_Msg("designProjecto", "Designa\u00e7\u00e3o do Projecto - %o"));
        }
        return err_list;
    }
}

