/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabela;
import fme.CTabelas;
import fme.Frame_QInvAgr;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComboBox;

class CBTabela_QInvAgr
extends CBTabela {
    JComboBox cboEstabs = null;
    Frame_QInvAgr PAG = null;
    CBTabela geo = null;
    String pag = "QInvAgr";
    boolean iva = false;
    CTabela tab = null;
    CTabela tab2 = null;
    int etapa;
    Date datai;
    DateFormat dt = new SimpleDateFormat("yyyy-MM");

    public String getPagina() {
        return this.pag;
    }

    CBTabela_QInvAgr(String pag, String tag, CTabela tab, CTabela tab2, int etapa) {
        this.tag = tag;
        this.pag = pag;
        this.tab = tab;
        this.tab2 = tab2;
        this.etapa = etapa;
        this.PAG = (Frame_QInvAgr)fmeFrame.Paginas.getPage(pag);
        if (this.PAG == null) {
            return;
        }
        this.PAG.CBData_QInvAgr = this;
        this.started = true;
        this.PAG.getJTable_QInvAgr().tab = this;
        this.PAG.getJTable_QInvAgr().setName(tag);
        this.PAG.getJTable_QInvAgr().addKeyListener(new TableKeyListener(this));
        this.on_update_colunas(this.iva);
        this.init_dados(14);
    }

    void on_update_colunas(boolean iva) {
        if (!this.started) {
            return;
        }
        this.iva = iva;
        this.cols = new CHTabColModel[15];
        this.ordCol = 0;
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba no<br>Dossier", true, false, true, null);
        this.cols[1] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[2] = new CHTabColModel("rubinv", null, true, false, false, null);
        this.cols[3] = new CHTabColModel("rubinv_d", "Rubrica de<br>Investimento", true, true, true, null);
        this.cols[4] = new CHTabColModel("aplic", "N.\u00ba do servi\u00e7o", true, true, true, (CFType)CFLib.VLD_INT);
        this.cols[5] = new CHTabColModel("sem_iva", iva ? "Investimento<br>sem IVA" : "Investimento<br>Total", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[6] = new CHTabColModel("escalao", "Escalao", true, true, false, null);
        this.cols[7] = new CHTabColModel("taxa_iva", "Taxa<br>IVA", 2, true, iva, null);
        this.cols[8] = new CHTabColModel("montante", "Investimento<br>com IVA eleg\u00edvel", 2, false, iva, (CFType)CFLib.VLD_VALOR_0);
        this.cols[9] = new CHTabColModel("elegivel", "Investimento<br>Eleg\u00edvel", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[10] = new CHTabColModel("residual", "Valor<br>Residual", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[11] = new CHTabColModel("unidade", null, true, true, false, null);
        this.cols[12] = new CHTabColModel("unidade_d", "Unidade", true, true, true, null);
        this.cols[13] = new CHTabColModel("quantidade", "Quant.", true, true, true, (CFType)CFLib.VLD_VALOR);
        this.cols[14] = new CHTabColModel("calendario", "Realiza\u00e7\u00e3o<br>(aaaa-mm)", true, true, true, (CFType)CFLib.VLD_ANO_MES2);
        this.init_handler(this.PAG.getJTable_QInvAgr());
        this.handler.width = this.PAG.getJScrollPane_QInvAgr().getWidth() - 21;
        this.handler.set_col_text(0, 0.075, "C");
        this.handler.set_col_text(1, 0.25, null);
        this.handler.set_col_comboS(3, 0.28, null, this.tab, 1, 500);
        this.handler.set_col_comboF(4, 0.065, "C", CTabelas.N_Local, 1, 100);
        this.handler.set_col_text(5, 0.15, "R");
        if (iva) {
            this.handler.set_col_comboS(7, 0.075, "C", CTabelas.Iva, 1, 0);
        }
        if (iva) {
            this.handler.set_col_text(8, 0.15, "R");
        }
        this.handler.set_col_text(9, 0.15, "R");
        this.handler.set_col_text(10, 0.15, "R");
        this.handler.set_col_check(11, 0.07);
        this.handler.set_col_comboS(12, 0.14, null, CTabelas.UniExp, 1, 120);
        this.handler.set_col_text(13, 0.12, "R");
        this.handler.set_col_text(14, 0.1, "C");
        if (CBData.QInvAgr == null) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            this.refresh_row(i);
            ++i;
        }
    }

    void refresh_row(int nRow) {
        String montante = this.getColValue("sem_iva", nRow);
        if (this.iva) {
            String escalao = this.getColValue("escalao", nRow);
            if (escalao.length() == 0) {
                montante = "";
            } else if (montante.length() != 0) {
                String taxa_iva = CTabelas.Iva.lookup(0, escalao, 1);
                double valor = Double.parseDouble(montante);
                double taxa = 0.0;
                if (_lib.is_value(taxa_iva, ' ', ' ')) {
                    taxa = _lib.to_double(taxa_iva);
                }
                double rata = 0.0;
                if (CBData.RegimeIva.getByName((String)"regime_iva").v.equals("2")) {
                    rata = CBData.RegimeIva.getByName("pro_rata").valueAsDouble() / 100.0;
                }
                montante = _lib.to_number(valor * (1.0 + taxa / 100.0 * (1.0 - rata)));
            }
        }
        this.setColValue("montante", nRow, montante);
    }

    void _filter_populate_aplic(SteppedComboBox cboFiltered, int row) {
        String rubinv = this.getColValue("rubinv", row);
        String aplic = this.getColValue("aplic", row);
        if (rubinv.length() == 0 || !CTabelas.DespAgr.lookup(0, rubinv, 2).equals("M")) {
            CTabelas.GenEspF1.clear_combo();
        } else {
            CTabelas.GenEspF1.clear_filter();
        }
        CTabelas.GenEspF1._populateComboBox((JComboBox)cboFiltered, aplic);
    }

    void _populate_n_local(SteppedComboBox cboFiltered, int row) {
        String n_local = this.getColValue("aplic", row);
        CTabela N_local = new CTabela();
        Vector<String> locs = new Vector<String>();
        N_local.dCol = 0;
        N_local.cCol = 0;
        if (CBData.LocalInd.dados.isEmpty()) {
            N_local.data_table = new Vector();
        } else {
            int i = 0;
            while (i < CBData.LocalInd.dados.size()) {
                if (!CBData.LocalInd.getColValue("n_estab", i).equalsIgnoreCase("") && !locs.contains(CBData.LocalInd.getColValue("n_estab", i))) {
                    N_local.data_table.add((String[])CBData.LocalInd.dados.elementAt(i));
                    locs.add(CBData.LocalInd.getColValue("n_estab", i));
                }
                ++i;
            }
        }
        N_local._populateComboBox((JComboBox)cboFiltered, n_local);
    }

    boolean on_del_row() {
        if (!super.on_del_row()) {
            return false;
        }
        this.analisar();
        return true;
    }

    boolean on_copy_row() {
        return super.on_copy_row();
    }

    void analisar() {
        String construcoes = "";
        String electrific = "";
        String barragens = "";
        int c = this.getColIndex("rubinv");
        int i = 0;
        while (i < this.dados.size()) {
            String[] row = (String[])this.dados.elementAt(i);
            if (row[c].length() > 0) {
                int cod = Integer.parseInt(row[c]);
                if (cod == 95) {
                    electrific = "1";
                }
                if (cod >= 100 && cod < 120) {
                    barragens = "1";
                }
                if (cod == 120) {
                    barragens = "1";
                }
                if (cod >= 130 && cod < 160) {
                    barragens = "1";
                }
                if (cod >= 250 && cod < 330) {
                    construcoes = "1";
                }
            }
            ++i;
        }
    }

    void on_update(String colname, int nRow, String v, String x) {
        String rubinv;
        super.on_update(colname, nRow, v, x);
        System.out.println("colname: " + colname + " v: " + v);
        if (colname.equals("rubinv_d") && !(rubinv = CTabelas.Rubricas1.lookup(1, v, 0)).equals(this.getColValue("rubinv", nRow))) {
            this.setColValue("rubinv", nRow, rubinv);
        }
        if (colname.equals("aplic_d")) {
            String aplic = CTabelas.GenEsp.lookup(1, v, 0);
            this.setColValue("aplic", nRow, aplic);
        }
        if (colname.equals("sem_iva")) {
            this.refresh_row(nRow);
        }
        if ((colname.equals("elegivel") || colname.equals("calendario") || colname.equals("entidade") || colname.equals("montante") || colname.equals("sem_iva")) && !this.getColValue("calendario", nRow).equals("") && CBData.Estrutura_Financ.getColIndex("ano" + this.getColValue("calendario", nRow).substring(0, 4)) > -1) {
            CBData.set_investimento(this.iva, this.getColValue("calendario", nRow).substring(0, 4));
        }
        if (colname.equals("escalao")) {
            String taxa_iva = CTabelas.Iva.lookup(0, v, 1);
            this.setColValue("taxa_iva", nRow, taxa_iva);
            this.refresh_row(nRow);
        }
        if (colname.equals("taxa_iva")) {
            String escalao = CTabelas.Iva.lookup(1, v, 0);
            this.setColValue("escalao", nRow, escalao);
            this.refresh_row(nRow);
        }
        if (colname.equals("unidade_d")) {
            String unidade = CTabelas.UniExp.lookup(1, v, 0);
            this.setColValue("unidade", nRow, unidade);
        }
        if (colname.equals("calendario")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            try {
                this.datai = df.parse(this.getColValue(colname, nRow));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.numerar();
        this.analisar();
    }

    CHValid_Grp validar(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("quadro", "Lista vazia"));
        } else {
            Calendar cal = Calendar.getInstance();
            int r = this.getColIndex("rubinv");
            int n = this.getColIndex("n_estab");
            int u = this.getColIndex("unidade");
            int q = this.getColIndex("quantidade");
            int c = this.getColIndex("calendario");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            Date initP = null;
            Date fimP = null;
            if (CBData.ProjInd.getByName((String)"data_inicio").v != "" && CBData.ProjInd.getByName((String)"data_inicio").v != "") {
                initP = new Date(CBData.ProjInd.datei.getYear(), CBData.ProjInd.datei.getMonth(), 1);
                fimP = new Date(CBData.ProjInd.datef.getYear(), CBData.ProjInd.datef.getMonth(), 1);
            }
            int v = this.getColIndex("elegivel");
            int m = this.getColIndex("montante");
            StringBuffer mask = new StringBuffer("RR-RRR-");
            if (this.iva) {
                mask.append("RR");
            } else {
                mask.append("--");
            }
            mask.append("RR-RRR");
            Date six = new Date(70, 6, 1);
            if (initP == null || fimP == null) {
                err_list.add_msg(new CHValid_Msg("data_proj", "Data de realiza\u00e7\u00e3o de projecto nao definida"));
            }
            int i = 0;
            while (i < this.dados.size()) {
                if (!this.isRowEmpty(i)) {
                    String[] row = (String[])this.dados.elementAt(i);
                    TabError[] e = this.isIncompletAll(i, mask.toString());
                    int ii2 = 0;
                    while (e != null && ii2 < e.length) {
                        err_list.add_msg(new CHValid_Msg(e[ii2]));
                        ++ii2;
                    }
                    if (initP != null && fimP != null && this.datai != null) {
                        try {
                            this.datai = this.dt.parse(this.getColValue("calendario", i));
                        }
                        catch (ParseException ii2) {
                            // empty catch block
                        }
                        this.datai = new Date(this.datai.getYear(), this.datai.getMonth(), 1);
                        if (this.datai.before(initP) || this.datai.after(fimP)) {
                            if (row[2].equals("17") || row[2].equals("18")) {
                                if (this.datai.getTime() < initP.getTime() - six.getTime()) {
                                    err_list.add_msg(new CHValid_Msg(new TabError(i, v, this), "Linha %L: Data tem de estar compreendida at\u00e9 6 meses antes da data de \u00ednicio"));
                                }
                            } else {
                                err_list.add_msg(new CHValid_Msg(new TabError(i, v, this), "Linha %L: Data de realiza\u00e7\u00e3o deve estar compreendida entre a data de in\u00edcio e de termo da opera\u00e7\u00e3o"));
                            }
                        }
                    }
                    double eleg = _lib.to_double(row[v]);
                    double inv = _lib.to_double(row[m]);
                    if (_lib.round(eleg) > _lib.round(inv)) {
                        err_list.add_msg(new CHValid_Msg(new TabError(i, v, this), "Linha %L:O Investimento Eleg\u00edvel n\u00e3o pode ser superior ao Investimento Total"));
                    }
                }
                ++i;
            }
        }
        return err_list;
    }
}

