/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_Estrutura_Financ;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;

class CBTabela_Estrutura_Financ
extends CBTabela {
    Frame_Estrutura_Financ PAG = null;
    int init = 0;
    int ano0 = 0;
    int nranos = 0;

    public String getPagina() {
        return "Estrutura_Financ";
    }

    CBTabela_Estrutura_Financ() {
        this.PAG = (Frame_Estrutura_Financ)fmeFrame.Paginas.getPage("Estrutura_Financ");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Estrutura_Financ(Frame_Estrutura_Financ p) {
        this.PAG = p;
        this.force_xml = true;
        this.initialize();
    }

    void initialize() {
        this.tag = "Estrutura_Financ";
        this.started = true;
        this.cols = new CHTabColModel[3 + this.nranos];
        this.keyCol = 0;
        this.cols[0] = new CHTabColModel("rubricas", "Rubricas", 3, false, true, null);
        int i = 1;
        int j = 0;
        while (i <= this.nranos) {
            this.cols[i] = new CHTabColModel("ano" + (this.ano0 + j), "" + (this.ano0 + j), 3, true, true, (CFType)CFLib.VLD_VALOR_S);
            ++i;
            ++j;
        }
        this.cols[1 + this.nranos] = new CHTabColModel("total", "Total", 3, false, true, (CFType)CFLib.VLD_VALOR_S);
        this.cols[2 + this.nranos] = new CHTabColModel("perc", "%", 3, false, true, null);
        this.init_dados(7 - this.init);
        this.init_handler(new CHTabQuadro(), this.PAG.getJTable_Indicadores4());
        this.PAG.getJTable_Indicadores4().tab = this;
        this.PAG.getJTable_Indicadores4().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Indicadores4().getWidth() - 2;
        this.handler.set_col_text(0, 0.4, null);
        i = 1;
        while (i <= this.nranos) {
            this.handler.set_col_text(i, 0.15, "C");
            ++i;
        }
        this.handler.set_col_text(1 + this.nranos, 0.15, "C");
        this.handler.set_col_text(2 + this.nranos, 0.1, "C");
        this.setColValue("rubricas", 0, "Capitais Pr\u00f3prios");
        this.setColValue("rubricas", 1, "Capitais Alheios");
        this.setColValue("rubricas", 2, "\u00a0\u00a0\u00a0\u00a0D\u00edvidas a Institui\u00e7\u00f5es de Cr\u00e9dito");
        this.setColValue("rubricas", 3, "\u00a0\u00a0\u00a0\u00a0Outros");
        this.setColValue("rubricas", 4, "Incentivo N\u00e3o Reembols\u00e1vel (INR)");
        this.setColValue("rubricas", 5, "FINANCIAMENTO TOTAL");
        this.setColValue("rubricas", 6, "INVESTIMENTO TOTAL");
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[1] = false;
        ((CHTabQuadro)this.handler).row_editable[5] = false;
        ((CHTabQuadro)this.handler).row_editable[6] = false;
    }

    void on_update(String tag, int row, String v, String x) {
        if (!tag.equals("rubricas") && this.nranos != 0) {
            if (!tag.equals("perc") && !tag.equals("total")) {
                this.calculaValorLinha(row);
            }
            this.calculaValorColuna(tag);
            if (row == 2 || row == 3) {
                this.calculaValorLinha(1);
            }
            this.calculaValorLinha(6);
            this.calculaPercentagens();
        }
        if (tag.startsWith("ano")) {
            CBData.Doc1.getByName("doc_2031").setStringValue(!this.isRowEmpty(2) ? "1" : "0");
            CBData.Doc1.getByName("doc_2033").setStringValue(!this.isRowEmpty(3) ? "1" : "0");
        }
    }

    public void clear() {
        this.handler.__garbage_stop_editing();
        if (this.handler instanceof CHTabQuadro) {
            int i = 0;
            while (i < this.dados.size()) {
                this.clearRow(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dados.size()) {
                this.clearRow(i);
                ++i;
            }
        }
        this.idx_xml = -1;
        this.handler.j.repaint();
    }

    void clearRow(int i) {
        int j = 1;
        while (j < this.cols.length) {
            ((String[])this.dados.elementAt((int)i))[j] = "";
            if (((String[])this.dados.elementAt(i))[j] == null) {
                ((String[])this.dados.elementAt((int)i))[j] = "";
            }
            this.on_update(this.cols[j].col_tag, i, "", "");
            ++j;
        }
    }

    void calculaValorColuna(String colName) {
        double capitaisAlheios = 0.0;
        double financiamentoTotal = 0.0;
        capitaisAlheios = _lib.round(_lib.to_double(this.getColValue(colName, 2)), 2) + _lib.round(_lib.to_double(this.getColValue(colName, 3)), 2);
        financiamentoTotal = this.init == 0 ? _lib.round(_lib.to_double(this.getColValue(colName, 0)), 2) + capitaisAlheios + _lib.round(_lib.to_double(this.getColValue(colName, 4)), 2) : _lib.round(_lib.to_double(this.getColValue(colName, 0)), 2) + capitaisAlheios;
        this.setColValue(colName, 1, _lib.to_string(capitaisAlheios));
        if (this.init == 0) {
            this.setColValue(colName, 5, _lib.to_string(financiamentoTotal));
        } else {
            this.setColValue(colName, 4, _lib.to_string(financiamentoTotal));
        }
        this.handler.j.repaint();
    }

    void calculaValorLinha(int row) {
        double total = 0.0;
        int i = this.getColIndex("ano" + this.ano0);
        int j = 0;
        while (i < this.getColIndex("total")) {
            total += _lib.round(_lib.to_double(this.getColValue("ano" + (this.ano0 + j), row)), 2);
            ++i;
            ++j;
        }
        this.setColValue("total", row, _lib.to_string(total));
        this.handler.j.repaint();
    }

    void calculaPercentagens() {
        this.setColValue("perc", 0, "");
        this.setColValue("perc", 1, "");
        this.setColValue("perc", 2, "");
        this.setColValue("perc", 3, "");
        this.setColValue("perc", 4, "");
        this.setColValue("perc", 5, "");
        this.setColValue("perc", 6, "");
        double percentagem = 0.0;
        int selrow = 0;
        selrow = 6;
        int i = 0;
        while (i < this.dados.size() - 1) {
            if (_lib.to_double(this.getColValue("total", selrow)) != 0.0 && (percentagem = _lib.round(_lib.to_double(this.getColValue("total", i)), 2) * 100.0 / _lib.round(_lib.to_double(this.getColValue("total", selrow)), 2)) > 0.0) {
                this.setColValue("perc", i, _lib.to_string(percentagem));
            }
            ++i;
        }
        this.handler.j.repaint();
    }

    public void verificaInvTotalFinTotal(CHValid_Grp err_list) {
        int i = this.ano0;
        while (i != this.ano0 + this.nranos) {
            double inv_total_ano;
            String ano = "ano" + i;
            double fin_total_ano = _lib.to_double(this.getColValue("ano" + i, 5));
            if (fin_total_ano != (inv_total_ano = _lib.to_double(this.getColValue("ano" + i, 6)))) {
                err_list.add_msg(new CHValid_Msg("ano" + ano, "O Investimento Total dever\u00e1 ser igual ao Financiamento Total"));
            }
            ++i;
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Estrutura de Financiamento (Recursos Financeiros)" + nt);
        }
        this.verificaInvTotalFinTotal(err_list);
        return err_list;
    }
}

