/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Dialog_Valid_jButton_Close_actionAdapter;
import fme.Dialog_Valid_jButton_Go_actionAdapter;
import fme.Dialog_Valid_jButton_Imp_actionAdapter;
import fme.Dialog_Valid_tree_mouseAdapter;
import fme.MyTreeRenderer;
import fme.fmeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class Dialog_Valid
extends JDialog {
    private static final long serialVersionUID = 1L;
    JPanel contentPane;
    JButton cmdImp;
    JButton cmdGo;
    JButton cmdSair;
    JButton cmdConfirmar;
    public String form;
    public String campo;
    public int row;
    public int col;
    public int erros;
    public int avisos;
    public boolean global;
    DefaultMutableTreeNode root;
    JLabel lblErro = new JLabel();
    JLabel lblAviso = new JLabel();
    JScrollPane scrollPane = new JScrollPane();
    private JTree tree;
    JLabel label = new JLabel();
    int nodes_total = 0;
    JPanel pnl = new JPanel();
    String cmd = "";
    public static ImageIcon erroIcon = new ImageIcon(fmeFrame.class.getResource("erro.gif"));
    public static ImageIcon avisoIcon = new ImageIcon(fmeFrame.class.getResource("aviso.gif"));

    public Dialog_Valid(DefaultMutableTreeNode _root, int _erros, int _avisos, boolean _global) {
        try {
            this.root = _root;
            this.erros = _erros;
            this.avisos = _avisos;
            this.global = _global;
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(null);
        this.form = null;
        this.campo = null;
        this.cmdImp = new JButton();
        this.cmdGo = new JButton();
        this.cmdSair = new JButton();
        this.cmdConfirmar = new JButton();
        this.cmdImp.setMaximumSize(new Dimension(77, 27));
        this.cmdImp.setMinimumSize(new Dimension(77, 27));
        this.cmdImp.setPreferredSize(new Dimension(77, 27));
        this.cmdImp.setText("Imprimir");
        this.cmdImp.setBounds(new Rectangle(210, 17, 110, 30));
        this.cmdImp.addActionListener(new Dialog_Valid_jButton_Imp_actionAdapter(this));
        this.cmdImp.setMargin(new Insets(1, 1, 1, 1));
        this.cmdGo.setMaximumSize(new Dimension(77, 27));
        this.cmdGo.setMinimumSize(new Dimension(77, 27));
        this.cmdGo.setPreferredSize(new Dimension(77, 27));
        this.cmdGo.setText("Ir at\u00e9 ao quadro");
        this.cmdGo.setBounds(new Rectangle(330, 17, 110, 30));
        this.cmdGo.addActionListener(new Dialog_Valid_jButton_Go_actionAdapter(this));
        this.cmdGo.setMargin(new Insets(1, 1, 1, 1));
        this.cmdSair.setMnemonic('n');
        this.cmdSair.setText("Sair");
        this.cmdSair.setBounds(new Rectangle(450, 17, 110, 30));
        this.cmdSair.addActionListener(new Dialog_Valid_jButton_Close_actionAdapter(this));
        this.lblErro.setBounds(new Rectangle(5, 13, 80, 36));
        this.lblErro.setIcon(erroIcon);
        this.lblErro.setVerticalTextPosition(0);
        this.lblErro.setVerticalAlignment(0);
        this.lblErro.setHorizontalTextPosition(4);
        this.lblErro.setHorizontalAlignment(2);
        this.lblAviso.setBounds(new Rectangle(85, 13, 80, 36));
        this.lblAviso.setIcon(avisoIcon);
        this.lblAviso.setVerticalTextPosition(0);
        this.lblAviso.setVerticalAlignment(0);
        this.lblAviso.setHorizontalTextPosition(4);
        this.lblAviso.setHorizontalAlignment(2);
        this.scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.setBounds(new Rectangle(4, 12, 560, 272));
        this.pnl.setLayout(null);
        this.pnl.setBounds(new Rectangle(3, 275, 561, 50));
        this.tree = new JTree(this.root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setBackground(new Color(212, 208, 200));
        this.tree.setOpaque(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(0);
        this.tree.setSelectionRow(0);
        this.tree.setScrollsOnExpand(true);
        this.tree.setRootVisible(true);
        this.tree.setLargeModel(true);
        this.tree.putClientProperty("JTree.lineStyle", "Horizontal");
        this.tree.setCellRenderer(new MyTreeRenderer());
        this.tree.addMouseListener(new Dialog_Valid_tree_mouseAdapter(this));
        this.expandAll(this.root);
        this.setTitle("Valida\u00e7\u00f5es - Lista de Erros e Avisos");
        this.lblErro.setText(String.valueOf(this.erros) + " Erro" + (this.erros != 1 ? "s" : ""));
        this.lblAviso.setText(String.valueOf(this.avisos) + " Aviso" + (this.avisos != 1 ? "s" : ""));
        contentPane.add((Component)this.scrollPane, "North");
        this.scrollPane.getViewport().add(this.tree);
        contentPane.add((Component)this.pnl, "South");
        if (this.global) {
            this.pnl.add((Component)this.cmdImp, null);
            this.pnl.add((Component)this.cmdGo, "East");
        }
        this.pnl.add((Component)this.cmdSair, null);
        this.pnl.add((Component)this.lblErro, null);
        this.pnl.add((Component)this.lblAviso, null);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(575, 355);
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getSize().height / 2);
        this.setVisible(true);
    }

    void tree_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.vaiAteForm();
        }
    }

    private void expandAll(TreeNode tNode) {
        TreePath tp = new TreePath(((DefaultMutableTreeNode)tNode).getPath());
        this.tree.expandPath(tp);
        int i = 0;
        while (i < tNode.getChildCount()) {
            this.expandAll(tNode.getChildAt(i));
            ++i;
        }
    }

    void jButton_Close_actionPerformed(ActionEvent e) {
        this.cmd = "X";
        this.setVisible(false);
    }

    void jButton_Imp_actionPerformed(ActionEvent e) {
        this.imprimir();
    }

    void imprimir() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = pj.defaultPage();
        pj.setPrintable(new Printer(this.root, this.erros, this.avisos), pf);
        try {
            pj.print();
        }
        catch (PrinterException e) {
            System.out.println("Erro a imprimir!");
        }
    }

    void jButton_Go_actionPerformed(ActionEvent e) {
        this.vaiAteForm();
    }

    void vaiAteForm() {
        DefaultMutableTreeNode s = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (s == null) {
            return;
        }
        if (s instanceof CHValid_Msg) {
            CHValid_Grp h = (CHValid_Grp)s.getParent();
            h.handler.locate((CHValid_Msg)s);
            this.cmd = "G";
            this.setVisible(false);
        }
    }

    private class Printer
    implements Printable {
        DefaultMutableTreeNode _root;
        int _erros;
        int _avisos;
        int _maxPage;
        Vector lines = null;
        int currLine = 0;
        boolean printed = true;
        PageFormat _pf = null;
        final Font fonte = new Font("Serif", 0, 10);
        final int PaginaX = 30;
        final int ErrorTypeX = 40;
        final int ErroX = 50;
        final int lineHeight = 15;

        Printer(DefaultMutableTreeNode root, int erros, int avisos) {
            this._root = root;
            this._erros = erros;
            this._avisos = avisos;
            this._maxPage = 999;
        }

        private Vector populate(DefaultMutableTreeNode root) {
            Vector<Lines> vc = new Vector<Lines>();
            int nrPages = this._root.getChildCount();
            DefaultMutableTreeNode Pages = this._root.getNextNode();
            while (nrPages > 0) {
                vc.add(new Lines(Pages.toString(), 30, false));
                int nrErrorSInPage = Pages.getChildCount();
                while (nrErrorSInPage > 0) {
                    Pages = Pages.getNextNode();
                    vc.add(new Lines(Pages.toString(), 40, false));
                    int nrErrorInSeccion = Pages.getChildCount();
                    while (nrErrorInSeccion > 0) {
                        Pages = Pages.getNextNode();
                        Vector res = this.quebraLinhas(Pages.toString(), (int)this._pf.getImageableWidth() - 50);
                        int i = 0;
                        while (i < res.size()) {
                            vc.add(new Lines((String)res.get(i), 50, false));
                            ++i;
                        }
                        --nrErrorInSeccion;
                    }
                    --nrErrorSInPage;
                }
                --nrPages;
                vc.add(new Lines(null, 0, true));
                Pages = Pages.getNextNode();
            }
            return vc;
        }

        public Vector quebraLinhas(String texto, int largura) {
            Vector<String> resultado = new Vector<String>();
            JPanel metrica = new JPanel();
            if (this.fonte == null || texto == null || texto.length() == 0) {
                return resultado;
            }
            if (largura <= 0) {
                largura = 415;
            }
            String esta = "";
            String anterior = "";
            if (texto.lastIndexOf("\n") < 0) {
                StringTokenizer trataString = new StringTokenizer(texto);
                while (trataString.hasMoreTokens()) {
                    String parte = trataString.nextToken();
                    esta = esta.length() == 0 ? parte : String.valueOf(esta) + " " + parte;
                    if (metrica.getFontMetrics(this.fonte).stringWidth(esta) > largura) {
                        resultado.addElement(new String(String.valueOf(anterior) + "\n"));
                        esta = parte;
                    }
                    anterior = esta;
                }
                if (anterior.length() > 0) {
                    resultado.addElement(new String(String.valueOf(anterior) + "\n"));
                }
            } else {
                StringTokenizer trataString = new StringTokenizer(texto, "\n");
                while (trataString.hasMoreTokens()) {
                    resultado.addElement(new String(trataString.nextToken()));
                }
            }
            return resultado;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
            if (this._pf == null) {
                this._pf = pf;
            }
            if (this.lines == null) {
                this.lines = this.populate(this._root);
            }
            if (page >= this._maxPage) {
                return 1;
            }
            if (this.printed) {
                this.printed = false;
                return 0;
            }
            this.printed = true;
            g.setFont(this.fonte);
            Graphics2D g2d = (Graphics2D)g;
            int currY = 13;
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, (int)pf.getImageableWidth(), 15);
            g.setColor(Color.WHITE);
            g.drawString("Lista de Erros", 2, currY);
            g.setColor(Color.BLACK);
            g.drawString(this._root.toString(), 20, currY += 15);
            g.setColor(Color.BLUE);
            g.drawLine(0, currY += 2, (int)pf.getImageableWidth(), currY);
            g.setColor(Color.BLACK);
            g.fillRect(0, (int)pf.getImageableHeight() - 30, (int)pf.getImageableWidth(), 15);
            g.setColor(Color.WHITE);
            g.drawString("Formul\u00e1rio PRODER", 2, (int)pf.getImageableHeight() - 17);
            g.drawString("P\u00e1gina " + (page + 1), (int)pf.getImageableWidth() - 55, (int)pf.getImageableHeight() - 17);
            g.setColor(Color.BLACK);
            g.drawString("Promotor: " + CBData.Promotor.getByName((String)"nome").v, 2, (int)pf.getImageableHeight() - 2);
            int availableHeight = (int)pf.getImageableHeight() - 15 - 30 - 15;
            g.setColor(Color.RED);
            int nrLinesToDraw = availableHeight / 15;
            if (this._maxPage == 999) {
                this._maxPage = this.lines.size() / nrLinesToDraw + 1;
            }
            int i = 0;
            while (i < nrLinesToDraw && this.currLine < this.lines.size()) {
                Lines line = (Lines)this.lines.get(this.currLine);
                if (line._isLine) {
                    g.setColor(Color.BLUE);
                    g.drawLine(0, currY += 5, (int)pf.getImageableWidth(), currY);
                } else {
                    g.setColor(Color.BLACK);
                    g.drawString(line._text, line._ident, currY += 15);
                }
                ++i;
                ++this.currLine;
            }
            return 0;
        }

        private class Lines {
            boolean _isLine;
            String _text;
            int _ident;

            public Lines(String t, int ident, boolean isLine) {
                this._text = t;
                this._ident = ident;
                this._isLine = isLine;
            }
        }
    }
}

