/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo_Text;
import fme.CHCampo_TextArea;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_Accoes4;
import fme._lib;
import fme.fmeFrame;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

class CBRegisto_Accoes4
extends CBRegisto {
    Frame_Accoes4 acc2 = null;

    @Override
    public String getPagina() {
        return "Accoes4";
    }

    CBRegisto_Accoes4() {
        this.tag = "Operacao";
        this.acc2 = (Frame_Accoes4)fmeFrame.Paginas.getPage("Accoes4");
        if (this.acc2 == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("data_rec", this.acc2.getJTextField_data_rec(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("data_i", this.acc2.getJTextField_initInv(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("data_f", this.acc2.getJTextField_endInv(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("regi", this.acc2.getJTextField_iva(), null, this));
        this.Campos.add(new CHCampo_Text("termo", this.acc2.getJTextField_termo(), null, this));
        this.Campos.add(new CHCampo_TextArea("inf_comp", this.acc2.getJTextArea_Txt1(), this));
    }

    public void afterOpen() {
    }

    @Override
    void on_update(String tag) {
        if (tag.equals("data_i") || tag.equals("data_f")) {
            int ano_i = 2013;
            int ano_f = 2015;
            if (!this.getByName("data_i").isEmpty()) {
                ano_i = (int)_lib.to_double(this.getByName("data_i").getStringValue().split("-")[0]);
            }
            if (!this.getByName("data_f").isEmpty()) {
                ano_f = (int)_lib.to_double(this.getByName("data_f").getStringValue().split("-")[0]);
                this.getByName("termo").setStringValue(_lib.to_string(ano_f));
            }
            if (ano_f >= ano_i) {
                CBData.prog_financ.on_update_limites(ano_i, ano_f - 1);
            }
        }
    }

    CHValid_Grp validar1(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o da Opera\u00e7\u00e3o");
        }
        this.extract();
        if (this.getByName("data_rec").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("data_rec", "Data do reconhecimento - %o"));
        }
        if (this.getByName("data_i").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("data_i", "Data de in\u00edcio - %o"));
        }
        if (this.getByName("data_f").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("data_f", "Data de conclus\u00e3o - %o"));
        }
        Calendar hoje = Calendar.getInstance();
        Calendar rec = Calendar.getInstance();
        Date data_i = CFType_Data.parse_date(this.getByName("data_i").getStringValue());
        Date data_f = CFType_Data.parse_date(this.getByName("data_f").getStringValue());
        Date data_rec = CFType_Data.parse_date(this.getByName("data_rec").getStringValue());
        if (data_rec != null) {
            rec.setTime(data_rec);
        }
        Date data_rec2 = CFType_Data.parse_date("2013-01-01");
        Date data_rec3 = CFType_Data.parse_date("2008-12-29");
        Date data_rec4 = CFType_Data.parse_date("2015-03-31");
        Date data_rec5 = CFType_Data.parse_date("2013-12-31");
        if (data_rec != null && data_rec2 != null && data_rec.before(data_rec3)) {
            err_list.add_msg(new CHValid_Msg("data_rec", "Data de reconhecimento anterior a 2008-12-29"));
        }
        if (rec != null && hoje != null && hoje.before(rec)) {
            err_list.add_msg(new CHValid_Msg("data_rec", "Data de reconhecimento posterior \u00e0 data de hoje"));
        }
        if (data_i != null && data_rec != null && data_i.before(data_rec)) {
            err_list.add_msg(new CHValid_Msg("data_i", "Data de inicio anterior \u00e0 data do reconhecimento"));
        }
        if (data_i != null && data_rec2 != null && data_i.before(data_rec2)) {
            err_list.add_msg(new CHValid_Msg("data_i", "Data de inicio tem que ser igual ou maior que 2013-01-01"));
        }
        if (data_f != null && data_rec4 != null && data_f.after(data_rec4)) {
            err_list.add_msg(new CHValid_Msg("data_i", "Data de conclus\u00e3o tem que ser anterior ou igual a 2015-03-31"));
        }
        if (data_i != null && data_f != null && data_f.before(data_i)) {
            err_list.add_msg(new CHValid_Msg("data_f", "Data de conclus\u00e3o anterior \u00e0 data de in\u00edcio"));
        }
        StringBuilder sb = new StringBuilder();
        GregorianCalendar d = new GregorianCalendar();
        sb.append(d.get(1));
        sb.append("-");
        sb.append(d.get(2) + 1);
        sb.append("-");
        sb.append(d.get(5));
        Date min_inv = CFType_Data.parse_date(sb.toString());
        if (data_i != null && data_i.before(min_inv)) {
            err_list.add_msg(new CHValid_Msg("data_inicio", "A Data In\u00edcio n\u00e3o pode ser anterior \u00e0 data de submiss\u00e3o"));
        }
        Date data_max = null;
        if (!this.getByName("data_i").isEmpty()) {
            String[] di = this.getByName("data_i").getStringValue().split("-");
            String[] df = this.getByName("data_f").getStringValue().split("-");
            di[0] = _lib.to_string(_lib.to_double(di[0]) + 3.0);
            StringBuffer s = new StringBuffer(String.valueOf(di[0]) + "-");
            s.append(String.valueOf(di[1]) + "-");
            s.append(_lib.to_string(_lib.to_double(di[2])));
            data_max = CFType_Data.parse_date(s.toString());
        }
        return err_list;
    }

    CHValid_Grp validar2(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Or\u00e7amento da Opera\u00e7\u00e3o");
        }
        this.extract();
        if (this.getByName("inf_comp").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("inf_comp", "Informa\u00e7\u00f5es Complementares (Justifica\u00e7\u00e3o dos recursos utilizados) - %o"));
        }
        return err_list;
    }
}

