/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CFType_AnoMes;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabela;
import fme.CTabelas;
import fme.Frame_QInvAgr;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;

class CBTabela_QInvAgr3
extends CBTabela {
    JComboBox cboEstabs = null;
    Frame_QInvAgr PAG = null;
    CBTabela geo = null;
    String pag = "QInvAgr";
    boolean iva = false;
    CTabela tab = null;
    CTabela tab2 = null;
    int etapa;

    public String getPagina() {
        return this.pag;
    }

    CBTabela_QInvAgr3(String pag, String tag, CTabela tab, CTabela tab2, int etapa) {
        this.tag = tag;
        this.pag = pag;
        this.tab = tab;
        this.tab2 = tab2;
        this.etapa = etapa;
        this.PAG = (Frame_QInvAgr)fmeFrame.Paginas.getPage(pag);
        if (this.PAG == null) {
            return;
        }
        this.PAG.CBData_QInvAgr3 = this;
        this.started = true;
        this.PAG.getJTable_QInvAgr().tab = this;
        this.PAG.getJTable_QInvAgr().setName(tag);
        this.PAG.getJTable_QInvAgr().addKeyListener(new TableKeyListener(this));
        this.on_update_colunas(this.iva);
        this.init_dados(14);
    }

    void on_update_colunas(boolean iva) {
        if (!this.started) {
            return;
        }
        this.iva = iva;
        this.cols = new CHTabColModel[17];
        this.ordCol = 0;
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba no<br>Dossier", true, false, true, null);
        this.cols[1] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[2] = new CHTabColModel("rubinv", null, true, false, false, null);
        this.cols[3] = new CHTabColModel("rubinv_d", "Rubrica de<br>Investimento", true, true, true, null);
        this.cols[4] = new CHTabColModel("sem_iva", iva ? "Investimento<br>sem IVA" : "Investimento<br>Total", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[5] = new CHTabColModel("escalao", null, true, true, false, null);
        this.cols[6] = new CHTabColModel("taxa_iva", "Taxa<br>IVA", 2, true, iva, null);
        this.cols[7] = new CHTabColModel("montante", "Investimento<br>com IVA eleg\u00edvel", 2, false, iva, (CFType)CFLib.VLD_VALOR_0);
        this.cols[8] = new CHTabColModel("elegivel", "Investimento<br>Eleg\u00edvel", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[9] = new CHTabColModel("residual", "Valor<br>Residual", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[10] = new CHTabColModel("n_estab", "N\u00ba do<br>Local", true, true, true, null);
        this.cols[11] = new CHTabColModel("vida", "Vida <br>\u00datil", true, true, true, (CFType)CFLib.VLD_NUM_S);
        this.cols[12] = new CHTabColModel("unidade", null, true, true, false, null);
        this.cols[13] = new CHTabColModel("unidade_d", "Unidade", true, true, true, null);
        this.cols[14] = new CHTabColModel("quantidade", "Quant.", true, true, true, (CFType)CFLib.VLD_VALOR);
        this.cols[15] = new CHTabColModel("calendario", "Realiza\u00e7\u00e3o<br>(aaaa-mm)", true, true, true, (CFType)CFLib.VLD_ANO_MES2);
        this.cols[16] = new CHTabColModel("entfinanc", "Entidade<br>Financ.", true, true, true, null);
        this.cols[16].is_check = true;
        this.init_handler(this.PAG.getJTable_QInvAgr());
        this.handler.width = this.PAG.getJScrollPane_QInvAgr().getWidth() - 21;
        this.handler.set_col_text(0, 0.075, "C");
        this.handler.set_col_text(1, 0.25, null);
        this.handler.set_col_comboS(3, 0.28, null, this.tab, 1, 680);
        this.handler.set_col_text(4, 0.15, "R");
        if (iva) {
            this.handler.set_col_comboS(6, 0.075, "C", CTabelas.Iva, 1, 0);
        }
        if (iva) {
            this.handler.set_col_text(7, 0.15, "R");
        }
        this.handler.set_col_text(8, 0.15, "R");
        this.handler.set_col_text(9, 0.15, "R");
        this.cboEstabs = this.handler.set_col_comboD(10, 0.075, "C", this.tab2, 0, 200);
        this.handler.set_col_text(11, 0.15, "C");
        this.handler.set_col_check(12, 0.07);
        this.handler.set_col_comboS(13, 0.14, null, CTabelas.UniExp, 1, 120);
        this.handler.set_col_text(14, 0.12, "R");
        this.handler.set_col_text(15, 0.1, "C");
        this.handler.set_col_check(16, 0.1);
        if (CBData.QInvAgr == null) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            this.refresh_row(i);
            ++i;
        }
    }

    void refresh_row(int nRow) {
        String montante = this.getColValue("sem_iva", nRow);
        if (this.iva) {
            String escalao = this.getColValue("escalao", nRow);
            if (escalao.length() == 0) {
                montante = "";
            } else if (montante.length() != 0) {
                String taxa_iva = CTabelas.Iva.lookup(0, escalao, 1);
                double valor = Double.parseDouble(montante);
                double taxa = 0.0;
                if (_lib.is_value(taxa_iva, ' ', ' ')) {
                    taxa = _lib.to_double(taxa_iva);
                }
                double rata = 0.0;
                if (CBData.RegimeIva.getByName((String)"regime_iva").v.equals("2")) {
                    rata = CBData.RegimeIva.getByName("pro_rata").valueAsDouble() / 100.0;
                }
                montante = _lib.to_number(valor * (1.0 + taxa / 100.0 * (1.0 - rata)));
            }
        }
        this.setColValue("montante", nRow, montante);
    }

    void _filter_populate_aplic(SteppedComboBox cboFiltered, int row) {
        String rubinv = this.getColValue("rubinv", row);
        String aplic = this.getColValue("aplic", row);
        if (rubinv.length() == 0 || !CTabelas.DespAgr.lookup(0, rubinv, 2).equals("M")) {
            CTabelas.GenEspF1.clear_combo();
        } else {
            CTabelas.GenEspF1.clear_filter();
        }
        CTabelas.GenEspF1._populateComboBox((JComboBox)cboFiltered, aplic);
    }

    boolean on_del_row() {
        if (!super.on_del_row()) {
            return false;
        }
        this.analisar();
        return true;
    }

    boolean on_copy_row() {
        return super.on_copy_row();
    }

    void analisar() {
        String construcoes = "";
        String electrific = "";
        String barragens = "";
        int c = this.getColIndex("rubinv");
        int i = 0;
        while (i < this.dados.size()) {
            String[] row = (String[])this.dados.elementAt(i);
            if (row[c].length() > 0) {
                int cod = Integer.parseInt(row[c]);
                if (cod == 95) {
                    electrific = "1";
                }
                if (cod >= 100 && cod < 120) {
                    barragens = "1";
                }
                if (cod == 120) {
                    barragens = "1";
                }
                if (cod >= 130 && cod < 160) {
                    barragens = "1";
                }
                if (cod >= 250 && cod < 330) {
                    construcoes = "1";
                }
            }
            ++i;
        }
    }

    void on_update(String colname, int nRow, String v, String x) {
        String rubinv;
        super.on_update(colname, nRow, v, x);
        if (colname.equals("rubinv_d") && !(rubinv = CTabelas.Rubricas1.lookup(1, v, 0)).equals(this.getColValue("rubinv", nRow))) {
            this.setColValue("rubinv", nRow, rubinv);
            this.updateValue("rubinv_d", nRow, v);
        }
        if (colname.equals("aplic_d")) {
            String aplic = CTabelas.GenEsp.lookup(1, v, 0);
            this.setColValue("aplic", nRow, aplic);
        }
        if (colname.equals("sem_iva")) {
            this.refresh_row(nRow);
            if (!this.iva) {
                CBData.set_investimento(this.iva);
            }
        }
        if (colname.equals("montante") && this.iva) {
            CBData.set_investimento(this.iva);
        }
        if (colname.equals("escalao")) {
            String taxa_iva = CTabelas.Iva.lookup(0, v, 1);
            this.setColValue("taxa_iva", nRow, taxa_iva);
            this.refresh_row(nRow);
        }
        if (colname.equals("taxa_iva")) {
            String escalao = CTabelas.Iva.lookup(1, v, 0);
            this.setColValue("escalao", nRow, escalao);
            this.refresh_row(nRow);
        }
        if (colname.equals("unidade_d")) {
            String unidade = CTabelas.UniExp.lookup(1, v, 0);
            this.setColValue("unidade", nRow, unidade);
        }
        if (colname.equals("entfinanc")) {
            CBData.isFinanciado();
        }
        if (colname.equals("entfinanc") || colname.equals("montante") || colname.equals("calendario") || colname.equals("sem_iva") || colname.equals("taxa_iva")) {
            CBData.updateYearTotals();
            CBData.updateInvYearTotals();
        }
        this.numerar();
        this.analisar();
    }

    CHValid_Grp validar(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        Calendar cal = Calendar.getInstance();
        int r = this.getColIndex("rubinv");
        int n = this.getColIndex("n_estab");
        int u = this.getColIndex("unidade");
        int q = this.getColIndex("quantidade");
        int c = this.getColIndex("calendario");
        int v = this.getColIndex("elegivel");
        int m = this.getColIndex("montante");
        StringBuffer mask = new StringBuffer("-R-RR-");
        if (this.iva) {
            mask.append("RRRRRR-RRR-");
        } else {
            mask.append("--RRR--RRR-");
        }
        Date conce_inicio = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"conce_inicio").v);
        Date conce_fim = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"conce_fim").v);
        Date divulg_inicio = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"divulg_inicio").v);
        Date divulg_fim = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"divulg_fim").v);
        Date incorp_inicio = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"incorp_inicio").v);
        Date incorp_fim = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"incorp_fim").v);
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                int id_rubinv;
                String[] row = (String[])this.dados.elementAt(i);
                if (this.getColValue("vida", i).isEmpty() && this.getColValue("rubinv", i).length() > 0 && (id_rubinv = (int)_lib.to_double(this.getColValue("rubinv", i))) > 0 && id_rubinv < 12) {
                    err_list.add_msg(new CHValid_Msg(new TabError(i, c, this), "Linha %L incompleta: Vida \u00f9til - %o"));
                }
                if (incorp_inicio != null) {
                    Calendar cc = Calendar.getInstance();
                    cc.setTime(incorp_inicio);
                    cc.add(2, -1);
                    Date incorp_inicio_antes = cc.getTime();
                    Date realizacao = CFType_AnoMes.parse_as_date(row[c]);
                    if (!this.getColValue("rubinv_d", i).contains("levantamento") && !this.getColValue("rubinv_d", i).contains("Estudos") && incorp_inicio != null && incorp_fim != null && realizacao != null && (incorp_inicio_antes.after(realizacao) || incorp_fim.before(realizacao))) {
                        err_list.add_msg(new CHValid_Msg(new TabError(i, c, this), "Linha %L: A data de realiza\u00e7\u00e3o n\u00e3o se encontra contida no periodo definido para a Etapa de Incorpora\u00e7\u00e3o de Resultados"));
                    }
                }
                TabError[] e = this.isIncompletAll(i, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg(e[ii]));
                    ++ii;
                }
                double eleg = _lib.to_double(row[v]);
                double inv = _lib.to_double(row[m]);
                if (_lib.round(eleg) > _lib.round(inv)) {
                    err_list.add_msg(new CHValid_Msg(new TabError(i, v, this), "Linha %L: o Eleg\u00edvel n\u00e3o pode ser superior ao Investimento"));
                }
            }
            ++i;
        }
        Date data_base = CFType_AnoMes.parse_as_date("2008-07");
        Date data_temp = null;
        int i2 = 0;
        while (i2 < this.dados.size()) {
            if (!(this.getColValue("calendario", i2).equals("") || (data_temp = CFType_AnoMes.parse_as_date(this.getColValue("calendario", i2))).after(data_base) || data_base.equals(data_temp))) {
                err_list.add_msg(new CHValid_Msg(new TabError(i2, c, this), "Linha %L: A data de realiza\u00e7\u00e3o tem que ser superior a Julho de 2008"));
            }
            ++i2;
        }
        return err_list;
    }
}

