/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CBTabela_Estrutura_Financ;
import fme.CFLib;
import fme.CFType;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_Estrutura_Financiadora;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;

class CBTabela_Estrutura_Financiadora
extends CBTabela {
    int init = 0;
    Frame_Estrutura_Financiadora PAG = null;

    public String getPagina() {
        return "Estrutura_Financiadora";
    }

    CBTabela_Estrutura_Financiadora() {
        this.PAG = (Frame_Estrutura_Financiadora)fmeFrame.Paginas.getPage("Estrutura_Financiadora");
        if (this.PAG == null) {
            return;
        }
        this.initialize();
    }

    CBTabela_Estrutura_Financiadora(Frame_Estrutura_Financiadora p) {
        this.PAG = p;
        this.force_xml = true;
        this.initialize();
    }

    void initialize() {
        this.tag = "Estrutura_Financiadora";
        this.started = true;
        int ano = 0;
        if (CBData.DadosOperacao != null && !CBData.DadosOperacao.getByName("cdataF").isEmpty()) {
            String data = CBData.DadosOperacao.getByName((String)"dataI").v.substring(0, 4);
            ano = (int)_lib.to_double(data);
        }
        String dataF = "";
        int anoF = 0;
        if (CBData.DadosOperacao != null && !CBData.DadosOperacao.getByName("cdataF").isEmpty()) {
            dataF = CBData.DadosOperacao.getByName((String)"cdataF").v.substring(0, 4);
            anoF = (int)_lib.to_double(dataF);
        }
        boolean anoB = false;
        boolean anoC = false;
        if (anoF == 0 || ano == 0) {
            ano = 2009;
            anoF = ano + 6 - 1;
        }
        this.cols = new CHTabColModel[1 + (anoF - ano) + 3];
        this.keyCol = 0;
        this.cols[0] = new CHTabColModel("rubricas", "Rubricas", 3, false, true, null);
        int c = 1;
        int n = 1;
        int anoN = ano;
        int j = 0;
        while (anoN <= anoF) {
            this.cols[c++] = new CHTabColModel("ano" + j, _lib.to_string(anoN), 3, true, true, (CFType)CFLib.VLD_VALOR_S);
            ++j;
            ++n;
            ++anoN;
        }
        this.cols[c++] = new CHTabColModel("total", "Total", 3, true, true, (CFType)CFLib.VLD_VALOR_S);
        this.cols[c++] = new CHTabColModel("perc", "%", 3, false, true, null);
        this.init_dados(5);
        this.init_handler(new CHTabQuadro(), this.PAG.getJTable_Indicadores4());
        this.PAG.getJTable_Indicadores4().tab = this;
        this.PAG.getJTable_Indicadores4().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Indicadores4().getWidth() - 2;
        this.handler.set_col_text(0, 0.4, null);
        c = 1;
        n = 1;
        anoN = ano;
        int u = 1;
        while (u <= 2) {
            this.handler.set_col_text(u, 0.15, "C");
            ++u;
        }
        this.handler.set_col_text(c++, 0.15, "C");
        this.handler.set_col_text(c, 0.1, "C");
        this.setColValue("rubricas", 0, "Capitais Pr\u00f3prios");
        this.setColValue("rubricas", 1, "Capitais Alheios");
        this.setColValue("rubricas", 2, "\u00a0\u00a0\u00a0\u00a0D\u00edvidas a Institui\u00e7\u00f5es de Cr\u00e9dito");
        this.setColValue("rubricas", 3, "\u00a0\u00a0\u00a0\u00a0Outros");
        this.setColValue("rubricas", 4, "FINANCIAMENTO TOTAL");
        ((CHTabQuadro)this.handler).start_rows();
        ((CHTabQuadro)this.handler).row_editable[1] = false;
        ((CHTabQuadro)this.handler).row_editable[4] = false;
        this.handler.j.repaint();
    }

    void on_update(String tag, int row, String v, String x) {
        if (!tag.equals("rubricas")) {
            if (!tag.equals("perc") && !tag.equals("total")) {
                this.calculaValorLinha(row);
            }
            this.calculaValorColuna(tag);
            if (row == 3 || row == 4) {
                this.calculaValorLinha(2);
            }
            this.calculaValorLinha(6);
            this.calculaPercentagens();
        }
        if (tag.startsWith("ano")) {
            CBData.Doc1.getByName("doc_2031").setStringValue(!this.isRowEmpty(2) ? "1" : "0");
            CBData.Doc1.getByName("doc_2033").setStringValue(!this.isRowEmpty(3) ? "1" : "0");
        }
    }

    public void clear() {
        this.handler.__garbage_stop_editing();
        if (this.handler instanceof CHTabQuadro) {
            int i = 0;
            while (i < this.dados.size()) {
                this.clearRow(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dados.size()) {
                this.clearRow(i);
                ++i;
            }
        }
        this.idx_xml = -1;
        this.handler.j.repaint();
    }

    void clearRow(int i) {
        int j = 1;
        while (j < this.cols.length) {
            ((String[])this.dados.elementAt((int)i))[j] = "";
            if (((String[])this.dados.elementAt(i))[j] == null) {
                ((String[])this.dados.elementAt((int)i))[j] = "";
            }
            this.on_update(this.cols[j].col_tag, i, "", "");
            ++j;
        }
    }

    void calculaValorColuna(String colName) {
        double capitaisAlheios = 0.0;
        double financiamentoTotal = 0.0;
        capitaisAlheios = _lib.round(_lib.to_double(this.getColValue(colName, 2)), 2) + _lib.round(_lib.to_double(this.getColValue(colName, 3)), 2);
        financiamentoTotal = _lib.round(_lib.to_double(this.getColValue(colName, 0)), 2) + capitaisAlheios;
        this.setColValue(colName, 1, _lib.to_string(capitaisAlheios));
        this.setColValue(colName, 4, _lib.to_string(financiamentoTotal));
        this.handler.j.repaint();
    }

    void calculaValorLinha(int row) {
    }

    void calculaPercentagens() {
        double percentagem = 0.0;
        int i = 0;
        while (i < this.dados.size() - 1) {
            if (_lib.to_double(this.getColValue("total", 4)) != 0.0 && (percentagem = _lib.round(_lib.to_double(this.getColValue("total", i)), 2) * 100.0 / _lib.round(_lib.to_double(this.getColValue("total", 4)), 2)) > 0.0) {
                this.setColValue("perc", i, _lib.to_string(percentagem));
            }
            ++i;
        }
        this.handler.j.repaint();
    }

    public void verificaInvTotalFinTotal(CHValid_Grp err_list) {
        double inv_total = _lib.to_double("");
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        return this.validar(err_list, "");
    }

    CHValid_Grp validar(CHValid_Grp err_list, String nt) {
        int dataI;
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Estrutura de Financiamento (Recursos Financeiros)" + nt);
        }
        this.verificaInvTotalFinTotal(err_list);
        int dataF = CBData.DadosOperacao.getByName((String)"cdataF").v.equals("") ? 0 : (int)_lib.to_double(CBData.DadosOperacao.getByName((String)"cdataF").v.substring(0, 4));
        int n = dataI = CBData.DadosOperacao.getByName((String)"dataI").v.equals("") ? 0 : (int)_lib.to_double(CBData.DadosOperacao.getByName((String)"dataI").v.substring(0, 4));
        if (dataI > 0 && dataF > 0) {
            int nEntidade = 0;
            while (nEntidade < CBData.Entidades.dados.size()) {
                dataI = CBData.DadosOperacao.getByName((String)"dataI").v.equals("") ? 0 : (int)_lib.to_double(CBData.DadosOperacao.getByName((String)"dataI").v.substring(0, 4));
                int i = this.getColIndex("rubricas") + 1;
                int ano = 0;
                while (i < this.getColIndex("total")) {
                    if (_lib.to_double(((CBTabela_Estrutura_Financ)CBData.Entidades.Lista_Curricula4.get(nEntidade)).getColValue("ano" + ano, 7)) != _lib.to_double(((CBTabela_Estrutura_Financ)CBData.Entidades.Lista_Curricula4.get(nEntidade)).getColValue("ano" + ano, 6))) {
                        err_list.add_msg(new CHValid_Msg("ano" + ano, "Entidade " + nEntidade + " - O Investimento Total no ano " + dataI + " dever\u00e1 ser igual ao Financiamento Total"));
                    }
                    ++i;
                    ++ano;
                    ++dataI;
                }
                ++nEntidade;
            }
        }
        return err_list;
    }
}

