/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Despesas;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import javax.swing.JOptionPane;

class CBTabela_Despesas
extends CBTabela {
    Frame_Despesas PAG = null;

    public String getPagina() {
        return "Despesas";
    }

    CBTabela_Despesas() {
        this.tag = "Despesa";
        this.PAG = (Frame_Despesas)fmeFrame.Paginas.getPage("Despesas");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.force_xml = true;
        this.cols = new CHTabColModel[9];
        this.cols[0] = new CHTabColModel("rubrica", "", 3, true, false, null);
        this.cols[1] = new CHTabColModel("rubrica_d", "Rubricas de Despesa", 3, false, true, null);
        this.cols[2] = new CHTabColModel("desc", "Descri\u00e7\u00e3o", 3, true, true, null);
        this.cols[3] = new CHTabColModel("cIva", "Custo Total c/IVA", 3, true, true, (CFType)CFLib.VLD_VALOR_S);
        this.cols[4] = new CHTabColModel("sIva", "Custo Total s/IVA", 3, true, true, (CFType)CFLib.VLD_VALOR_S);
        this.cols[5] = new CHTabColModel("t_iva", "", 3, true, false, null);
        this.cols[6] = new CHTabColModel("t_iva_d", "<html>Taxa (%)</html>", 3, true, true, null);
        this.cols[7] = new CHTabColModel("custoT", "Custo Total Eleg\u00edvel", 3, true, true, (CFType)CFLib.VLD_VALOR_S);
        this.cols[8] = new CHTabColModel("dataR", "Data de Realiza\u00e7\u00e3o (aaaa/mm)", 3, true, true, (CFType)CFLib.VLD_ANO_MES);
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(8, this.PAG.getjTable_Despesas());
        this.ui.add_col(0, 0, 7, 2, "Despesas");
        this.ui.add_col(0, 2, 1, 6, "Rubricas de Despesa");
        this.ui.add_col(1, 2, 1, 6, "Descri\u00e7\u00e3o");
        this.ui.add_col(2, 2, 1, 6, "<hmtl>Custo Total <br>c/IVA");
        this.ui.add_col(3, 2, 1, 6, "<html>Custo Total <br>s/IVA");
        this.ui.add_col(4, 2, 1, 6, "<html>Taxa (%)</html>");
        this.ui.add_col(5, 2, 1, 6, "<html>Custo Total<br> Eleg\u00edvel");
        this.ui.add_col(6, 2, 1, 6, "<html>Data de <br>Realiza\u00e7\u00e3o <br>(aaaa/mm)");
        this.PAG.getjTable_Despesas().getTableHeader().setUI(this.ui);
        this.init_dados(1);
        this.init_handler(this.PAG.getjTable_Despesas());
        this.PAG.getjTable_Despesas().tab = this;
        this.PAG.getjTable_Despesas().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getjScrollPane_Despesas().getWidth() - 2;
        this.handler.set_col_text(1, 0.65, "L");
        this.handler.set_col_text(2, 0.3, "L");
        this.handler.set_col_text(3, 0.1, "C");
        this.handler.set_col_text(4, 0.1, "C");
        this.handler.set_col_comboS(6, 0.1, "C", CTabelas.Iva, 1, 80);
        this.handler.set_col_text(7, 0.1, "C");
        this.handler.set_col_text(8, 0.1, "L");
    }

    void on_update(String tag, int row, String v, String x) {
        if (tag.equals("t_iva_d")) {
            String t_iva = CTabelas.Iva.lookup(0, v, 1);
            this.setColValue("t_iva", row, t_iva);
        }
        if (tag.equals("rubrica_d")) {
            String rubrica = CTabelas._Despesas.lookup(0, v, 1);
            this.setColValue("rubrica", row, rubrica);
        }
    }

    boolean on_ins_row(boolean remove_empty, int selectedRow) {
        this.handler.__garbage_stop_editing();
        int n = selectedRow;
        if (n >= 0) {
            this.ins_row_at(n);
            this.handler.j.revalidate();
            this.handler.j.repaint();
            return true;
        }
        return false;
    }

    boolean on_del_row(boolean cascade, int selectedLine) {
        this.handler.__garbage_stop_editing();
        int n = selectedLine;
        int m = this.handler.j.getRowCount();
        if (n < m && n != -1) {
            Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
            int q = JOptionPane.showOptionDialog(null, "<html>A linha seleccionada " + (cascade ? "<font color='red'>e toda a informa\u00e7\u00e3o associada</font> " : "") + "ser\u00e1 eliminada. Pretende continuar?</html>", "Apagar Linha", 0, 3, null, options, options[1]);
            if (q == 0) {
                this.del_row_at(n);
                this.handler.j.revalidate();
                this.handler.j.repaint();
                return true;
            }
        } else {
            JOptionPane.showMessageDialog(null, "N\u00e3o seleccionou nenhuma linha na tabela!", "Apagar Linha", 1, null);
        }
        return false;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Plano de Investimentos - Classifica\u00e7\u00e3o das Despesas");
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("desc  ", "Lista vazia"));
        } else {
            int i = 0;
            while (i < this.dados.size()) {
                String mask = this.getMask(i);
                TabError[] e = this.isIncompletAll(i, mask.toString());
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg(e[ii]));
                    ++ii;
                }
                if (this.verificaData(CBData.PlanoDemostracao.getColValue("dataI", i), this.getColValue("dataR", i))) {
                    err_list.add_msg(new CHValid_Msg("dataR", "Linha " + (i + 1) + " - Data de Realiza\u00e7\u00e3o anterior \u00e0 data de In\u00edcio da actividade."));
                }
                if (this.verificaData(this.getColValue("dataR", i), CBData.PlanoDemostracao.getColValue("dataF", i))) {
                    err_list.add_msg(new CHValid_Msg("dataR", "Linha " + (i + 1) + " - Data de Realiza\u00e7\u00e3o posterior \u00e0 data de Termo da actividade."));
                }
                ++i;
            }
        }
        return err_list;
    }

    boolean verificaData(String dataI, String dataF) {
        boolean passou = false;
        if (!dataF.equals("") && !dataI.equals("")) {
            if (_lib.to_double(dataI.substring(0, 4)) > _lib.to_double(dataF.substring(0, 4))) {
                passou = true;
            } else if (_lib.to_double(dataI.substring(0, 4)) == _lib.to_double(dataF.substring(0, 4)) && _lib.to_double(dataI.substring(5, 7)) > _lib.to_double(dataF.substring(5, 7))) {
                passou = true;
            }
        }
        return passou;
    }

    boolean isRowEmpty(int row) {
        int j = 0;
        while (j < this.cols.length) {
            String s = ((String[])this.dados.elementAt(row))[j];
            if (s.length() > 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("--RRR-RRR");
        return mask.toString();
    }
}

