/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CBTabela;
import fme.CParse;
import fme.Candidat;
import fme.GeoDir;
import fme.XMLDataHandler;
import fme.fmeFrame;
import fme.fmeMain;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.nio.charset.Charset;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

class XMLParser {
    Vector tlist = new Vector();
    Stack stk = new Stack();
    CBData cdata;
    private static final String MISSING_ERROR = "Esta candidatura est\u00e1 danificada";
    private static final String GEO_OPEN = "<geo_dir>";
    private static final String GEO_CLOSE = "</geo_dir>";

    XMLParser(CBData d) {
        this.cdata = d;
        if (CBData.Grupo.started) {
            this.tlist.add(new xml_tag_handler("//Grupo", CBData.Grupo));
        }
        this.tlist.add(new xml_tag_handler("//AgroInd", d));
        if (CBData.Params.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Params", CBData.Params));
        }
        if (CBData.DadosGerais.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/DadosGerais", CBData.DadosGerais));
        }
        if (CBData.Promotor.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/DadosGerais/Promotor", CBData.Promotor));
        }
        if (CBData.RegimeIva.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/DadosGerais/Promotor/RegimeIva", CBData.RegimeIva));
        }
        if (CBData.Eleg.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Eleg", CBData.Eleg));
        }
        if (CBData.ElegProj.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Eleg/ElegProj", CBData.ElegProj));
        }
        if (CBData.Operacao.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Operacao", CBData.Operacao));
        }
        if (CBData.DescObjectivos.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Operacao/Objectivos", CBData.DescObjectivos));
        }
        if (CBData.Intervencoes.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Operacao/Investimentos", CBData.Intervencoes));
        }
        if (CBData.IntervencoesR.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Operacao/InformacaoComplementar", CBData.IntervencoesR));
        }
        if (CBData.PlanoFinanceiro.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/PlanoFinanceiro", CBData.PlanoFinanceiro));
        }
        if (CBData.FinancIndR.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/TotalPlanoFinanceiro", CBData.FinancIndR));
        }
        if (CBData.FinancInd.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Anualizacao", CBData.FinancInd));
        }
        if (CBData.AnualizacaoR.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/TotalAnualizacao", CBData.AnualizacaoR));
        }
        if (CBData.Doc3.started) {
            this.tlist.add(new xml_tag_handler("//AgroInd/Documentos", CBData.Doc3));
        }
    }

    public void xmlBegin(String path) {
        int i = 0;
        while (i < this.tlist.size()) {
            String s = ((xml_tag_handler)this.tlist.elementAt((int)i)).path;
            if (path.equals(s)) {
                this.stk.push(this.tlist.elementAt(i));
                return;
            }
            ++i;
        }
        XMLDataHandler h = ((xml_tag_handler)this.stk.peek()).handler.getHandler(path);
        if (h != null) {
            JOptionPane.showMessageDialog(null, "habemus handler para " + path);
            xml_tag_handler xtg = new xml_tag_handler(path, h);
            this.stk.push(xtg);
            return;
        }
        ((xml_tag_handler)this.stk.peek()).handler.xmlBegin(path);
    }

    public void xmlEnd(String path) {
        String s = ((xml_tag_handler)this.stk.peek()).path;
        if (path.equals(s)) {
            this.stk.pop();
            return;
        }
        ((xml_tag_handler)this.stk.peek()).handler.xmlEnd(path);
    }

    public void xmlValue(String path, String tag, String v) {
        if (this.stk.size() >= 1) {
            String s = ((xml_tag_handler)this.stk.peek()).path;
            ((xml_tag_handler)this.stk.peek()).handler.xmlValue(path, tag, v);
        }
    }

    public String xmlSave(String path) {
        int i = 0;
        while (i < this.tlist.size()) {
            String s = ((xml_tag_handler)this.tlist.elementAt((int)i)).path;
            if (path.equals(s)) break;
            ++i;
        }
        if (i == this.tlist.size()) {
            return "?";
        }
        String xml = ((xml_tag_handler)this.tlist.elementAt((int)i)).handler.xmlPrintBegin();
        xml = String.valueOf(xml) + ((xml_tag_handler)this.tlist.elementAt((int)i)).handler.xmlPrint();
        int k = 0;
        while (k < this.tlist.size()) {
            String s = ((xml_tag_handler)this.tlist.elementAt((int)k)).path;
            if (s.startsWith(path) && s.lastIndexOf(47) == path.length()) {
                xml = String.valueOf(xml) + this.xmlSave(s);
            }
            ++k;
        }
        xml = String.valueOf(xml) + ((xml_tag_handler)this.tlist.elementAt((int)i)).handler.xmlPrintEnd();
        return xml;
    }

    public void loadFromTemp(String nome) {
        try {
            File xml = fmeMain.tempFile(String.valueOf(nome) + ".xml");
            if (!xml.exists()) {
                throw new IOException();
            }
            SAXParserFactory.newInstance().newSAXParser().parse(xml, (DefaultHandler)new CParse());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveInTemp(String path, String nome) {
        try {
            FileOutputStream fos = new FileOutputStream(fmeMain.tempFile(String.valueOf(nome) + ".xml"));
            System.out.println("<?xml version='1.0' encoding='ISO-8859-1'?>\n" + this.xmlSave(path));
            fos.write(this.encrypt("<?xml version='1.0' encoding='ISO-8859-1'?>\n" + new String(this.xmlSave(path).getBytes(Charset.forName("ISO-8859-1")))));
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean saveInFile(File file) {
        try {
            if (!CBData.Grupo.started) {
                this.saveInTemp("//AgroInd", "candidatura_isolada");
            } else {
                fmeFrame.guarda_cand();
                this.saveInTemp("//Grupo", "lista_de_candidaturas");
            }
            XMLParser.check_out(fmeMain.TempFolder, fmeMain.arquivo);
            XMLParser.zip(fmeMain.TempFolder, file);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erro '" + e.getMessage() + "' ao guardar o ficheiro.");
            return false;
        }
    }

    private static File getFile(File dir, String path) {
        return new File(String.valueOf(dir.getAbsolutePath()) + File.separator + path);
    }

    public static void check_out(File dir, Vector zip) throws Exception {
        int i = 0;
        while (i < zip.size()) {
            Candidat cand = (Candidat)zip.elementAt(i);
            if (!XMLParser.getFile(dir, String.valueOf(cand.entrada) + ".xml").exists()) {
                throw new IOException(MISSING_ERROR);
            }
            if (cand.pasta != null && cand.pasta.size() != 0) {
                if (!XMLParser.getFile(dir, cand.entrada).exists()) {
                    throw new IOException(MISSING_ERROR);
                }
                int j = 0;
                while (j < cand.pasta.size()) {
                    if (cand.pasta.elementAt(j) instanceof GeoDir) {
                        GeoDir pasta = (GeoDir)cand.pasta.elementAt(j);
                        String path = String.valueOf(cand.entrada) + File.separator + pasta.nome;
                        String slash = String.valueOf(path) + File.separator;
                        if (!XMLParser.getFile(dir, path).exists()) {
                            throw new IOException(MISSING_ERROR);
                        }
                        int k = 0;
                        while (k < pasta.geo.length) {
                            if (!XMLParser.getFile(dir, String.valueOf(slash) + pasta.geo[k]).exists()) {
                                throw new IOException(MISSING_ERROR);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void check_in(Vector zip, File dir, String[] need) throws Exception {
        zip.clear();
        int i = 0;
        while (i < need.length) {
            int count;
            String entrada = need[i];
            if (!XMLParser.getFile(dir, String.valueOf(entrada) + ".xml").exists()) {
                throw new IOException(MISSING_ERROR);
            }
            FileReader in = new FileReader(XMLParser.getFile(dir, String.valueOf(entrada) + ".xml"));
            StringBuffer xml = new StringBuffer();
            char[] data = new char[2048];
            while ((count = in.read(data)) != -1) {
                xml.append(data, 0, count);
            }
            in.close();
            int p = 0;
            Vector<GeoDir> pasta = new Vector<GeoDir>();
            while ((p = xml.indexOf(GEO_OPEN, p)) != -1) {
                int q = xml.indexOf(GEO_CLOSE, p += GEO_OPEN.length());
                String nome = xml.substring(p, q);
                p = q + GEO_CLOSE.length();
                if (nome.equals("")) continue;
                if (!XMLParser.getFile(dir, String.valueOf(entrada) + File.separator + nome).exists()) {
                    throw new IOException(MISSING_ERROR);
                }
                File[] list = XMLParser.getFile(dir, String.valueOf(entrada) + File.separator + nome).listFiles();
                String[] geo = new String[list.length];
                int j = 0;
                while (j < list.length) {
                    geo[j] = list[j].getName();
                    ++j;
                }
                pasta.addElement(new GeoDir(nome, geo));
            }
            zip.addElement(new Candidat(need[i], pasta));
            ++i;
        }
    }

    private static void saveInZip(ZipOutputStream out, File source, String soFar) throws Exception {
        if (!source.isDirectory()) {
            int count;
            out.putNextEntry(new ZipEntry(String.valueOf(soFar) + source.getName()));
            FileInputStream in = new FileInputStream(source);
            byte[] data = new byte[2048];
            while ((count = ((InputStream)in).read(data)) != -1) {
                out.write(data, 0, count);
            }
            ((InputStream)in).close();
            return;
        }
        File[] list = source.listFiles();
        String soNew = String.valueOf(soFar) + source.getName() + File.separator;
        int i = 0;
        while (i < list.length) {
            XMLParser.saveInZip(out, list[i], soNew);
            ++i;
        }
    }

    public static void zip(File dir, File zip) throws Exception {
        File temp = new File(String.valueOf(zip.getCanonicalPath()) + ".temp");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(temp));
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            XMLParser.saveInZip(out, list[i], "");
            ++i;
        }
        out.close();
        if (zip.exists()) {
            zip.delete();
        }
        if (!temp.renameTo(zip)) {
            throw new IOException();
        }
    }

    public static void unzip(File zip, File dir) throws Exception {
        ZipEntry entry;
        String tempSlash = String.valueOf(dir.getCanonicalPath()) + File.separator;
        ZipInputStream in = new ZipInputStream(new FileInputStream(zip));
        while ((entry = in.getNextEntry()) != null) {
            int count;
            File target = new File(String.valueOf(tempSlash) + entry.getName());
            if (entry.isDirectory()) {
                target.mkdirs();
                continue;
            }
            File par = target.getParentFile();
            if (!par.exists()) {
                par.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(target);
            byte[] data = new byte[2048];
            while ((count = in.read(data)) > 0) {
                ((OutputStream)out).write(data, 0, count);
            }
            ((OutputStream)out).close();
        }
        in.close();
    }

    public static void Open(File file) throws Exception {
        File xml;
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, String.valueOf(file.getCanonicalPath()) + "\nO ficheiro n\u00e3o foi encontrado!");
            return;
        }
        XMLParser.unzip(file, fmeMain.TempFolder);
        String tempSlash = String.valueOf(fmeMain.TempFolder.getCanonicalPath()) + File.separator;
        if (!CBData.Grupo.started && (xml = new File(String.valueOf(tempSlash) + "candidatura_isolada" + ".xml")).exists()) {
            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)new StringBufferInputStream(XMLParser.decrypt(xml)), (DefaultHandler)new CParse());
            XMLParser.check_in(fmeMain.arquivo, fmeMain.TempFolder, new String[]{"candidatura_isolada"});
            return;
        }
        if (CBData.Grupo.started && (xml = new File(String.valueOf(tempSlash) + "lista_de_candidaturas" + ".xml")).exists()) {
            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)new StringBufferInputStream(XMLParser.decrypt(xml)), (DefaultHandler)new CParse());
            String[] xpt = new String[CBData.Grupo.dados.size()];
            int i = 0;
            while (i < CBData.Grupo.dados.size()) {
                xpt[i] = CBData.Grupo.getColValue("entrada", i);
                ++i;
            }
            XMLParser.check_in(fmeMain.arquivo, fmeMain.TempFolder, xpt);
            return;
        }
        throw new Exception("Formato desconhecido, utilize o formul\u00e1rio adequado.");
    }

    private byte[] encrypt(String buffer) {
        try {
            Cipher cipher = Cipher.getInstance("DES");
            DESKeySpec ks = new DESKeySpec("EspR3ss0".getBytes("UTF8"));
            SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
            SecretKey ky = kf.generateSecret(ks);
            cipher.init(1, ky);
            byte[] enc = cipher.doFinal(buffer.getBytes("UTF8"));
            return enc;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String decrypt(File xml) {
        String original_data = null;
        try {
            Cipher cipher = Cipher.getInstance("DES");
            DESKeySpec ks = new DESKeySpec("EspR3ss0".getBytes("UTF8"));
            SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
            SecretKey ky = kf.generateSecret(ks);
            cipher.init(2, ky);
            long file_length = xml.length();
            System.out.println("file length: " + file_length);
            byte[] buffer = new byte[(int)file_length];
            FileInputStream rdr = new FileInputStream(xml);
            int readed = rdr.read(buffer, 0, (int)file_length);
            rdr.close();
            original_data = new String(buffer);
            String decrypted = new String(cipher.doFinal(buffer), "UTF8");
            System.out.println(decrypted);
            return new String(decrypted.getBytes(Charset.forName("ISO-8859-1")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new String(original_data.getBytes(Charset.forName("ISO-8859-1")));
        }
    }

    public void printPaths() {
        int i = 0;
        while (i != this.tlist.size()) {
            xml_tag_handler h = (xml_tag_handler)this.tlist.get(i);
            if (h.handler instanceof CBRegisto) {
                ((CBRegisto)h.handler).printCampos(h.path);
            } else if (h.handler instanceof CBTabela) {
                ((CBTabela)h.handler).printPaths(h.path);
            }
            ++i;
        }
    }

    class xml_tag_handler {
        public String path;
        public XMLDataHandler handler;

        xml_tag_handler(String p, XMLDataHandler o) {
            this.path = p;
            this.handler = o;
        }
    }
}

