/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Intervencoes;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.util.Date;
import javax.swing.JComboBox;

class CBTabela_Intervencoes
extends CBTabela {
    JComboBox cboEstabs = null;
    Frame_Intervencoes PAG = null;
    boolean showIVA;

    public String getPagina() {
        return "Intervencoes";
    }

    CBTabela_Intervencoes() {
        this.tag = "Investimentos";
        this.PAG = (Frame_Intervencoes)fmeFrame.Paginas.getPage("Intervencoes");
        if (this.PAG == null) {
            return;
        }
        this.PAG.getJTable_intervencoes().setName("Intervencoes_Tabela");
        this.PAG.getJTable_intervencoes().tab = this;
        this.PAG.getJScrollPane_intervencoes().setName("Intervencoes_ScrollPane");
        this.showIVA = this.PAG.showIVA;
        this.started = true;
        this.PAG.getJTable_intervencoes().addKeyListener(new TableKeyListener(this));
        this.updateUI();
        this.init_dados(11);
    }

    public void updateUI() {
        if (!this.started) {
            return;
        }
        this.showIVA = this.PAG.showIVA;
        this.cols = new CHTabColModel[8];
        this.cols[0] = new CHTabColModel("dossier", "<html>N\u00ba.</html>", true, false, true, null);
        this.cols[1] = new CHTabColModel("designacao", "<html>Designa\u00e7\u00e3o</html>", true, true, true, null);
        this.cols[2] = new CHTabColModel("rubrica", "<html>Rubrica de investimento</html>", true, true, true, null);
        this.cols[3] = new CHTabColModel("total_sem_iva", "Investimento<br>Total", true, true, true, CFLib.VLD_VALOR);
        this.cols[4] = new CHTabColModel("elegivel", "Investimento<br>Eleg\u00edvel", true, true, this.showIVA, CFLib.VLD_VALOR);
        this.cols[5] = new CHTabColModel("unidade", "<html>Unidade</html>", true, true, true, null);
        this.cols[6] = new CHTabColModel("quantidade", "Quantidade", true, true, true, CFLib.VLD_INT);
        this.cols[7] = new CHTabColModel("data", "<html>Data de<br> Realiza\u00e7\u00e3o<br>(A-M)</html>", true, true, true, CFLib.VLD_ANO_MES);
        this.init_handler(this.PAG.getJTable_intervencoes());
        this.handler.width = this.PAG.getJScrollPane_intervencoes().getWidth();
        double aux = 0.06999999999999999;
        this.handler.set_col_text(0, 0.1, "C");
        this.handler.set_col_text(1, 0.3, "C");
        this.handler.set_col_comboS(2, 0.3, "C", CTabelas.RubricasInvestimento, 1, 350);
        this.handler.set_col_text(3, 0.15, "C");
        this.handler.set_col_text(4, 0.15, "C");
        this.handler.set_col_text(5, 0.1, "L");
        this.handler.set_col_text(6, 0.11, "C");
        this.handler.set_col_text(7, 0.11, "C");
    }

    public int numeroDossiers() {
        int numero = 0;
        int i = 0;
        while (i != this.dados.size()) {
            if (!this.getColValue("dossier", i).isEmpty()) {
                ++numero;
            }
            ++i;
        }
        return numero;
    }

    public void calcTotal() {
        if (this.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String val = this.getColValue("total_sem_iva", i);
                if (!this.showIVA) {
                    this.setColValue("total_com_iva", i, val);
                } else {
                    double rata = 0.0;
                    double perc = this.getColValue("id_taxa_iva", i).equals("") ? 0.0 : (double)Integer.parseInt(this.getColValue("taxa_iva", i)) / 100.0;
                    if (CBData.RegimeIva.getByName((String)"regime_iva").v.equals("2")) {
                        rata = CBData.RegimeIva.getByName("pro_rata").valueAsDouble() / 100.0;
                    }
                    perc = _lib.to_double(val) * (1.0 + perc * (1.0 - rata));
                    this.setColValue("total_com_iva", i, String.valueOf(perc));
                }
            }
            ++i;
        }
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("taxa_iva")) {
            String operacao = CTabelas.Iva.lookup(1, v, 0);
            this.setColValue("id_taxa_iva", nRow, operacao);
        }
        if (colname.equals("total_com_iva") && this.getColValue("total_sem_iva", nRow).length() == 0) {
            this.setColValue("total_com_iva", nRow, "");
        }
        CBData.numerarMult(0);
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o das Interven\u00e7\u00f5es");
        }
        if (this.isEmpty1()) {
            err_list.add_msg(new CHValid_Msg("Interven\u00e7\u00f5es", "Lista vazia"));
        }
        int i = 0;
        while (i < this.dados.size()) {
            String mask = this.getMask(i);
            TabError[] e = this.isIncompletAll(i, mask);
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o"), e[ii].row, e[ii].col));
                ++ii;
            }
            Date di = CFType_Data.parse_date(CBData.Operacao.getByName((String)"inicio_investimento").v);
            Date df = CFType_Data.parse_date(CBData.Operacao.getByName((String)"fim_investimento").v);
            Date d = null;
            if (!this.getColValue("data", i).equals("")) {
                String[] s = this.getColValue("data", i).split("-");
                d = CFType_Data.parse_date(String.valueOf(s[0]) + "-" + s[1] + "-01");
            }
            if (di != null && d != null && d.before(di)) {
                err_list.add_msg(new CHValid_Msg("data1", 'W', "Linha " + (i + 1) + ": Data de realiza\u00e7\u00e3o anterior \u00e0 de inicio do investimento"));
            }
            if (df != null && d != null && df.before(d)) {
                err_list.add_msg(new CHValid_Msg("data2", 'W', "Linha " + (i + 1) + ": Data de realiza\u00e7\u00e3o posterior \u00e0 de conclus\u00e3o do investimento"));
            }
            ++i;
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = null;
        mask = new StringBuffer("------RR");
        if (this.PAG.showIVA) {
            mask.append("-R-R");
        } else {
            mask.append("---R");
        }
        return mask.toString();
    }
}

