/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CTabelas;
import fme.DateInv;
import fme.Frame_Anualizacao;
import fme.GroupableTableHeaderUI;
import fme._lib;
import fme.fmeFrame;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CBTabela_FinancInd
extends CBTabela {
    Frame_Anualizacao PAG = null;
    boolean showIVA;
    int financiamento = -1;
    int investimento = -1;
    int elegivel = -1;
    int ano_inicio;
    int ano_fim;

    @Override
    public String getPagina() {
        return "Financ";
    }

    CBTabela_FinancInd() {
        this.tag = "TotalAnualizacao";
        this.PAG = (Frame_Anualizacao)fmeFrame.Paginas.getPage("Anualizacao");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.showIVA = this.PAG.showIVA;
        this.PAG.getJTable_Financ().setName("Anualizacao");
        this.PAG.getJTable_Financ().tab = this;
        int anoI = CFLib.VLD_ANO_CAND.ano_inicial;
        int anoF = anoI + 6 - 1;
        this.on_update_limites(2010, 2015);
        String nota = "";
        String s = "";
        int n = 0;
        this.PAG.setComponentSize(this.df_nlines, n);
    }

    void on_update_limites(int anoI, int anoF) {
        if (!this.started) {
            return;
        }
        this.ano_inicio = anoI;
        this.ano_fim = anoF;
        this.cols = new CHTabColModel[2 + (anoF - anoI) + 3];
        this.cols[0] = new CHTabColModel("conta", null, true, false, false, null);
        this.cols[1] = new CHTabColModel("rubrica", "R\u00fabrica", true, true, true, null);
        int c = 2;
        int n = 0;
        int ano = anoI;
        ++ano;
        while (ano <= anoF) {
            this.cols[c++] = new CHTabColModel("val_" + n, Integer.toString(ano), true, true, true, CFLib.VLD_VALOR_S);
            ++n;
            ++ano;
        }
        while (ano < anoI + (anoF - anoI)) {
            this.cols[c++] = new CHTabColModel("val_" + n, null, true, false, false, null);
            ++n;
            ++ano;
        }
        this.cols[c++] = new CHTabColModel("total", "Total", true, false, true, CFLib.VLD_VALOR_S);
        this.cols[c++] = new CHTabColModel("perc", "%", true, false, true, CFLib.VLD_PERC);
        this.cols[c++] = new CHTabColModel("n_ordem", null, true, false, false, null);
        this.init_handler(this.PAG.getJTable_Financ());
        this.handler.width = this.PAG.getJScrollPane_Financ().getWidth();
        this.handler.set_col_comboS(1, 0.3, "C", CTabelas.RubricasInvestimento, 1, 300);
        c = 2;
        ano = anoI;
        ++ano;
        while (ano <= anoF) {
            this.handler.set_col_text(c++, 0.125, "R");
            ++ano;
        }
        while (ano < anoI + (anoF - anoI)) {
            ++c;
            ++ano;
        }
        this.handler.set_col_text(c++, 0.125, "R");
        this.handler.set_col_text(c++, 0.072, "R");
        ano = anoI;
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.PAG.getJTable_Financ());
        this.ui.add_col(0, 0, 1, 2, "R\u00fabrica");
        this.ui.add_col(1, 0, anoF - ++ano + 1, 1, "Investimento");
        int idx = 1;
        while (ano <= anoF) {
            this.ui.add_col(idx, 1, 1, 1, Integer.toString(ano));
            ++ano;
            ++idx;
        }
        this.ui.add_col(idx, 0, 1, 2, "Total");
        this.ui.add_col(++idx, 0, 1, 2, "%");
        this.PAG.getJTable_Financ().getTableHeader().setUI(this.ui);
        this.init_dados(4);
        if (this.df_nlines == 0) {
            return;
        }
    }

    public void clear233Vals() {
        int i = 2;
        while (i < this.cols.length) {
            this.setColValue(this.cols[i].col_tag, 3, "");
            ++i;
        }
    }

    public void set2333Vals(Vector<DateInv> v) {
        double prev = 0.0;
        for (DateInv inv : v) {
            double dif;
            if (_lib.to_double(inv.getAno()) < (double)this.ano_inicio || !(2.0 + (dif = _lib.to_double(inv.getAno()) - (double)this.ano_inicio) < (double)this.cols.length)) continue;
            prev = _lib.to_double(this.getColValue(this.cols[2 + (int)dif].col_tag, 3));
            this.setColValue(this.cols[2 + (int)dif].col_tag, 3, _lib.to_string(prev + inv.getInv()));
        }
    }

    public void set2333Total(double t) {
        this.setColValue("total", 3, _lib.to_string(t));
    }

    public double totalRubrica(int l) {
        double valor = 0.0;
        String[] linha = (String[])this.dados.elementAt(l);
        int i = 2;
        while (i != this.cols.length - 3) {
            if (!linha[i].isEmpty()) {
                valor += _lib.to_double(linha[i]);
            }
            ++i;
        }
        return valor;
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        double total_rubrica = this.totalRubrica(nRow);
        if (total_rubrica == 0.0) {
            this.setColValue("total", nRow, "");
        } else {
            this.setColValue("total", nRow, Double.toString(total_rubrica));
        }
        if (colname.startsWith("val_")) {
            double inv = 0.0;
            double totalinv = 0.0;
            double totalapoio = 0.0;
            double totalauto = 0.0;
            int anos = this.ano_fim - this.ano_inicio;
            totalapoio = 0.0;
            totalauto = 0.0;
            totalinv = 0.0;
            double total = 0.0;
            int i = 0;
            while (i != this.dados.size()) {
                total += this.totalRubrica(i);
                ++i;
            }
            CBData.AnualizacaoR.getByName("investimento_total").setStringValue(Double.toString(total));
            i = 0;
            while (i != this.dados.size()) {
                if (total > 0.0) {
                    this.setColValue("perc", i, Double.toString(this.totalRubrica(i) / total * 100.0));
                }
                ++i;
            }
        }
        this.numerarAll(0);
        this.handler.j.repaint();
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("-RRRR");
        return mask.toString();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Estrutura de Financiamento");
        }
        return err_list;
    }
}

