/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.DefaultFrame;
import fme.Frame_IdPromotor;
import fme.fmeFrame;

class CBRegisto_Promotor
extends CBRegisto {
    Frame_IdPromotor PAG = null;

    public String getPagina() {
        return "IdPromotor";
    }

    CBRegisto_Promotor() {
        this.tag = "Promotor";
        this.PAG = (Frame_IdPromotor)fmeFrame.Paginas.getPage("IdPromotor");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        String[] opt2 = new String[]{"1", "0"};
        CHCampo_Opt pessoa_sc = new CHCampo_Opt("entidade", opt2, this);
        pessoa_sc.addComponent(this.PAG.getJCheckBox_Colectiva());
        pessoa_sc.addComponent(this.PAG.getJCheckBox_Singular());
        pessoa_sc.dummy = this.PAG.jCheckBox_PessoaClear;
        this.Campos.add(pessoa_sc);
        this.Campos.add(new CHCampo_Text("nif", this.PAG.getJTextField_NIF(), CFLib.VLD_NIF, this));
        this.Campos.add(new CHCampo_Text("nifap", this.PAG.getJTextField_NIFAP(), CFLib.VLD_INT, this));
        this.Campos.add(new CHCampo_Text("nome", this.PAG.getJTextField_Nome(), null, this));
        this.Campos.add(new CHCampo_Text("morada", this.PAG.getJTextField_Morada(), null));
        this.Campos.add(new CHCampo_Text("localidade", this.PAG.getJTextField_Localidade(), null));
        this.Campos.add(new CHCampo_Text("codigo_postal", this.PAG.getJTextField_CodPostal(), CFLib.VLD_COD_POSTAL));
        this.Campos.add(new CHCampo_Text("localidade_postal", this.PAG.getJTextField_LocPostal(), null));
        this.Campos.add(new CHCampo_Combo("concelho", "ConcelhosF1", this.PAG.getJComboBox_Concelho(), this));
        this.Campos.add(new CHCampo_Combo("distrito", "Distritos", this.PAG.getJComboBox_Distrito(), this));
        this.Campos.add(new CHCampo_Text("nuts_ii", this.PAG.getJTextField_Regiao(), null));
        this.Campos.add(new CHCampo_Text("nuts_ii_d", this.PAG.getJTextField_RegiaoD(), null));
        this.Campos.add(new CHCampo_Text("nuts_iii", this.PAG.getJTextField_NutsIII(), null));
        this.Campos.add(new CHCampo_Text("nuts_iii_d", this.PAG.getJTextField_NutsIIID(), null));
        this.Campos.add(new CHCampo_Text("telefone", this.PAG.getJTextField_Telefone(), null));
        this.Campos.add(new CHCampo_Text("telefax", this.PAG.getJTextField_Telefax(), null));
        this.Campos.add(new CHCampo_Text("email", this.PAG.getJTextField_EMail(), CFLib.VLD_EMAIL));
        this.Campos.add(new CHCampo_Text("url", this.PAG.getJTextField_URL(), null));
        this.Campos.add(new CHCampo_Combo("tipologia_beneficiario", "CaractJur", this.PAG.getJComboBox_Beneficiario(), this));
        this.Campos.add(new CHCampo_Text("responsavel_nome", this.PAG.getJTextField_RespNome(), null));
        this.Campos.add(new CHCampo_Text("responsavel_funcao", this.PAG.getJTextField_RespFunc(), null));
        this.Campos.add(new CHCampo_Text("responsavel_telefone", this.PAG.getJTextField_RespMovel(), null, this));
        this.Campos.add(new CHCampo_Text("responsavel_email", this.PAG.getJTextField_RespEMail(), CFLib.VLD_EMAIL, this));
        CHCampo_Opt tc = new CHCampo_Opt("tem_consultor", opt2, this);
        tc.addComponent(this.PAG.getJCheckBox_Consult_Sim());
        tc.addComponent(this.PAG.getJCheckBox_Consult_Nao());
        tc.dummy = this.PAG.jCheckBox_ConsultClear;
        this.Campos.add(tc);
        this.Campos.add(new CHCampo_Text("consultor_nif", this.PAG.getJTextField_ConsNIF(), CFLib.VLD_NIF));
        this.Campos.add(new CHCampo_Text("consultor_nome", this.PAG.getJTextField_ConsNome(), null));
        this.Campos.add(new CHCampo_Text("consultor_morada", this.PAG.getJTextField_ConsMorada(), null));
        this.Campos.add(new CHCampo_Text("consultor_cod_postal", this.PAG.getJTextField_ConsCodPostal(), CFLib.VLD_COD_POSTAL));
        this.Campos.add(new CHCampo_Text("consultor_loc_postal", this.PAG.getJTextField_ConsLocPostal(), null));
        this.Campos.add(new CHCampo_Text("consultor_contacto", this.PAG.getJTextField_ConsContacto(), null));
        this.Campos.add(new CHCampo_Text("consultor_telefone", this.PAG.getJTextField_ConsTelefone(), null));
        this.Campos.add(new CHCampo_Text("consultor_email", this.PAG.getJTextField_ConsEmail(), CFLib.VLD_EMAIL));
        this.Campos.add(new CHCampo_Text("tecnico_nome", this.PAG.getJTextField_NomeTecnico(), null));
        this.Campos.add(new CHCampo_Text("tecnico_habilitacoes", this.PAG.getJTextField_HabTecnico(), null));
    }

    void on_update(String tag) {
        if (tag.equals("entidade")) {
            CBData.RegimeIva.on_update("regime_iva");
            this.PAG.set_individual(!this.PAG.getJCheckBox_Colectiva().isSelected());
        }
        if (tag.equals("tipologia_beneficiario") && this.getByName((String)"tipologia_beneficiario").v.equals("02")) {
            CBData.Operacao.getByName("pgf_aprovado").clear();
            CBData.Operacao.getByName("pgf_apresentado").clear();
        }
        if (tag.equals("concelho")) {
            String concelho = this.getByName("concelho").getStringValue();
            if (concelho.length() > 0) {
                String nuts_ii = CTabelas.Concelhos.lookup(0, concelho, 5);
                String nuts_iii = CTabelas.Concelhos.lookup(0, concelho, 2);
                this.getByName("distrito").setStringValue(concelho.substring(0, 2));
                this.getByName("nuts_ii").setStringValue(nuts_ii);
                this.getByName("nuts_ii_d").setStringValue(CTabelas.NUTS_II.getDesign(nuts_ii));
                this.getByName("nuts_iii").setStringValue(nuts_iii);
                this.getByName("nuts_iii_d").setStringValue(CTabelas.NUTS_III.getDesign(nuts_iii));
            } else {
                this.getByName("nuts_iii_d").setStringValue("");
                this.getByName("nuts_iii").setStringValue("");
                this.getByName("nuts_ii_d").setStringValue("");
                this.getByName("nuts_ii").setStringValue("");
            }
        }
        if (tag.equals("distrito")) {
            String distrito = this.getByName("distrito").getStringValue();
            String concelho = this.getByName("concelho").getStringValue();
            if (distrito.length() == 0) {
                CTabelas.ConcelhosF1.clear_filter();
                CTabelas.ConcelhosF1._populateComboBox(this.PAG.getJComboBox_Concelho());
            } else if (concelho.length() == 0 || !distrito.equals(concelho.substring(0, 2))) {
                CTabelas.ConcelhosF1.set_filter(3, distrito);
                CTabelas.ConcelhosF1._populateComboBox(this.PAG.getJComboBox_Concelho());
            }
        }
        if (tag.equals("nome") && CBData.Grupo.started) {
            String nome = this.getByName((String)"nome").v;
            if (nome.length() > 0) {
                nome = "   [ " + nome + " ]";
            }
            int i = 0;
            while (i < fmeFrame.Load.size()) {
                DefaultFrame df = (DefaultFrame)fmeFrame.Load.elementAt((int)i).frame;
                if (df.jLabel_PAG != null) {
                    df.jLabel_PAG.setText(String.valueOf(df.get_text()) + nome);
                }
                ++i;
            }
        }
    }

    String on_xml(String tag) {
        if (tag.equals("concelho")) {
            return this.on_xml_d(tag, CTabelas.Concelhos);
        }
        if (tag.equals("distrito")) {
            return this.on_xml_d(tag, CTabelas.Distritos);
        }
        if (tag.equals("tipologia_beneficiario")) {
            return this.on_xml_d(tag, CTabelas.Beneficiario);
        }
        return "";
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Identifica\u00e7\u00e3o do Promotor");
        }
        this.extract();
        if (this.getByName("nif").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nif", "N\u00ba de Identifica\u00e7\u00e3o Fiscal - %o"));
        }
        if (this.getByName("nifap").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nifap", "NIFAP - %o"));
        }
        if (this.getByName("nome").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nome", "Nome ou Designa\u00e7\u00e3o Social - %o"));
        }
        if (this.getByName("morada").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("morada", "Morada (Sede Social) - %o"));
        }
        if (this.getByName("localidade").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("localidade", "Localidade - %o"));
        }
        if (this.getByName("codigo_postal").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("codigo_postal", "C\u00f3digo Postal - %o"));
        }
        if (this.getByName("localidade_postal").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("localidade_postal", "C\u00f3digo Postal (localidade) - %o"));
        }
        if (this.getByName("distrito").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito - %o"));
        }
        if (this.getByName("concelho").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("concelho", "Concelho - %o"));
        }
        if (this.getByName("telefone").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("telefone", "Telefone - %o"));
        }
        if (this.getByName("email").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("email", "E-mail - %o"));
        }
        if (this.getByName("tipologia_beneficiario").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("tipologia_beneficiario", "Caracteriza\u00e7\u00e3o jur\u00eddica - %o"));
        }
        return err_list;
    }

    CHValid_Grp validar2(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Entidade consultora respons\u00e1vel pela elabora\u00e7\u00e3o do pedido de apoio");
        }
        this.extract();
        if (this.getByName((String)"tem_consultor").v.equals("1")) {
            if (this.getByName("consultor_nif").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_nif", "N\u00ba de Identifica\u00e7\u00e3o Social do Consultor - %o"));
            }
            if (this.getByName("consultor_nome").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_nome", "Nome ou Designa\u00e7\u00e3o Social do Consultor - %o"));
            }
            if (this.getByName("consultor_morada").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_morada", "Morada (Sede Social) do Consultor - %o"));
            }
            if (this.getByName("consultor_cod_postal").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_cod_postal", "C\u00f3digo Postal do Consultor - %o"));
            }
            if (this.getByName("consultor_loc_postal").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_loc_postal", "C\u00f3digo Postal (localidade) do Consultor - %o"));
            }
            if (this.getByName("consultor_contacto").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_contacto", "Contacto do Consultor - %o"));
            }
            if (this.getByName("consultor_telefone").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_telefone", "Telefone do Consultor - %o"));
            }
            if (this.getByName("consultor_email").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_email", "E-mail do Consultor - %o"));
            }
            if (this.getByName("tecnico_nome").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("tecnico_nome", "Nome do t\u00e9cnico respons\u00e1vel - %o"));
            }
            if (this.getByName("tecnico_habilitacoes").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("tecnico_habilitacoes", "Habilita\u00e7\u00f5es do respons\u00e1vel - %o"));
            }
        }
        return err_list;
    }

    CHValid_Grp validar3(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Respons\u00e1vel pela Opera\u00e7\u00e3o");
        }
        if (this.getByName("responsavel_nome").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("responsavel_nome", "Nome - %o"));
        }
        if (this.getByName("responsavel_funcao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("responsavel_funcao", "Fun\u00e7\u00e3o - %o"));
        }
        if (this.getByName("responsavel_telefone").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("responsavel_telefone", "Telem\u00f3vel - %o"));
        }
        if (this.getByName("responsavel_email").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("responsavel_email", "E-mail - %o"));
        }
        return err_list;
    }
}

