/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo;
import fme.CHCampo_Combo;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_SumarioOperacao;
import fme._lib;
import fme.fmeFrame;
import java.util.Date;

class CBRegisto_Operacao
extends CBRegisto {
    Frame_SumarioOperacao PAG = null;

    public String getPagina() {
        return "Operacao";
    }

    CBRegisto_Operacao() {
        this.tag = "Operacao";
        this.PAG = (Frame_SumarioOperacao)fmeFrame.Paginas.getPage("SumarioOperacao");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        String[] opt1 = new String[]{"1"};
        String[] opt2 = new String[]{"1", "0"};
        this.Campos.add(new CHCampo_Text("designacao", this.PAG.getJTextField_designacao(), null));
        this.Campos.add(new CHCampo_Text("freguesia", this.PAG.getJTextField_Freguesia(), null));
        this.Campos.add(new CHCampo_Combo("concelho", "ConcelhosF1", this.PAG.getJComboBox_Concelho(), this));
        this.Campos.add(new CHCampo_Combo("distrito", "Distritos", this.PAG.getJComboBox_Distrito(), this));
        this.Campos.add(new CHCampo_Text("codigo_postal", this.PAG.getJTextField_CodPostal(), null));
        this.Campos.add(new CHCampo_Text("localidade_postal", this.PAG.getJTextField_LocPostal(), null));
        this.Campos.add(new CHCampo_Text("nuts2", this.PAG.getJTextField_Regiao(), null));
        this.Campos.add(new CHCampo_Text("nuts3", this.PAG.getJTextField_NutsIII(), null));
        this.Campos.add(new CHCampo_Text("investimento_total", this.PAG.getJTextField_invTotal(), CFLib.VLD_VALOR_0));
        this.Campos.add(new CHCampo_Text("investimento_elegivel", this.PAG.getJTextField_invElegivel(), CFLib.VLD_VALOR_0));
        this.Campos.add(new CHCampo_Text("inicio_investimento", this.PAG.getJTextField_initInv(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("fim_investimento", this.PAG.getJTextField_endInv(), CFLib.VLD_DATA, this));
    }

    String on_xml(String tag) {
        if (tag.equals("especie")) {
            return this.on_xml_d(tag, CTabelas.Especies);
        }
        return "";
    }

    void clear() {
        int i = 0;
        while (i < this.Campos.size()) {
            if (!(((CHCampo)this.Campos.elementAt((int)i)).tag.equals("a2331") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("a2332") || ((CHCampo)this.Campos.elementAt((int)i)).tag.equals("a2333"))) {
                ((CHCampo)this.Campos.elementAt(i)).clear();
            }
            ++i;
        }
    }

    void notZif() {
        this.getByName("pgf_aprovado").clear();
        this.getByName("designacao_zif").clear();
        this.getByName("diploma1").clear();
        this.getByName("diploma2").clear();
        this.getByName("diploma3").clear();
        this.getByName("diploma_data").clear();
    }

    void on_update(String tag) {
        if (tag.equals("concelho")) {
            String concelho = this.getByName("concelho").getStringValue();
            if (concelho.length() > 0) {
                String nuts_ii = CTabelas.Concelhos.lookup(0, concelho, 5);
                String nuts_iii = CTabelas.Concelhos.lookup(0, concelho, 2);
                this.getByName("distrito").setStringValue(concelho.substring(0, 2));
                this.getByName("nuts2").setStringValue(CTabelas.NUTS_II.getDesign(nuts_ii));
                this.getByName("nuts3").setStringValue(CTabelas.NUTS_III.getDesign(nuts_iii));
            } else {
                this.getByName("nuts3").setStringValue("");
                this.getByName("nuts2").setStringValue("");
            }
        }
        if (tag.equals("distrito")) {
            String distrito = this.getByName("distrito").getStringValue();
            String concelho = this.getByName("concelho").getStringValue();
            if (distrito.length() == 0) {
                CTabelas.ConcelhosF1.clear_filter();
                CTabelas.ConcelhosF1._populateComboBox(this.PAG.getJComboBox_Concelho());
            } else if (concelho.length() == 0 || !distrito.equals(concelho.substring(0, 2))) {
                CTabelas.ConcelhosF1.set_filter(3, distrito);
                CTabelas.ConcelhosF1._populateComboBox(this.PAG.getJComboBox_Concelho());
            }
        }
        if (!(!tag.equalsIgnoreCase("alineaA_parcelas1") && !tag.equalsIgnoreCase("alineaA_parcelas2") && !tag.equalsIgnoreCase("alineaA_parcelas3") && !tag.equalsIgnoreCase("alineaA_area1") && !tag.equalsIgnoreCase("alineaA_area2") && !tag.equalsIgnoreCase("alineaA_area3") || this.getByName((String)"alineaA_parcelas1").v.equalsIgnoreCase("") && this.getByName((String)"alineaA_parcelas2").v.equalsIgnoreCase("") && this.getByName((String)"alineaA_parcelas3").v.equalsIgnoreCase("") && this.getByName((String)"alineaA_area1").v.equalsIgnoreCase("") && this.getByName((String)"alineaA_area2").v.equalsIgnoreCase("") && this.getByName((String)"alineaA_area3").v.equalsIgnoreCase(""))) {
            this.on_update("alineaB_parcelas");
        }
        if ((tag.equals("inicio_investimento") || tag.equals("fim_investimento")) && !this.getByName((String)"inicio_investimento").v.equalsIgnoreCase("") && !this.getByName((String)"fim_investimento").v.equalsIgnoreCase("")) {
            String[] ano1 = this.getByName((String)"inicio_investimento").v.split("-");
            double anoI = _lib.to_double(ano1[0]);
            String[] ano2 = this.getByName((String)"fim_investimento").v.split("-");
            double anoF = _lib.to_double(ano2[0]);
            if (anoF - anoI >= 6.0) {
                CBData.FinancInd.on_update_limites(2010, 2015);
            } else {
                CBData.FinancInd.on_update_limites(2010, 2015);
            }
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o da Opera\u00e7\u00e3o");
        }
        if (this.getByName("designacao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("designacao", "Designa\u00e7\u00e3o da Opera\u00e7\u00e3o - %o"));
        }
        boolean hasInit = false;
        boolean hasEnd = false;
        if (this.getByName("inicio_investimento").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("inicio_investimento", "Data de In\u00edcio do Investimento - %o"));
        } else {
            hasInit = true;
        }
        if (this.getByName("fim_investimento").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("fim_investimento", "Data de Conclus\u00e3o do Investimento - %o"));
        } else {
            hasEnd = true;
        }
        if (hasInit && hasEnd) {
            Date dt_init = CFType_Data.parse_date(this.getByName((String)"inicio_investimento").v);
            Date dt_end = CFType_Data.parse_date(this.getByName((String)"fim_investimento").v);
            if (dt_init.after(dt_end)) {
                err_list.add_msg(new CHValid_Msg("dates", "Data de Inicio superior a Data de Conclus\u00e3o"));
            }
            if (dt_init.before(CFType_Data.parse_date("2010-10-13"))) {
                err_list.add_msg(new CHValid_Msg("inicio_investimento", "Data de Inicio anterior a 2010-10-13"));
            }
        }
        return err_list;
    }
}

