/*
 * Decompiled with CFR 0.152.
 */
package fme;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    JTable t;
    public int H;
    int[] col_width;
    public Vector<Col> hcols = new Vector();

    GroupableTableHeaderUI() {
    }

    public void setH(int h, JTable t) {
        this.t = t;
        this.H = h;
    }

    public void add_col(int ix, int iy, int dx, int dy, String tag) {
        Col c = new Col();
        c.ix = ix;
        c.iy = iy;
        c.dx = dx;
        c.dy = dy;
        c.tag = "<html><div align='center'>" + tag + "</div></html>";
        this.hcols.add(c);
    }

    public void paint(Graphics g, JComponent c) {
        Enumeration<TableColumn> enumeration = this.t.getColumnModel().getColumns();
        this.col_width = new int[this.t.getColumnModel().getColumnCount() + 1];
        this.col_width[0] = 0;
        int n = 1;
        int width = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn ct = enumeration.nextElement();
            this.col_width[n] = width += ct.getWidth();
            ++n;
        }
        if (this.header.getColumnModel() == null) {
            return;
        }
        Dimension size = this.header.getSize();
        int dh = size.height / this.H;
        Rectangle cell = new Rectangle();
        int i = 0;
        while (i < this.hcols.size()) {
            Col col = this.hcols.elementAt(i);
            cell.setLocation(this.col_width[col.ix], col.iy * dh);
            cell.setSize(this.col_width[col.dx + col.ix] - this.col_width[col.ix], col.dy * dh);
            this.header.getColumnModel().getColumn(0).setHeaderValue(col.tag);
            this.paintCell(g, cell, 0);
            ++i;
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        renderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel header = new JLabel();
                header.setForeground(table.getTableHeader().getForeground());
                header.setBackground(table.getTableHeader().getBackground());
                header.setFont(table.getTableHeader().getFont());
                header.setHorizontalAlignment(0);
                header.setText(value.toString());
                header.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return header;
            }
        };
        Component c = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
        c.setBackground(UIManager.getColor("control"));
        this.rendererPane.add(c);
        this.rendererPane.paintComponent(g, c, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        this.rendererPane.remove(c);
    }

    private int getHeaderHeight() {
        int height = 0;
        TableColumnModel columnModel = this.header.getColumnModel();
        int column = 0;
        while (column < columnModel.getColumnCount()) {
            TableColumn aColumn = columnModel.getColumn(column);
            TableCellRenderer renderer = aColumn.getHeaderRenderer();
            if (renderer == null) {
                return 60;
            }
            Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
            int cHeight = comp.getPreferredSize().height;
            height = Math.max(height, cHeight);
            ++column;
        }
        return height;
    }

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if ((width += (long)(columnModel.getColumnMargin() * columnModel.getColumnCount())) > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    class Col {
        int ix;
        int iy;
        int dx;
        int dy;
        String tag;

        Col() {
        }
    }
}

