/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHTabQuadro2;
import fme.CHValid_Grp;
import fme.Frame_progFinanc;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;

class CBTabela_aprovHidro
extends CBTabela {
    Frame_progFinanc PAG = null;
    int anoCand = 0;
    private double cod_area_total = 10000.0;
    private double cod_consumo = 5000.0;
    private double cod_taxa = 5.0;
    private double cod_taxa_conservacao = 10.0;

    public String getPagina() {
        return "progFinanc";
    }

    CBTabela_aprovHidro() {
        this.tag = "aprovHidro";
        this.PAG = (Frame_progFinanc)fmeFrame.Paginas.getPage("progFinanc");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        String s = CBData.DadosGerais.getByName((String)"ano_cand").v;
        if (!s.equals("")) {
            this.anoCand = Integer.parseInt(s);
        }
        this.cols = new CHTabColModel[34];
        this.cols[0] = new CHTabColModel("desc", "Descri\u00e7\u00e3o", true, false, true, null);
        this.cols[1] = new CHTabColModel("cod", "", true, false, true, CFLib.VLD_VALOR_04);
        int i = 2;
        while (i < 22) {
            this.cols[i] = new CHTabColModel("anomais" + (i - 2), "Ano+" + (i - 2), true, true, true, CFLib.VLD_VALOR_0);
            ++i;
        }
        i = 22;
        while (i < 32) {
            this.cols[i] = new CHTabColModel("anomais" + (i - 2), "Ano+" + (i - 2), false, false, false, CFLib.VLD_VALOR_0);
            ++i;
        }
        this.cols[32] = new CHTabColModel("anomais20/29", "Ano+20/29", false, false, true, CFLib.VLD_VALOR_0);
        this.cols[33] = new CHTabColModel("total", "Total", false, false, true, CFLib.VLD_VALOR_0);
        this.init_dados(32);
        this.PAG.getJTable_aprovHidro().addKeyListener(new TableKeyListener(this));
        this.PAG.getJTable_aprovHidro().tab = this;
        this.init_handler(new CHTabQuadro2(), this.PAG.getJTable_aprovHidro());
        this.handler.width = this.PAG.getJScrollPane_aprovHidro().getWidth();
        this.force_xml = true;
        this.handler.set_col_text(0, 0.4, "L");
        this.handler.set_col_text(1, 0.15, "C");
        i = 2;
        while (i < 22) {
            this.handler.set_col_text(i, 0.2, "C");
            ++i;
        }
        this.handler.set_col_text(32, 0.2, "C");
        this.handler.set_col_text(33, 0.25, "C");
        this.setColValue("desc", 0, "<html><b>INVESTIMENTOS TOTAIS</b></html>");
        this.setColValue("desc", 1, "     - P\u00fablicos");
        this.setColValue("desc", 2, "     - Privados (outros)");
        this.setColValue("desc", 3, "     - Privados (equipamento rega)");
        this.setColValue("desc", 4, "<html><b>SITUA\u00c7\u00c3O FUTURA SEM PROJECTO</b></html>");
        this.setColValue("desc", 5, "    Proveitos");
        this.setColValue("desc", 6, "    Encargos Vari\u00e1veis");
        this.setColValue("desc", 7, "<html><b>Benef\u00edcio L\u00edquido sem projecto</b></html>");
        this.setColValue("desc", 8, "<html><b>SITUA\u00c7\u00c3O FUTURA COM PROJECTO</b></html>");
        this.setColValue("desc", 9, "    Proveitos");
        this.setColValue("desc", 10, "    Encargos Vari\u00e1veis (S/ Custos de \u00c1gua para Rega)");
        this.setColValue("desc", 11, "<html><b>Custos Com \u00c1gua para Rega</b></html>");
        this.setColValue("desc", 12, "    - Custos de Explora\u00e7\u00e3o");
        this.setColValue("desc", 13, "    - Custos de Conserva\u00e7\u00e3o");
        this.setColValue("desc", 14, "<html><b>Benef\u00edcio L\u00edquido com projecto</b></html>");
        this.setColValue("desc", 15, "<html><b>BENEF\u00cdCIO L\u00cdQUIDO ADICIONAL</b></html>");
        this.setColValue("desc", 16, "");
        this.setColValue("desc", 17, "<html><b>\u00c1rea regada total (ha)</b></html>");
        this.setColValue("cod", 17, _lib.to_string(this.cod_area_total));
        this.setColValue("desc", 20, "");
        this.setColValue("desc", 21, "Consumo de \u00e1gua (m3/ha)");
        this.setColValue("cod", 21, _lib.to_string(this.cod_consumo));
        this.setColValue("desc", 24, "");
        this.setColValue("desc", 25, "Taxa de Explora\u00e7\u00e3o (euros/m3)");
        this.setColValue("cod", 25, _lib.to_string(this.cod_taxa));
        this.setColValue("desc", 27, "Valor cobrado da taxa de explora\u00e7\u00e3o (euros)");
        this.setColValue("desc", 28, "Taxa de conserva\u00e7\u00e3o (euros/ha)");
        this.setColValue("cod", 28, _lib.to_string(this.cod_taxa_conservacao));
        this.setColValue("desc", 30, "Valor cobrado  da taxa de conserva\u00e7\u00e3o(euros)");
        this.setColValue("desc", 31, "<html><b>Cen\u00e1rio de ades\u00e3o ao regadio (%)</b></html>");
        this.cols[0].disable_row_calc = true;
        ((CHTabQuadro2)this.handler).start_rows();
        ((CHTabQuadro2)this.handler).row_editable[0] = false;
        ((CHTabQuadro2)this.handler).row_editable[3] = true;
        ((CHTabQuadro2)this.handler).row_editable[4] = false;
        ((CHTabQuadro2)this.handler).row_editable[5] = false;
        ((CHTabQuadro2)this.handler).row_editable[6] = false;
        ((CHTabQuadro2)this.handler).row_editable[7] = false;
        ((CHTabQuadro2)this.handler).row_editable[8] = false;
        ((CHTabQuadro2)this.handler).row_editable[9] = false;
        ((CHTabQuadro2)this.handler).row_editable[10] = false;
        ((CHTabQuadro2)this.handler).row_editable[11] = false;
        ((CHTabQuadro2)this.handler).row_editable[12] = false;
        ((CHTabQuadro2)this.handler).row_editable[13] = false;
        ((CHTabQuadro2)this.handler).row_editable[14] = false;
        ((CHTabQuadro2)this.handler).row_editable[15] = false;
        ((CHTabQuadro2)this.handler).row_editable[16] = false;
        ((CHTabQuadro2)this.handler).row_editable[17] = false;
        ((CHTabQuadro2)this.handler).row_editable[18] = false;
        ((CHTabQuadro2)this.handler).row_editable[19] = false;
        ((CHTabQuadro2)this.handler).row_editable[20] = false;
        ((CHTabQuadro2)this.handler).row_editable[21] = false;
        ((CHTabQuadro2)this.handler).row_editable[22] = false;
        ((CHTabQuadro2)this.handler).row_editable[23] = false;
        ((CHTabQuadro2)this.handler).row_editable[24] = false;
        ((CHTabQuadro2)this.handler).row_editable[25] = false;
        ((CHTabQuadro2)this.handler).row_editable[26] = false;
        ((CHTabQuadro2)this.handler).row_editable[27] = false;
        ((CHTabQuadro2)this.handler).row_editable[28] = false;
        ((CHTabQuadro2)this.handler).row_editable[29] = false;
        ((CHTabQuadro2)this.handler).row_editable[30] = false;
        this.keyCol = 0;
    }

    public int getInvestimentosTotaisIdx() {
        return 0;
    }

    public int getInvestimentosPrivadosIdx() {
        return 3;
    }

    public int getBenLiqSemProjectoIdx() {
        return 7;
    }

    public int getBenLiqComProjectoIdx() {
        return 14;
    }

    public int getEncargosSemProjectoIdx() {
        return 6;
    }

    public int getProveitosSemProjectoIdx() {
        return 5;
    }

    public int getEncargosComProjectoIdx() {
        return 10;
    }

    public int getCustosAguaRegaIdx() {
        return 11;
    }

    public int getProveitosComProjectoIdx() {
        return 9;
    }

    public int getCenarioAdesaoIdx() {
        return 31;
    }

    public int getAreaRegadaTotalIdx() {
        return 17;
    }

    public int getConsumo() {
        return 21;
    }

    public int getTaxa() {
        return 25;
    }

    public int getTaxaConservacao() {
        return 28;
    }

    public void clear() {
        super.clear();
        this.clearRow(28);
        this.cod_area_total = 0.0;
        this.cod_consumo = 0.0;
        this.cod_taxa = 0.0;
        this.cod_taxa_conservacao = 0.0;
        this.setColValue("cod", 17, "");
        this.setColValue("cod", 21, "");
        this.setColValue("cod", 25, "");
        this.setColValue("cod", 28, "");
    }

    public void calcValues() {
        int i = 2;
        while (i < this.cols.length) {
            double cen = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getCenarioAdesaoIdx())) / 100.0;
            this.setColValue(this.cols[i].col_tag, this.getAreaRegadaTotalIdx(), _lib.to_string(cen * this.cod_area_total));
            double areaRegada = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getAreaRegadaTotalIdx() + 1));
            areaRegada = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getAreaRegadaTotalIdx()));
            this.setColValue(this.cols[i].col_tag, this.getConsumo(), _lib.to_string(areaRegada * this.cod_consumo));
            double consumo = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getConsumo()));
            this.setColValue(this.cols[i].col_tag, this.getTaxa(), _lib.to_string(consumo * this.cod_taxa));
            consumo = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getConsumo()));
            this.setColValue(this.cols[i].col_tag, this.getTaxa(), _lib.to_string(consumo * this.cod_taxa));
            double taxa = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getTaxa()));
            this.setColValue(this.cols[i].col_tag, this.getTaxa() + 2, _lib.to_string(taxa));
            this.calcTaxas();
            this.calcInvestimentos();
            this.setColValue(this.cols[i].col_tag, this.getCustosAguaRegaIdx() + 1, this.getColValue(this.cols[i].col_tag, this.getTaxa() + 1));
            if (i > 2) {
                this.setColValue(this.cols[i].col_tag, this.getCustosAguaRegaIdx() + 2, this.getColValue(this.cols[3].col_tag, this.getTaxaConservacao() + 2));
            }
            this.setColValue(this.cols[i].col_tag, this.getCustosAguaRegaIdx(), _lib.to_string(_lib.to_double(this.getColValue(this.cols[i].col_tag, this.getCustosAguaRegaIdx() + 1)) + _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getCustosAguaRegaIdx() + 2))));
            double proveitos = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getProveitosComProjectoIdx()));
            double encargos = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getEncargosComProjectoIdx()));
            double custos_agua = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getCustosAguaRegaIdx()));
            if (i == 2) {
                this.setColValue(this.cols[i].col_tag, this.getBenLiqComProjectoIdx(), this.getColValue(this.cols[i].col_tag, this.getBenLiqSemProjectoIdx()));
            } else {
                this.setColValue(this.cols[i].col_tag, this.getBenLiqComProjectoIdx(), _lib.to_string(proveitos - encargos - custos_agua));
            }
            double ben_c_proj = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getBenLiqComProjectoIdx()));
            double ben_s_proj = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getBenLiqSemProjectoIdx()));
            this.setColValue(this.cols[i].col_tag, this.getBenLiqComProjectoIdx() + 1, _lib.to_string(ben_c_proj - ben_s_proj));
            this.calcTotal();
            ++i;
        }
    }

    public void calcTotal() {
        double total = 0.0;
        int i = 0;
        while (i < this.dados.size()) {
            if (i != 4 && i != 8 && i != 16 && i != 18 && i != 19 && i != 29 && i != 26 && i != 22 && i != 23 && i != 20 && i != 24) {
                total = 0.0;
                int c = 2;
                while (c <= 21) {
                    total += _lib.to_double(this.getColValue(this.cols[c].col_tag, i));
                    ++c;
                }
                this.setColValue("total", i, _lib.to_string(total));
            }
            ++i;
        }
        double[] ben = new double[30];
        this.onUpdateTaxa();
    }

    public void calcTaxas() {
        double areaRegada = _lib.to_double(this.getColValue(this.cols[1].col_tag, this.getAreaRegadaTotalIdx()));
        int i = 2;
        while (i < this.cols.length) {
            double taxa = this.cod_area_total * this.cod_taxa_conservacao;
            if (i != 2) {
                this.setColValue(this.cols[i].col_tag, this.getTaxaConservacao(), _lib.to_string(taxa));
            }
            taxa = _lib.to_double(this.getColValue(this.cols[2].col_tag, this.getTaxaConservacao()));
            this.setColValue(this.cols[i].col_tag, this.getTaxaConservacao(), _lib.to_string(taxa));
            this.setColValue(this.cols[i].col_tag, this.getTaxaConservacao() + 2, _lib.to_string(taxa * areaRegada));
            ++i;
        }
    }

    public void calcInvestimentos() {
        double area = _lib.to_double(this.getColValue("anomais1", this.getAreaRegadaTotalIdx()));
        double inv_total = _lib.to_double(this.getColValue("anomais1", this.getInvestimentosPrivadosIdx())) + _lib.to_double(this.getColValue("anomais1", this.getInvestimentosTotaisIdx() + 1)) + _lib.to_double(this.getColValue("anomais1", this.getInvestimentosTotaisIdx() + 2));
        this.setColValue("anomais1", this.getInvestimentosTotaisIdx(), _lib.to_string(inv_total));
        area = _lib.to_double(this.getColValue("anomais0", this.getAreaRegadaTotalIdx()));
        inv_total = _lib.to_double(this.getColValue("anomais0", this.getInvestimentosPrivadosIdx())) + _lib.to_double(this.getColValue("anomais0", this.getInvestimentosTotaisIdx() + 1)) + _lib.to_double(this.getColValue("anomais0", this.getInvestimentosTotaisIdx() + 2));
        this.setColValue("anomais0", this.getInvestimentosTotaisIdx(), _lib.to_string(inv_total));
        int i = 4;
        while (i < this.cols.length) {
            area = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getAreaRegadaTotalIdx()));
            inv_total = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getInvestimentosPrivadosIdx())) + _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getInvestimentosTotaisIdx() + 1)) + _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getInvestimentosTotaisIdx() + 2));
            this.setColValue(this.cols[i].col_tag, this.getInvestimentosTotaisIdx(), _lib.to_string(inv_total));
            ++i;
        }
    }

    public void calcSemProjecto(double val, int linha) {
        double enc = 0.0;
        double prov = 0.0;
        int i = 2;
        while (i < this.cols.length) {
            this.setColValue(this.cols[i].col_tag, linha, String.valueOf(val));
            if (!this.getColValue(this.cols[i].col_tag, this.getEncargosSemProjectoIdx()).equals("")) {
                enc = Double.parseDouble(this.getColValue(this.cols[i].col_tag, this.getEncargosSemProjectoIdx()));
            }
            if (!this.getColValue(this.cols[i].col_tag, this.getProveitosSemProjectoIdx()).equals("")) {
                prov = Double.parseDouble(this.getColValue(this.cols[i].col_tag, this.getProveitosSemProjectoIdx()));
            }
            this.setColValue(this.cols[i].col_tag, this.getBenLiqSemProjectoIdx(), String.valueOf(prov - enc));
            ++i;
        }
    }

    public void calcProveitosComProjecto() {
        double cen = 0.0;
        double prov = 0.0;
        int i = 2;
        while (i < this.cols.length) {
            cen = _lib.to_double(this.getColValue(this.cols[i].col_tag, this.getCenarioAdesaoIdx())) / 100.0;
            prov = i == 2 ? CBData.VendasProd.getTotal("rendimentos_tot") : cen * CBData.PrestServ.getTotal("rendimentos_tot") + (1.0 - cen) * CBData.VendasProd.getTotal("rendimentos_tot");
            this.setColValue(this.cols[i].col_tag, this.getProveitosComProjectoIdx(), String.valueOf(prov));
            ++i;
        }
    }

    public void calcEncargosComProjecto() {
        double cen = 0.0;
        double prov = 0.0;
        int i = 2;
        while (i < this.cols.length) {
            if (!this.getColValue(this.cols[i].col_tag, this.getCenarioAdesaoIdx()).equals("")) {
                cen = Double.valueOf(this.getColValue(this.cols[i].col_tag, this.getCenarioAdesaoIdx())) / 100.0;
            }
            prov = i == 2 ? CBData.VendasProd.getTotal("encargos_tot") : cen * CBData.PrestServ.getTotal("encargos_tot") + (1.0 - cen) * CBData.VendasProd.getTotal("encargos_tot");
            this.setColValue(this.cols[i].col_tag, this.getEncargosComProjectoIdx(), String.valueOf(prov));
            ++i;
        }
    }

    void onUpdateAnoCand(int ano) {
    }

    void onUpdateTaxa() {
        double[] benLiq = new double[20];
        int i = 2;
        while (i < 22) {
            benLiq[i - 2] = _lib.to_double(this.getColValue("anomais" + (i - 2), 15));
            ++i;
        }
        CBData.aHreg.updateBenLiq(benLiq);
        double[] invAct = new double[20];
        int i2 = 2;
        while (i2 < 22) {
            invAct[i2 - 2] = !this.getColValue("anomais" + (i2 - 2), 0).equals("") ? Double.parseDouble(this.getColValue("anomais" + (i2 - 2), 0)) : 0.0;
            ++i2;
        }
        CBData.aHreg.updateInvAct(invAct);
        CBData.aHreg.updateIndRent();
    }

    void on_update(String colname, int nRow, String v, String x) {
        if (colname.equals("cod")) {
            this.cod_area_total = _lib.to_double(this.getColValue(colname, 17));
            this.cod_consumo = _lib.to_double(this.getColValue(colname, 21));
            this.cod_taxa = _lib.to_double(this.getColValue(colname, 25));
            this.cod_taxa_conservacao = _lib.to_double(this.getColValue(colname, 28));
            CBData.aHreg.updateIndCons(this.cod_consumo);
            this.calcValues();
        }
        if (nRow == this.getCenarioAdesaoIdx()) {
            this.calcEncargosComProjecto();
            this.calcProveitosComProjecto();
            this.calcSemProjecto(CBData.VendasProd.getTotal("rendimentos_tot"), this.getProveitosSemProjectoIdx());
            this.calcSemProjecto(CBData.VendasProd.getTotal("encargos_tot"), this.getEncargosSemProjectoIdx());
            this.calcValues();
        }
        if (nRow == this.getInvestimentosTotaisIdx() + 1) {
            this.calcInvestimentos();
            this.calcTotal();
        }
        if (colname.equals("anomais0") && (nRow == 28 || nRow == 29)) {
            this.calcValues();
        }
        int i = 0;
        while (i < this.dados.size()) {
            this.setColValue("anomais20/29", i, this.getColValue("anomais19", i));
            ++i;
        }
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Proveitos e Custos do Aproveitamento HidroAgr\u00edcola");
        }
        return err_list;
    }
}

