/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Intervencoes;
import fme.TabError;
import fme.TableKeyListener;
import fme.fmeFrame;

class CBTabela_OCE
extends CBTabela {
    Frame_Intervencoes PAG = null;
    boolean showIVA;

    public String getPagina() {
        return "Intervencoes";
    }

    CBTabela_OCE() {
        this.tag = "OCE";
        this.PAG = (Frame_Intervencoes)fmeFrame.Paginas.getPage("Intervencoes");
        if (this.PAG == null) {
            return;
        }
        this.PAG.getJTable_OCE().setName("OCE");
        this.showIVA = this.PAG.showIVA;
        this.started = true;
        this.updateUI();
        this.PAG.getJTable_OCE().addKeyListener(new TableKeyListener(this));
        this.init_dados(11);
    }

    public void updateUI() {
        if (!this.started) {
            return;
        }
        this.showIVA = this.PAG.showIVA;
        this.cols = new CHTabColModel[10];
        this.cols[0] = new CHTabColModel("dossier", "N\u00ba Dossier", true, false, true, null);
        this.cols[1] = new CHTabColModel("n_local", "Local", true, true, true, null);
        this.cols[2] = new CHTabColModel("despesas", "Despesas_d", true, false, false, null);
        this.cols[3] = new CHTabColModel("despesas_d", "Despesas", true, true, true, null);
        this.cols[4] = new CHTabColModel("descricao", "Descri\u00e7\u00e3o", true, true, true, null);
        this.cols[5] = new CHTabColModel("total_siva", "Total S/IVA", true, true, true, CFLib.VLD_VALOR);
        this.cols[6] = new CHTabColModel("taxa_iva", "Taxa IVA", true, true, this.showIVA, CFLib.VLD_PERC);
        this.cols[7] = new CHTabColModel("total_civa", "Total C/IVA", true, false, this.showIVA, CFLib.VLD_VALOR);
        this.cols[8] = new CHTabColModel("geo", "GEO", true, false, true, null);
        this.cols[8].is_check = true;
        this.cols[9] = new CHTabColModel("geo_dir", "Cartografia [GEO]", true, true, false, null);
        this.init_handler(this.PAG.getJTable_OCE());
        this.handler.width = this.PAG.getJScrollPane_OCE().getWidth();
        this.handler.set_col_text(0, 0.1, "C");
        this.handler.set_col_text(1, 0.1, "C");
        this.handler.set_col_comboS(3, 0.14, null, CTabelas.Despesas, 1, 150);
        this.handler.set_col_text(4, 0.1, "C");
        this.handler.set_col_text(5, 0.24, "C");
        if (this.showIVA) {
            this.handler.set_col_text(6, 0.1, "C");
            this.handler.set_col_text(7, 0.24, "C");
        }
        this.handler.set_col_check(8, 0.07);
        this.calcTotal();
    }

    public void calcTotal() {
        if (this.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String val = this.getColValue("total_siva", i);
                if (val.equals("")) {
                    this.setColValue("total_civa", i, val);
                } else if (!this.showIVA) {
                    this.setColValue("total_civa", i, val);
                } else {
                    double rata = 0.0;
                    double perc = this.getColValue("taxa_iva", i).equals("") ? 0.0 : (double)Integer.parseInt(this.getColValue("taxa_iva", i)) / 100.0 + 1.0;
                    if (CBData.RegimeIva.getByName((String)"regime_iva").v.equals("2")) {
                        rata = CBData.RegimeIva.getByName("pro_rata").valueAsDouble() / 100.0;
                    }
                    perc = (double)Integer.parseInt(val) * (1.0 + perc * (1.0 - rata));
                    this.setColValue("total_civa", i, String.valueOf(perc));
                }
            }
            ++i;
        }
    }

    boolean on_del_row() {
        return super.on_del_row();
    }

    boolean on_up_row() {
        return super.on_up_row();
    }

    boolean on_copy_row() {
        return super.on_copy_row();
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("total_siva") || colname.equals("taxa_iva")) {
            this.calcTotal();
        }
        if (colname.equals("total_civa") && this.getColValue("total_siva", nRow).length() == 0) {
            this.setColValue("total_civa", nRow, "");
        }
        if (colname.equals("despesa_d")) {
            String p = CTabelas.Despesas.lookup(1, v, 0);
            this.setColValue("despesas", nRow, p);
        }
        if (colname.equals("geo_dir")) {
            this.setColValue("geo", nRow, v.length() == 0 ? "" : "1");
        }
        this.numerar(0);
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o das Interven\u00e7\u00f5es - Outros Custos eleg\u00edveis");
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("Outros Custos Eleg\u00edveis", "Lista vazia"));
        }
        int i = 0;
        while (i < this.dados.size()) {
            String mask = this.getMask(i);
            TabError[] e = this.isIncompletAll(i, mask);
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o"), e[ii].row, e[ii].col));
                ++ii;
            }
            ++i;
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("RR-RRR");
        if (this.cols[6].visible) {
            mask.append("R");
        } else {
            mask.append("-");
        }
        if (this.cols[7].visible) {
            mask.append("R");
        } else {
            mask.append("-");
        }
        mask.append("R-");
        return mask.toString();
    }
}

