/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Intervencoes;
import fme.TabError;
import fme.TableKeyListener;
import fme.fmeFrame;

class CBTabela_Infraestruturas
extends CBTabela {
    Frame_Intervencoes PAG = null;
    boolean showIVA;

    public String getPagina() {
        return "Intervencoes";
    }

    CBTabela_Infraestruturas() {
        this.tag = "Infraestruturas";
        this.PAG = (Frame_Intervencoes)fmeFrame.Paginas.getPage("Intervencoes");
        if (this.PAG == null) {
            return;
        }
        this.PAG.getJTable_infraestruturas().setName("Infraestruturas");
        this.showIVA = this.PAG.showIVA;
        this.started = true;
        this.updateUI();
        this.PAG.getJTable_infraestruturas().addKeyListener(new TableKeyListener(this));
        this.init_dados(11);
    }

    public void updateUI() {
        if (!this.started) {
            return;
        }
        this.showIVA = this.PAG.showIVA;
        this.cols = new CHTabColModel[25];
        this.cols[0] = new CHTabColModel("n_dossier", "N\u00ba. Dossier", true, false, true, null);
        this.cols[1] = new CHTabColModel("inv", null, true, true, false, null);
        this.cols[2] = new CHTabColModel("inv_d", "Investimento", true, true, true, null);
        this.cols[3] = new CHTabColModel("declive", null, true, true, false, null);
        this.cols[4] = new CHTabColModel("declive_d", "Declive", true, true, true, null);
        this.cols[5] = new CHTabColModel("sub_roc", null, true, true, false, null);
        this.cols[6] = new CHTabColModel("sub_roc_d", "Substrato rochoso", true, true, true, null);
        this.cols[7] = new CHTabColModel("elems", null, true, true, false, null);
        this.cols[8] = new CHTabColModel("elems_d", "Elementos Grosseiros", true, true, true, null);
        this.cols[9] = new CHTabColModel("tipo_veg", null, true, true, false, null);
        this.cols[10] = new CHTabColModel("tipo_veg_d", "<html>Tipo<br>de<br>Vegeta\u00e7\u00e3o</html>", true, true, true, null);
        this.cols[11] = new CHTabColModel("alt_veg", "<html>Altura<br>Vegeta\u00e7\u00e3o<br>(cm)</html>", true, true, true, CFLib.VLD_VALOR);
        this.cols[12] = new CHTabColModel("est_caminho", null, true, true, false, null);
        this.cols[13] = new CHTabColModel("est_caminho_d", "<html>Estado<br>Caminho</html>", true, true, true, null);
        this.cols[14] = new CHTabColModel("alarg_caminho", null, true, true, false, null);
        this.cols[15] = new CHTabColModel("alarg_caminho_d", "<html>Alargamento<br>Caminho</html>", true, true, true, null);
        this.cols[16] = new CHTabColModel("propria", null, true, true, false, null);
        this.cols[17] = new CHTabColModel("propria_d", "<html>Pr\u00f3pria (rede<br>vi\u00e1ria a construir)</html>", true, true, true, null);
        this.cols[18] = new CHTabColModel("comprimento", "<html>Comprimento<br>(km)</html>", true, true, true, CFLib.VLD_VALOR);
        this.cols[19] = new CHTabColModel("total_siva", "Total S/IVA", true, true, true, CFLib.VLD_VALOR);
        this.cols[20] = new CHTabColModel("taxa_iva", "Taxa IVA", true, true, this.showIVA, CFLib.VLD_PERC);
        this.cols[21] = new CHTabColModel("total_civa", "Total C/IVA", true, false, this.showIVA, CFLib.VLD_VALOR);
        this.cols[22] = new CHTabColModel("data_rel", "<html>Data de<br>Realiza\u00e7\u00e3o<br>(A/M)</html>", true, true, true, CFLib.VLD_ANO_MES);
        this.cols[23] = new CHTabColModel("geo", "GEO", true, false, true, null);
        this.cols[23].is_check = true;
        this.cols[24] = new CHTabColModel("geo_dir", "Cartografia [GEO]", true, true, false, null);
        this.init_handler(this.PAG.getJTable_infraestruturas());
        this.handler.width = this.PAG.getJScrollPane_infraestruturas().getWidth();
        this.handler.set_col_text(0, 0.1, "C");
        this.handler.set_col_comboS(2, 0.14, null, CTabelas.Investimento, 1, 150);
        this.handler.set_col_comboS(4, 0.1, null, CTabelas.Declive, 1, 50);
        this.handler.set_col_comboS(6, 0.17, null, CTabelas.SubRoc, 1, 130);
        this.handler.set_col_comboS(8, 0.19, null, CTabelas.ElemsGross, 1, 50);
        this.handler.set_col_comboS(10, 0.12, null, CTabelas.TipoVege, 1, 50);
        this.handler.set_col_text(11, 0.12, "C");
        this.handler.set_col_comboS(13, 0.11, null, CTabelas.EstadoCaminho, 1, 100);
        this.handler.set_col_comboS(15, 0.15, null, CTabelas.SimNao, 1, 25);
        this.handler.set_col_comboS(17, 0.16, null, CTabelas.SimNao, 1, 25);
        this.handler.set_col_text(18, 0.12, "C");
        this.handler.set_col_text(19, 0.11, "C");
        if (this.showIVA) {
            this.handler.set_col_text(20, 0.1, "C");
            this.handler.set_col_text(21, 0.11, "C");
        }
        this.handler.set_col_text(22, 0.11, "C");
        this.handler.set_col_check(23, 0.07);
        this.calcTotal();
    }

    public void calcTotal() {
        if (this.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String val = this.getColValue("total_siva", i);
                if (val.equals("")) {
                    this.setColValue("total_civa", i, val);
                } else if (!this.showIVA) {
                    this.setColValue("total_civa", i, val);
                } else {
                    double rata = 0.0;
                    double perc = this.getColValue("taxa_iva", i).equals("") ? 0.0 : (double)Integer.parseInt(this.getColValue("taxa_iva", i)) / 100.0 + 1.0;
                    if (CBData.RegimeIva.getByName((String)"regime_iva").v.equals("2")) {
                        rata = CBData.RegimeIva.getByName("pro_rata").valueAsDouble() / 100.0;
                    }
                    perc = (double)Integer.parseInt(val) * (1.0 + perc * (1.0 - rata));
                    this.setColValue("total_civa", i, String.valueOf(perc));
                }
            }
            ++i;
        }
    }

    boolean on_del_row() {
        return super.on_del_row();
    }

    boolean on_up_row() {
        return super.on_up_row();
    }

    boolean on_copy_row() {
        return super.on_copy_row();
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("inv_d")) {
            String inv = CTabelas.Investimento.lookup(1, v, 0);
            this.setColValue("inv", nRow, inv);
        }
        if (colname.equals("declive_d")) {
            String declive = CTabelas.Declive.lookup(1, v, 0);
            this.setColValue("declive", nRow, declive);
        }
        if (colname.equals("sub_roc_d")) {
            String sub_roc = CTabelas.SubRoc.lookup(1, v, 0);
            this.setColValue("sub_roc", nRow, sub_roc);
        }
        if (colname.equals("elems_d")) {
            String elems = CTabelas.ElemsGross.lookup(1, v, 0);
            this.setColValue("elems", nRow, elems);
        }
        if (colname.equals("tipo_veg_d")) {
            String tipo_veg = CTabelas.TipoVege.lookup(1, v, 0);
            this.setColValue("tipo_veg", nRow, tipo_veg);
        }
        if (colname.equals("est_caminho_d")) {
            String est_caminho = CTabelas.EstadoCaminho.lookup(1, v, 0);
            this.setColValue("est_caminho", nRow, est_caminho);
        }
        if (colname.equals("alarg_caminho_d")) {
            String alarg_caminho = CTabelas.SimNao.lookup(1, v, 0);
            this.setColValue("alarg_caminho", nRow, alarg_caminho);
        }
        if (colname.equals("propria_d")) {
            String propria = CTabelas.SimNao.lookup(1, v, 0);
            this.setColValue("propria", nRow, propria);
        }
        if (colname.equals("total_siva") || colname.equals("taxa_iva")) {
            this.calcTotal();
        }
        if ((colname.equals("total_siva") || colname.equals("taxa_iva") || colname.equals("data_rel")) && this.getColValue("data_rel", nRow).length() != 0 && this.getColValue("total_civa", nRow).length() != 0) {
            this.autocalc_Montante();
        }
        if (colname.equals("total_civa") && this.getColValue("total_siva", nRow).length() == 0) {
            this.setColValue("total_civa", nRow, "");
        }
        if (colname.equals("geo_dir")) {
            this.setColValue("geo", nRow, v.length() == 0 ? "" : "1");
        }
        this.numerar(0);
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o das Interven\u00e7\u00f5es \u2013 Infraestruturas");
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("Infraestruturas", "Lista vazia"));
        }
        int i = 0;
        while (i < this.dados.size()) {
            String mask = this.getMask(i);
            TabError[] e = this.isIncompletAll(i, mask);
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg("incomplet", e[ii].msg("Linha %L incompleta: %T - %o"), e[ii].row, e[ii].col));
                ++ii;
            }
            ++i;
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("RR-R-RRRRRRRRR");
        if (this.cols[13].visible) {
            mask.append("R");
        } else {
            mask.append("-");
        }
        if (this.cols[14].visible) {
            mask.append("RR");
        } else {
            mask.append("-R");
        }
        return mask.toString();
    }
}

