/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Rentab;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme.fmeFrame;

class CBTabela_CMPC
extends CBTabela {
    Frame_Rentab PAG = null;
    private int qAnoC;
    private int vAnoC;

    public String getPagina() {
        return "Rentab";
    }

    CBTabela_CMPC() {
        this.tag = "CMPC";
        this.PAG = (Frame_Rentab)fmeFrame.Paginas.getPage("Rentab");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.PAG.getJTable_CMPC().addKeyListener(new TableKeyListener(this));
        int anoB = CFLib.VLD_ANO_CAND.ano_inicial;
        int anoC = anoB + 10 - 1;
        this.on_update_limites(anoB, anoC);
        this.init_dados(12);
    }

    void on_update_limites(int anoB, int anoC) {
        if (!this.started) {
            return;
        }
        this.cols = new CHTabColModel[26];
        this.cols[0] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[1] = new CHTabColModel("unidade", null, true, false, false, null);
        this.cols[2] = new CHTabColModel("unidade_d", "Unidade F\u00edsica", true, true, true, null);
        this.cols[3] = new CHTabColModel("quant_p", "Quantidade Pr\u00e9-Opera\u00e7\u00e3o", true, true, true, CFLib.VLD_NUM);
        this.cols[4] = new CHTabColModel("val_p", "Valor Pr\u00e9-Opera\u00e7\u00e3o", true, true, true, CFLib.VLD_VALOR);
        int c = 5;
        int n = 1;
        int ano = anoB;
        while (ano < anoC) {
            this.cols[c++] = new CHTabColModel("quant_" + n, "Quantidade " + ano, true, true, true, CFLib.VLD_NUM);
            this.cols[c++] = new CHTabColModel("val_" + n, "Valor " + ano, true, true, true, CFLib.VLD_VALOR);
            ++n;
            ++ano;
        }
        this.qAnoC = c;
        this.cols[c++] = new CHTabColModel("quant_c", "Quantidade Ano Cruzeiro", true, true, true, CFLib.VLD_NUM);
        this.vAnoC = c;
        this.cols[c++] = new CHTabColModel("val_c", "Valor Ano Cruzeiro", true, true, true, CFLib.VLD_VALOR);
        ++ano;
        while (ano < anoB + 10) {
            this.cols[c++] = new CHTabColModel("quant_" + n, null, false, false, false, null);
            this.cols[c++] = new CHTabColModel("val_" + n, null, false, false, false, null);
            ++n;
            ++ano;
        }
        this.cols[c++] = new CHTabColModel("n_ordem", null, true, false, false, null);
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(3, this.PAG.getJTable_CMPC());
        this.ui.add_col(0, 0, 2, 2, "Fileira");
        this.ui.add_col(0, 2, 1, 1, "Designa\u00e7\u00e3o");
        this.ui.add_col(1, 2, 1, 1, "Unid.F\u00edsica");
        this.ui.add_col(2, 0, 2, 2, "M\u00e9dia Representativa<br>(Pr\u00e9-Opera\u00e7\u00e3o)");
        this.ui.add_col(2, 2, 1, 1, "Quantidade");
        this.ui.add_col(3, 2, 1, 1, "Valor Unit\u00e1rio");
        this.ui.add_col(4, 0, 2 * (anoC - anoB + 1), 1, "P\u00f3s-Opera\u00e7\u00e3o");
        c = 4;
        ano = anoB;
        while (ano < anoC) {
            this.ui.add_col(c, 1, 2, 1, Integer.toString(ano));
            this.ui.add_col(c++, 2, 1, 1, "Quantidade");
            this.ui.add_col(c++, 2, 1, 1, "Valor Unit\u00e1rio");
            ++ano;
        }
        this.ui.add_col(c, 1, 2, 1, "Ano Cruzeiro");
        this.ui.add_col(c++, 2, 1, 1, "Quantidade");
        this.ui.add_col(c++, 2, 1, 1, "Valor Unit\u00e1rio");
        this.PAG.getJTable_CMPC().getTableHeader().setUI(this.ui);
        this.init_handler(this.PAG.getJTable_CMPC());
        this.handler.width = this.PAG.getJScrollPane_CMPC().getWidth() - 21;
        this.handler.set_col_text(0, 0.35, null);
        this.handler.set_col_comboS(2, 0.1, null, CTabelas.UniCMPC, 1, 100);
        this.handler.set_col_text(3, 0.14, "R");
        this.handler.set_col_text(4, 0.14, "R");
        c = 5;
        ano = anoB;
        while (ano <= anoC) {
            this.handler.set_col_text(c++, 0.14, "R");
            this.handler.set_col_text(c++, 0.14, "R");
            ++ano;
        }
    }

    void on_update(String colname, int nRow, String v) {
        if (colname.equals("unidade")) {
            String unidade_d = CTabelas.UniCMPC.lookup(0, v, 1);
            this.setColValue("unidade_d", nRow, unidade_d);
        }
        if (colname.equals("unidade_d")) {
            String unidade = CTabelas.UniCMPC.lookup(1, v, 0);
            this.setColValue("unidade", nRow, unidade);
        }
        this.numerar(25);
        this.handler.j.repaint();
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Custo de mat\u00e9rias primas");
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("quadros", "Lista vazia"));
        }
        int[] ai = this.getVarIndex(CBData.varInd, "val_");
        int[] qi = this.getVarIndex(CBData.varInd, "quant_");
        int i = 0;
        while (i < this.dados.size()) {
            String mask = this.getMask(i);
            if (!this.isRowEmpty(i)) {
                TabError[] e = this.isIncompletAll(i, mask);
                int ii = 0;
                while (e != null && ii < e.length) {
                    err_list.add_msg(new CHValid_Msg(e[ii]));
                    ++ii;
                }
                String[] row = (String[])this.dados.elementAt(i);
                boolean one_at_least = false;
                int j = 0;
                while (j < 1 + CBData.varInd + 1) {
                    if (row[ai[j]].length() != 0 || row[qi[j]].length() != 0) {
                        one_at_least = true;
                        if (row[ai[j]].length() == 0) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, ai[j], this)));
                        }
                        if (row[qi[j]].length() == 0) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, qi[j], this)));
                        }
                    }
                    ++j;
                }
                if (!one_at_least) {
                    err_list.add_msg(new CHValid_Msg(new TabError(i, ai[0], "Um par Quantidade / Valor Unit\u00e1rio")));
                }
            }
            ++i;
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuilder sb = new StringBuilder();
        sb.append("R-RRR");
        return sb.toString();
    }
}

