/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.Frame_progFinanc;
import fme.fmeFrame;

class CBRegisto_aprovHidro
extends CBRegisto {
    Frame_progFinanc PAG = null;

    public String getPagina() {
        return "progFinanc";
    }

    CBRegisto_aprovHidro() {
        this.tag = "aprovHidroagricola";
        this.PAG = (Frame_progFinanc)fmeFrame.Paginas.getPage("progFinanc");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("benLiq", this.PAG.getJTextField_benLiq(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("invAct", this.PAG.getJTextField_invAct(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("indRent", this.PAG.getJTextField_indRent(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("indCons", this.PAG.getJTextField_indCons(), CFLib.VLD_VALOR_0, this));
        this.Campos.add(new CHCampo_Text("taxa", this.PAG.getJTextField_taxa(), CFLib.VLD_PERC, this));
    }

    void updateBenLiq(double[] vals) {
        double taxa = 0.0;
        if (!this.getByName((String)"taxa").v.equals("")) {
            taxa = Double.parseDouble(this.getByName((String)"taxa").v) / 100.0;
        }
        double benLiq = this.calcNPV(taxa, vals);
        this.getByName("benLiq").setStringValue(String.valueOf(benLiq));
    }

    void updateInvAct(double[] vals) {
        double taxa = 0.0;
        if (!this.getByName((String)"taxa").v.equals("")) {
            taxa = Double.parseDouble(this.getByName((String)"taxa").v) / 100.0;
        }
        double invAct = this.calcNPV(taxa, vals);
        this.getByName("invAct").setStringValue(String.valueOf(invAct));
    }

    void updateIndRent() {
        double benLiq = 0.0;
        double invAct = 0.0;
        if (!this.getByName((String)"benLiq").v.equals("")) {
            benLiq = Double.parseDouble(this.getByName((String)"benLiq").v);
        }
        if (!this.getByName((String)"invAct").v.equals("")) {
            invAct = Double.parseDouble(this.getByName((String)"invAct").v);
        }
        double indRent = 0.0;
        if (invAct > 0.0) {
            indRent = benLiq / invAct;
        }
        this.getByName("indRent").setStringValue(String.valueOf(indRent));
    }

    void updateIndCons(double val) {
        double indCons = (6600.0 - val) / 6600.0 * 100.0;
        this.getByName("indCons").setStringValue(String.valueOf(indCons));
    }

    void init() {
    }

    double calcNPV(double rate, double[] vals) {
        double total = 0.0;
        int i = 0;
        while (i < vals.length) {
            total += vals[i] / Math.pow(1.0 + rate, i + 1);
            ++i;
        }
        return total;
    }

    void on_update(String tag) {
        if (tag.equals("ano_cand")) {
            CBData.on_update_proj_agr();
            int ano = 0;
            if (!this.getByName((String)tag).v.equals("")) {
                ano = Integer.parseInt(this.getByName((String)tag).v);
            }
            CBData.aH.onUpdateAnoCand(ano);
        }
        if (tag.equals("taxa")) {
            CBData.aH.onUpdateTaxa();
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Dados Gerais");
        }
        return err_list;
    }
}

