/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_IdProm_2;
import fme._lib;
import fme.fmeFrame;

class CBRegisto_AutoFin
extends CBRegisto {
    Frame_IdProm_2 PAG = null;

    public String getPagina() {
        return "IdProm_2";
    }

    CBRegisto_AutoFin() {
        this.tag = "AutoFin";
        this.PAG = (Frame_IdProm_2)fmeFrame.Paginas.getPage("IdProm_2");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        CHCampo_Opt opt_BI_ = new CHCampo_Opt("bal_intercalar", this);
        opt_BI_.setOptions("1", "0");
        opt_BI_.addComponent(this.PAG.getJCheckBox_BISim());
        opt_BI_.addComponent(this.PAG.getJCheckBox_BINao());
        opt_BI_.dummy = this.PAG.jCheckBox_BIClear;
        this.Campos.add(opt_BI_);
        this.Campos.add(new CHCampo_Text("data_bi", this.PAG.getJTextField_DataBI(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("balanco", this.PAG.getJTextField_AnoBal(), CFLib.VLD_ANO, this));
        this.Campos.add(new CHCampo_Text("act_liq", this.PAG.getJTextField_Activo(), CFLib.VLD_VALOR));
        this.Campos.add(new CHCampo_Text("cap_prop", this.PAG.getJTextField_CapProp(), CFLib.VLD_VALOR_S));
        this.Campos.add(new CHCampo_Text("suprim", this.PAG.getJTextField_Sup(), CFLib.VLD_VALOR));
        this.Campos.add(new CHCampo_Text("suprim_cons", this.PAG.getJTextField_SupCons(), CFLib.VLD_VALOR));
    }

    void on_update(String tag) {
        if (!tag.equals("balanco") && !tag.equals("bal_intercalar")) {
            tag.equals("data_bi");
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        String msg = "";
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Dados para o C\u00e1lculo da Autonomia Financeira");
        }
        this.extract();
        CBData.Promotor.extract();
        if (this.getByName("bal_intercalar").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("bal_intercalar", "Possui Balan\u00e7o Intercalar certificado por um ROC - %o"));
        }
        if (this.getByName((String)"bal_intercalar").v.equals("1")) {
            msg = "Se h\u00e1 Balan\u00e7o Intercalar: ";
            if (this.getByName("data_bi").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("data_bi", String.valueOf(msg) + "Data - %o"));
            } else {
                int ano = Integer.parseInt(CBData.DadosGerais.getByName((String)"ano_cand").v.toString());
                int ano_bal = Integer.parseInt(this.getByName((String)"data_bi").v.substring(0, 4));
                if (ano_bal != ano && ano_bal != ano - 1) {
                    err_list.add_msg(new CHValid_Msg("ano", 'W', "Ano do Balan\u00e7o Intercalar deve ser o mesmo ou o anterior ao de Candidatura (" + ano + ")"));
                }
            }
            if (this.getByName("act_liq").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("act_liq", String.valueOf(msg) + "Activo - %o"));
            }
            if (this.getByName("cap_prop").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("cap_prop", String.valueOf(msg) + "Capital Pr\u00f3prio - %o"));
            }
            double suprim = this.getByName("suprim").valueAsDouble();
            double suprim_c = this.getByName("suprim_cons").valueAsDouble();
            if (_lib.round(suprim_c) > _lib.round(suprim)) {
                err_list.add_msg(new CHValid_Msg("suprim_cons", "Suprimentos a consolidar n\u00e3o podem ser superiores a Suprimentos"));
            }
        }
        if (this.getByName((String)"bal_intercalar").v.equals("0")) {
            msg = "Se n\u00e3o h\u00e1 Balan\u00e7o Intercalar: ";
            if (!this.getByName("data_bi").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("data_bi", String.valueOf(msg) + "Data - Neste caso n\u00e3o preenche"));
            }
            if (!this.getByName("act_liq").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("act_liq", String.valueOf(msg) + "Activo - Neste caso n\u00e3o preenche"));
            }
            if (!this.getByName("cap_prop").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("cap_prop", String.valueOf(msg) + "Capital Pr\u00f3prio - Neste caso n\u00e3o preenche"));
            }
            if (!this.getByName("suprim").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("suprim", String.valueOf(msg) + "Suprimentos - Neste caso n\u00e3o preenche"));
            }
            if (!this.getByName("suprim_cons").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("suprim_cons", String.valueOf(msg) + "Suprimentos a Consolidar - Neste caso n\u00e3o preenche"));
            }
        }
        return err_list;
    }
}

