/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_PG11_CaractOperacao;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import javax.swing.JOptionPane;

class CBTabela_CaractIntervencoes
extends CBTabela {
    Frame_PG11_CaractOperacao PAG = null;
    boolean showIVA;

    public String getPagina() {
        return "PG11_CaractOperacao";
    }

    CBTabela_CaractIntervencoes() {
        this.tag = "CaractIntervencoes";
        this.PAG = (Frame_PG11_CaractOperacao)fmeFrame.Paginas.getPage("PG11_CaractOperacao");
        this.showIVA = this.PAG.showIVA;
        Frame_PG11_CaractOperacao.CaractIntervencoes = this;
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.updateUI();
        this.init_dados(12);
        this.PAG.getJTable_TipInvestimento().tab = this;
        this.PAG.getJTable_TipInvestimento().addKeyListener(new TableKeyListener(this));
    }

    public void updateUI() {
        if (!this.started) {
            return;
        }
        this.showIVA = this.PAG.showIVA;
        this.started = true;
        this.cols = new CHTabColModel[17];
        this.cols[0] = new CHTabColModel("n_dossier", "N,\u00ba Dossier", 3, false, true, null);
        this.cols[1] = new CHTabColModel("investimento", "Investimento", 3, true, true, null);
        this.cols[2] = new CHTabColModel("declive", "Declive Transversal", 3, true, true, null);
        this.cols[3] = new CHTabColModel("sub_roc", "Substrato Rochoso", 3, true, true, null);
        this.cols[4] = new CHTabColModel("decliveN_c", "Declive", 3, true, false, null);
        this.cols[5] = new CHTabColModel("decliveN_d", "Declive", 3, true, true, null);
        this.cols[6] = new CHTabColModel("elems_gross", "Elementos Grosseiros", 3, true, true, null);
        this.cols[7] = new CHTabColModel("alt_vege", "Altura Vegeta\u00e7\u00e3o", 3, true, true, null);
        this.cols[8] = new CHTabColModel("est_cam", "Estado do caminho", 3, true, true, null);
        this.cols[9] = new CHTabColModel("alarg_cam", "Alargamento do caminho", 3, true, true, null);
        this.cols[10] = new CHTabColModel("propria", "Pr\u00f3pria", 3, true, true, null);
        this.cols[11] = new CHTabColModel("compr", "Comprimento", 3, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[12] = new CHTabColModel("t_siva", "Total S/IVA", 3, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[13] = new CHTabColModel("iva", "Taxa IVA", 3, true, this.showIVA, null);
        this.cols[14] = new CHTabColModel("t_civa", "Total C/IVA", 3, false, this.showIVA, (CFType)CFLib.VLD_VALOR_0);
        this.cols[15] = new CHTabColModel("data", "Data Realiza\u00e7\u00e3o", 3, true, true, (CFType)CFLib.VLD_ANO_MES);
        this.cols[16] = new CHTabColModel("nparcelario", "N.\u00ba de parcel\u00e1rio", 3, true, true, null);
        this.init_handler(this.PAG.getJTable_TipInvestimento());
        this.handler.width = this.PAG.getJScrollPane_Investimento().getWidth() - 21;
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.PAG.getJTable_TipInvestimento());
        this.handler.set_col_comboS(1, 0.18, "L", CTabelas.CaractInterv_Investimento, 1, 160);
        this.handler.set_col_comboS(2, 0.14, "L", CTabelas.CaractInterv_Declive, 1, 80);
        this.handler.set_col_comboS(3, 0.16, "L", CTabelas.CaractInterv_SubRoc, 1, 140);
        this.handler.set_col_comboS(5, 0.14, "L", CTabelas.CaractInterv_Declive, 1, 80);
        this.handler.set_col_comboS(6, 0.16, "L", CTabelas.CaractInterv_ElemsGross, 1, 80);
        this.handler.set_col_comboS(7, 0.16, "L", CTabelas.AlturaVege, 1, 100);
        this.handler.set_col_comboS(8, 0.16, "L", CTabelas.CaractInterv_EstadoCaminho, 1, 100);
        this.handler.set_col_comboS(9, 0.16, "L", CTabelas.CaractInterv_AlargCaminho, 1, 100);
        this.handler.set_col_comboS(10, 0.16, "L", CTabelas.CaractInterv_Propria, 1, 100);
        this.handler.set_col_text(11, 0.17, "C");
        this.handler.set_col_text(12, 0.17, "R");
        if (this.showIVA) {
            this.handler.set_col_comboS(13, 0.17, "C", CTabelas.Iva, 1, 50);
            this.handler.set_col_text(14, 0.17, "R");
        }
        this.handler.set_col_text(15, 0.15, "C");
        this.handler.set_col_text(16, 0.25, "C");
        this.ui.add_col(0, 0, 1, 2, "N.\u00ba Dossier");
        this.ui.add_col(1, 0, 1, 2, "Investimento");
        this.ui.add_col(2, 0, 1, 2, "Declive Transversal");
        this.ui.add_col(3, 0, 1, 2, "Substrato<br>rochoso");
        this.ui.add_col(4, 0, 1, 2, "Declive");
        this.ui.add_col(5, 0, 1, 2, "elementos<br>grosseiros %");
        this.ui.add_col(6, 0, 1, 2, "altura vegeta\u00e7\u00e3o<br>(cm)");
        this.ui.add_col(7, 0, 1, 2, "Estado caminho");
        this.ui.add_col(8, 0, 1, 2, "Alargamento<br>caminho");
        this.ui.add_col(9, 0, 1, 2, "Pr\u00f3pria");
        this.ui.add_col(10, 0, 1, 2, "Comprimento<br>(km)");
        this.ui.add_col(11, 0, 1, 2, "Total S/IVA");
        if (this.showIVA) {
            this.ui.add_col(12, 0, 1, 2, "Taxa IVA");
            this.ui.add_col(13, 0, 1, 2, "Total C/IVA");
            this.ui.add_col(14, 0, 1, 2, "Data de realiza\u00e7\u00e3o<br>(aaaa-mm)");
            this.ui.add_col(15, 0, 1, 2, "<html>N.\u00ba de parcel\u00e1rio/<br>n.\u00ba P3 PINV</html>");
        } else {
            this.ui.add_col(12, 0, 1, 2, "Data de realiza\u00e7\u00e3o<br>(aaaa-mm)");
            this.ui.add_col(13, 0, 1, 2, "<html>N.\u00ba de parcel\u00e1rio/<br>n.\u00ba P3 PINV</html>");
        }
        this.PAG.getJTable_TipInvestimento().getTableHeader().setUI(this.ui);
    }

    public void calcTotal() {
        if (this.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String val = this.getColValue("t_siva", i);
                if (val.equals("")) {
                    this.setColValue("t_civa", i, val);
                } else if (!this.showIVA) {
                    this.setColValue("t_civa", i, val);
                } else {
                    double rata = 0.0;
                    double perc = this.getColValue("iva", i).equals("") ? 0.0 : _lib.to_double(this.getColValue("iva", i)) / 100.0;
                    if (CBData.Promotor.getByName((String)"regimeIva").v.equals("2")) {
                        rata = CBData.Promotor.getByName("pro_rata").valueAsDouble() / 100.0;
                    }
                    perc = _lib.to_double(val) * (1.0 + perc * (1.0 - rata));
                    this.setColValue("t_civa", i, String.valueOf(perc));
                }
            }
            ++i;
        }
    }

    void on_set_geo() {
        CBData.on_set_geo(this);
        this.PAG.enable_PromLocal();
    }

    public void clear() {
        super.clear();
        this.PAG.enable_PromLocal();
    }

    void on_update(String colname, int nRow, String v, String x) {
        if (colname.equalsIgnoreCase("decliveN_d")) {
            if (!this.getColValue("decliveN_d", nRow).equalsIgnoreCase("")) {
                this.setColValue("decliveN_c", nRow, CTabelas.CaractInterv_Declive.lookup(1, this.getColValue("decliveN_d", nRow), 0));
            } else {
                this.setColValue("decliveN_c", nRow, "");
            }
        }
        if (colname.equalsIgnoreCase("investimento")) {
            CBData.CaractOperacao11.numera();
        }
        if (colname.equals("iva") || colname.equals("t_siva")) {
            this.calcTotal();
        }
        if (colname.equalsIgnoreCase("data") && !v.equalsIgnoreCase("") && !CBData.RegistoLocalizacao.getByName("investIni").isEmpty() && !CBData.RegistoLocalizacao.getByName("investFim").isEmpty()) {
            String[] dataInvest1 = CBData.RegistoLocalizacao.getByName((String)"investIni").v.split("-");
            double anoInit = _lib.to_double(dataInvest1[0]);
            double mesInit = _lib.to_double(dataInvest1[1]);
            String[] dataInvest2 = CBData.RegistoLocalizacao.getByName((String)"investFim").v.split("-");
            double anoFim = _lib.to_double(dataInvest2[0]);
            double mesFim = _lib.to_double(dataInvest2[1]);
            String[] data = v.split("-");
            double anoCurr = _lib.to_double(data[0]);
            double mesCurr = _lib.to_double(data[1]);
            if (anoInit > anoCurr || anoCurr > anoFim) {
                JOptionPane.showMessageDialog(null, "Data inv\u00e1lida.", "Erro", 0);
                this.setColValue("data", nRow, "");
            } else if (anoInit <= anoCurr && anoCurr <= anoFim && (anoInit == anoCurr && mesInit > mesCurr || anoCurr == anoFim && mesFim < mesCurr)) {
                JOptionPane.showMessageDialog(null, "Data inv\u00e1lida.", "Erro", 0);
                this.setColValue("data", nRow, "");
            }
        }
        if (colname.equals("data") || colname.equals("t_siva") || colname.equals("t_civa") || colname.equals("iva")) {
            CBData.calcInvestimentos(this.showIVA);
        }
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        this.handler.__garbage_stop_editing();
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Caracteriza\u00e7\u00e3o de Infraestruturas");
        }
        int i = 0;
        while (i < this.dados.size()) {
            String mask = this.getMask(i);
            TabError[] e = this.isIncompletAll(i, mask);
            int ii = 0;
            while (e != null && ii < e.length) {
                err_list.add_msg(new CHValid_Msg(e[ii]));
                ++ii;
            }
            ++i;
        }
        int k = 0;
        while (k != this.dados.size()) {
            if (!(this.isRowEmpty(k) || this.getColValue("nparcelario", k).matches("\\d{13}") || this.getColValue("nparcelario", k).matches("\\d{13}-\\d{3}"))) {
                err_list.add_msg(new CHValid_Msg("nparcelario", 'E', "Linha " + (k + 1) + ": Formato de parcel\u00e1rio incorrecto, deve ter 13 d\u00edgitos ou 13 d\u00edgitos - (tra\u00e7o) 3 d\u00edgitos", k, this.getColIndex("nparcelario")));
            }
            ++k;
        }
        return err_list;
    }

    private String getMask(int nRow) {
        StringBuffer mask = new StringBuffer("-R");
        if (this.getColValue("investimento", nRow).equalsIgnoreCase("Const. Rede Vi\u00e1ria")) {
            mask.append("RR------RR");
        } else if (this.getColValue("investimento", nRow).equalsIgnoreCase("Benef. Rede Vi\u00e1ria")) {
            mask.append("------RRRR");
        } else if (this.getColValue("investimento", nRow).equalsIgnoreCase("Abertura Rede Divisional") || this.getColValue("investimento", nRow).equalsIgnoreCase("Benef. Rede Divisional")) {
            mask.append("---RRR--RR");
        } else {
            mask.append("--------RR");
        }
        if (this.showIVA) {
            mask.append("RR-RR-");
        } else {
            mask.append("R--RR-");
        }
        return mask.toString();
    }
}

