/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_PG2_Promotor;
import fme.fmeFrame;

class CBRegisto_Promotor
extends CBRegisto {
    Frame_PG2_Promotor PAG = null;
    boolean firstTimeUpdate = true;

    public String getPagina() {
        return "PG2_Promotor";
    }

    CBRegisto_Promotor() {
        this.tag = "Promotor";
        this.PAG = (Frame_PG2_Promotor)fmeFrame.Paginas.getPage("PG2_Promotor");
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.PAG.CBRegisto_Promotor = this;
        String[] opt2 = new String[]{"0", "1"};
        this.Campos.add(new CHCampo_Text("ano_candid", this.PAG.getjTextField_AnoCand(), CFLib.VLD_INT, this));
        this.Campos.add(new CHCampo_Combo("concelho", CTabelas.ConcelhosF1, this.PAG.getJComboBox_Concelho(), this));
        this.Campos.add(new CHCampo_Combo("distrito", CTabelas.Distritos, this.PAG.getJComboBox_Distrito(), this));
        this.Campos.add(new CHCampo_Text("nif", this.PAG.getJTextField_NIF(), CFLib.VLD_NIF, this));
        this.Campos.add(new CHCampo_Text("nifap", this.PAG.getJTextField_NIFAP(), CFLib.VLD_INT, this));
        this.Campos.add(new CHCampo_Text("nome", this.PAG.getJTextField_Nome(), null, this));
        this.Campos.add(new CHCampo_Text("morada", this.PAG.getJTextField_Morada(), null));
        this.Campos.add(new CHCampo_Text("localidade", this.PAG.getJTextField_Localidade(), null));
        this.Campos.add(new CHCampo_Text("cod_postal", this.PAG.getJTextField_CodPostal(), CFLib.VLD_COD_POSTAL));
        this.Campos.add(new CHCampo_Text("loc_postal", this.PAG.getJTextField_LocPostal(), null));
        this.Campos.add(new CHCampo_Text("nuts_ii", this.PAG.getJTextField_Regiao(), null));
        this.Campos.add(new CHCampo_Text("nuts_ii_d", this.PAG.getJTextField_RegiaoD(), null));
        this.Campos.add(new CHCampo_Text("nuts_iii", this.PAG.getJTextField_NutsIII(), null));
        this.Campos.add(new CHCampo_Text("nuts_iii_d", this.PAG.getJTextField_NutsIIID(), null));
        this.Campos.add(new CHCampo_Text("telefone", this.PAG.getJTextField_Telefone(), null));
        this.Campos.add(new CHCampo_Text("telefax", this.PAG.getJTextField_Telefax(), null));
        this.Campos.add(new CHCampo_Text("email", this.PAG.getJTextField_EMail(), CFLib.VLD_EMAIL));
        this.Campos.add(new CHCampo_Text("resp_nome", this.PAG.getJTextField_RespNome(), null));
        this.Campos.add(new CHCampo_Text("resp_funcao", this.PAG.getJTextField_RespFunc(), null));
        this.Campos.add(new CHCampo_Text("resp_telefone", this.PAG.getJTextField_RespTelef(), null, this));
        this.Campos.add(new CHCampo_Text("resp_email", this.PAG.getJTextField_RespEMail(), CFLib.VLD_EMAIL, this));
        String[] regIva = new String[]{"0", "1", "2", "3", "4", "5"};
        CHCampo_Opt sujPassivo = new CHCampo_Opt("regimeIva", regIva, this);
        sujPassivo.addComponent(this.PAG.getJCheckBox_RN());
        sujPassivo.addComponent(this.PAG.getJCheckBox_AR());
        sujPassivo.addComponent(this.PAG.getJCheckBox_PR());
        sujPassivo.addComponent(this.PAG.getJCheckBox_art9());
        sujPassivo.addComponent(this.PAG.getJCheckBox_art2());
        sujPassivo.addComponent(this.PAG.getJCheckBox_art53());
        sujPassivo.dummy = this.PAG.jCheckBox_IvaClear;
        this.Campos.add(sujPassivo);
        this.Campos.add(new CHCampo_Text("pro_rata", this.PAG.getJTextField_Taxa(), CFLib.VLD_VALOR_S0, this));
        CHCampo_Opt autoriza = new CHCampo_Opt("autoriza", opt2, this);
        autoriza.addComponent(this.PAG.getJCheckBox_AutSim());
        autoriza.dummy = this.PAG.jCheckBox_AutClear;
        this.Campos.add(autoriza);
        this.init();
    }

    void init() {
        this.getByName("ano_candid").setStringValue(Integer.toString(CFLib.VLD_ANO_CAND.ano_inicial));
        this.on_update("ano_candid");
        this.firstTimeUpdate = false;
    }

    void on_update(String tag) {
        if (tag.equalsIgnoreCase("regimeIva")) {
            if (this.getByName("regimeIva").getStringValue().equalsIgnoreCase("0")) {
                CBData.CaractOperacao11.on_update_colunas(false);
            } else {
                CBData.CaractOperacao11.on_update_colunas(true);
            }
        }
        if (tag.equals("ano_candid")) {
            try {
                int ano = 0;
                ano = Integer.parseInt(this.PAG.getjTextField_AnoCand().getText());
            }
            catch (Exception ano) {
                // empty catch block
            }
        }
        if (tag.equals("concelho")) {
            String concelho = this.getByName("concelho").getStringValue();
            if (concelho.length() > 0) {
                String nuts_ii = CTabelas.Concelhos.lookup(0, concelho, 5);
                String nuts_iii = CTabelas.Concelhos.lookup(0, concelho, 2);
                this.getByName("distrito").setStringValue(concelho.substring(0, 2));
                this.getByName("nuts_ii").setStringValue(nuts_ii);
                this.getByName("nuts_ii_d").setStringValue(CTabelas.NUTS2.getDesign(nuts_ii));
                this.getByName("nuts_iii").setStringValue(nuts_iii);
                this.getByName("nuts_iii_d").setStringValue(CTabelas.NUTS3.getDesign(nuts_iii));
                String prof = CTabelas.Concelhos.lookup(0, concelho, 6);
            } else {
                this.getByName("nuts_iii_d").setStringValue("");
                this.getByName("nuts_iii").setStringValue("");
                this.getByName("nuts_ii_d").setStringValue("");
                this.getByName("nuts_ii").setStringValue("");
            }
        }
        if (tag.equals("distrito")) {
            String distrito = this.getByName("distrito").getStringValue();
            String concelho = this.getByName("concelho").getStringValue();
            if (distrito.length() == 0) {
                CTabelas.ConcelhosF1.clear_filter();
                CTabelas.ConcelhosF1._populateComboBox(this.PAG.getJComboBox_Concelho());
            } else if (concelho.length() == 0 || !distrito.equals(concelho.substring(0, 2))) {
                CTabelas.ConcelhosF1.set_filter(3, distrito);
                CTabelas.ConcelhosF1._populateComboBox(this.PAG.getJComboBox_Concelho());
            }
        }
    }

    String on_xml(String tag) {
        if (tag.equals("concelho")) {
            return this.on_xml_d(tag, CTabelas.Concelhos);
        }
        if (tag.equals("distrito")) {
            return this.on_xml_d(tag, CTabelas.Distritos);
        }
        if (tag.equals("tipologia")) {
            return this.on_xml_d(tag, CTabelas.TipologiaBeneficiario);
        }
        return "";
    }

    CHValid_Grp validar() {
        CHValid_Grp err_list = new CHValid_Grp(this, "Identifica\u00e7\u00e3o do Promotor");
        this.extract();
        Frame_PG2_Promotor page2 = (Frame_PG2_Promotor)fmeFrame.Paginas.getPage("PG2_Promotor");
        if (this.getByName("autoriza").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("autoriza", "Autoriza\u00e7\u00e3o de dados - %o"));
        }
        if (this.getByName("ano_candid").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("ano_candid", "Ano de Candidatura - %o"));
        }
        if (this.getByName("nif").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nif", "N\u00ba de Identifica\u00e7\u00e3o Fiscal - %o"));
        }
        if (this.getByName("nifap").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nifap", "Nifap - %o"));
        }
        if (this.getByName("nome").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("nome", "Nome ou Designa\u00e7\u00e3o Social - %o"));
        }
        if (this.getByName("morada").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("morada", "Morada (Sede Social) - %o"));
        }
        if (this.getByName("localidade").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("localidade", "Localidade - %o"));
        }
        if (this.getByName("cod_postal").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("cod_postal", "C\u00f3digo Postal - %o"));
        }
        if (this.getByName("loc_postal").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("loc_postal", "C\u00f3digo Postal (localidade) - %o"));
        }
        if (this.getByName("distrito").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("distrito", "Distrito - %o"));
        }
        if (this.getByName("concelho").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("concelho", "Concelho - %o"));
        }
        if (this.getByName("telefone").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("telefone", "Telefone - %o"));
        }
        if (this.getByName("email").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("email", "E-mail - %o"));
        }
        if (this.getByName("regimeIva").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("regimeIva", "Regime de Iva - %o"));
        }
        if (this.getByName("resp_nome").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("resp_nome", "Nome (Respons\u00e1vel da Opera\u00e7\u00e3o - %o"));
        }
        if (this.getByName("resp_funcao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("resp_funcao", "Fun\u00e7\u00e3o (Respons\u00e1vel da Opera\u00e7\u00e3o - %o"));
        }
        if (this.getByName("resp_telefone").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("resp_telefone", "Telefone (Respons\u00e1vel da Opera\u00e7\u00e3o - %o"));
        }
        if (this.getByName("resp_email").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("resp_email", "Email (Respons\u00e1vel da Opera\u00e7\u00e3o - %o"));
        }
        if (page2.getJCheckBox_Consult_Sim().isSelected()) {
            if (this.getByName("consultor_nif").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_nif", "N\u00ba de Identifica\u00e7\u00e3o Fiscal (Consultor)- %o"));
            }
            if (this.getByName("consultor_nome").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_nome", "Nome ou Designa\u00e7\u00e3o (Consultor)- %o"));
            }
            if (this.getByName("consultor_morada").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_morada", "Morada (Sede Social) (Consultor)- %o"));
            }
            if (this.getByName("consultor_cod_postal").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_cod_postal", "C\u00f3digo Postal (Consultor)- %o"));
            }
            if (this.getByName("consultor_loc_postal").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_loc_postal", "C\u00f3digo Postal (Localidade) (Consultor)- %o"));
            }
            if (this.getByName("consultor_contacto").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_contacto", "Contacto (Consultor)- %o"));
            }
            if (this.getByName("consultor_telefone").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_telefone", "Telefones(s) (Consultor)- %o"));
            }
            if (this.getByName("consultor_email").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("consultor_email", "Email (Consultor)- %o"));
            }
            if (this.getByName("tecnico_nome").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("tecnico_nome", "Nome do t\u00e9cnico respons\u00e1vel pela elabora\u00e7\u00e3o/acompanhamento (Consultor)- %o"));
            }
            if (this.getByName("tecnico_habilitacoes").isEmpty()) {
                err_list.add_msg(new CHValid_Msg("tecnico_habilitacoes", "Habilita\u00e7\u00f5es do respons\u00e1vel pela elabora\u00e7\u00e3o do pedido de apoio (Consultor)- %o"));
            }
        }
        return err_list;
    }
}

