/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CParseConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JComboBox;

class CTabela {
    String name;
    String[] titles;
    Vector data_table = new Vector();
    int cCol;
    int dCol;

    public CTabela() {
    }

    public CTabela(String nome) {
        this(nome, true);
    }

    public CTabela(String nome, boolean override) {
        Object p = override ? CParseConfig.tabelas.get(nome) : null;
        this._init_tab(nome, p == null ? nome : (String)p);
        this.cCol = 0;
        this.dCol = 1;
    }

    public String getCodeFromIndex(int idx) {
        return this.getColFromIndex(idx, this.cCol);
    }

    public String getDesignFromIndex(int idx) {
        return this.getColFromIndex(idx, this.dCol);
    }

    public String getColFromIndex(int idx, int nCol) {
        if (idx == 0) {
            return "";
        }
        String[] item = (String[])this.data_table.elementAt(idx - 1);
        return item[nCol];
    }

    String lookup(String codigo) {
        return this.lookup(this.cCol, codigo, this.dCol);
    }

    String lookup(int _cCol, String codigo, int _dCol) {
        if (codigo.length() > 0) {
            int i = 0;
            while (i < this.data_table.size()) {
                String[] item = (String[])this.data_table.elementAt(i);
                if (item[_cCol].equals(codigo)) {
                    return item[_dCol];
                }
                ++i;
            }
        }
        return "";
    }

    String linkup(String cod_0, String cod_1, int _dCol) {
        if (cod_0.length() > 0 && cod_1.length() > 0) {
            int i = 0;
            while (i < this.data_table.size()) {
                String[] item = (String[])this.data_table.elementAt(i);
                if (item[0].equals(cod_0) && item[1].equals(cod_1)) {
                    return item[_dCol];
                }
                ++i;
            }
        }
        return "";
    }

    int getIndexFromCode(String codigo) {
        return this.getIndexFromCol(this.cCol, codigo);
    }

    int getIndexFromDesign(String codigo) {
        return this.getIndexFromCol(this.dCol, codigo);
    }

    String getCodeFromDesign(String codigo) {
        int n = this.getIndexFromCol(this.dCol, codigo);
        return this.getCodeFromIndex(n);
    }

    int getIndexFromCol(int col, String codigo) {
        if (codigo == null || codigo.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < this.data_table.size()) {
            String[] item = (String[])this.data_table.elementAt(i);
            if (item[col].equals(codigo)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getDesign(String code) {
        int n = this.getIndexFromCode(code);
        return this.getDesignFromIndex(n + 1);
    }

    public void _populateComboBox(JComboBox cbo, String v) {
        this._populateComboBox(cbo, this.dCol, v);
    }

    public void _populateComboBox(JComboBox cbo, int nCol, String v) {
        int n;
        if (this._populateComboBox(cbo, nCol) && v.length() > 0 && (n = this.getIndexFromCode(v)) >= 0) {
            cbo.setSelectedIndex(n + 1);
        }
    }

    public boolean _populateComboBox(JComboBox cbo) {
        return this._populateComboBox(cbo, this.dCol);
    }

    public boolean _populateComboBox(JComboBox cbo, int nCol) {
        cbo.removeAllItems();
        cbo.addItem("");
        int i = 0;
        while (i < this.data_table.size()) {
            String[] item = (String[])this.data_table.elementAt(i);
            cbo.addItem(item[nCol]);
            ++i;
        }
        return true;
    }

    public boolean _init_tab(String tabname, String filename) {
        String s;
        BufferedReader in;
        block4: {
            this.name = tabname;
            in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(String.valueOf(filename) + ".tab"), "CP1252"));
            s = in.readLine();
            if (s != null) break block4;
            return false;
        }
        try {
            this.titles = this.explode(s);
            while ((s = in.readLine()) != null) {
                this.data_table.add(this.explode(s));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public String[] explode(String s) {
        int i = 0;
        int j = s.indexOf(124, 0);
        String[] temp = new String[99];
        int n_elem = 0;
        while (j != -1) {
            temp[n_elem] = new String(s.substring(i, j));
            i = j + 1;
            j = s.indexOf(124, i);
            ++n_elem;
        }
        temp[n_elem] = new String(s.substring(i));
        String[] a_row = new String[++n_elem];
        System.arraycopy(temp, 0, a_row, 0, n_elem);
        return a_row;
    }
}

