/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBRegisto;
import fme.CFLib;
import fme.CFType_Data;
import fme.CHCampo_Combo;
import fme.CHCampo_Opt;
import fme.CHCampo_Text;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_ProjInd;
import fme._lib;
import fme.fmeFrame;
import java.util.Date;

class CBRegisto_ProjInd
extends CBRegisto {
    Frame_ProjInd PAG = null;
    String pag = "ProjInd";

    @Override
    public String getPagina() {
        return this.pag;
    }

    CBRegisto_ProjInd() {
        this.tag = "Proj";
        this.PAG = (Frame_ProjInd)fmeFrame.Paginas.getPage(this.pag);
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.Campos.add(new CHCampo_Text("designacao", this.PAG.getJTextField_Designacao(), null));
        this.Campos.add(new CHCampo_Combo("tipologia", CTabelas.Tipologia, this.PAG.getJComboBox_Tipologia(), this));
        this.Campos.add(new CHCampo_Combo("natureza", CTabelas.Natureza, this.PAG.getJComboBox_Natureza(), this));
        this.Campos.add(new CHCampo_Combo("sector", CTabelas.Sectores, this.PAG.getJComboBox_Sector(), this));
        this.Campos.add(new CHCampo_Text("data_inicio", this.PAG.getJTextField_Inicio(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("data_fim", this.PAG.getJTextField_Fim(), CFLib.VLD_DATA, this));
        this.Campos.add(new CHCampo_Text("ano_cruz", this.PAG.getJTextField_AnoCruzeiro(), CFLib.VLD_ANO, this));
        this.Campos.add(new CHCampo_Text("ano_conc", this.PAG.getJTextField_AnoFimProj(), CFLib.VLD_ANO, this));
        this.Campos.add(new CHCampo_Text("investimento", this.PAG.getJTextField_InvTotal(), CFLib.VLD_VALOR_S));
        this.Campos.add(new CHCampo_Text("elegivel", this.PAG.getJTextField_InvEleg(), CFLib.VLD_VALOR_S));
        String[] opt2 = new String[]{"1", "0"};
        CHCampo_Opt tem_iso = new CHCampo_Opt("tem_iso", opt2, this);
        tem_iso.addComponent(this.PAG.getJCheckBox_TemIso14_Sim());
        tem_iso.addComponent(this.PAG.getJCheckBox_TemIso14_Nao());
        tem_iso.dummy = this.PAG.jCheckBox_TemIso14_Clear;
        this.Campos.add(tem_iso);
    }

    @Override
    String on_xml(String tag) {
        if (tag.equals("data_fim")) {
            return _lib.xml_encode("ano_base", Integer.toString(CBData.anoInd));
        }
        if (tag.equals("tipologia")) {
            return this.on_xml_d(tag, CTabelas.Tipologia);
        }
        if (tag.equals("natureza")) {
            return this.on_xml_d(tag, CTabelas.Natureza);
        }
        if (tag.equals("sector")) {
            return this.on_xml_d(tag, CTabelas.Sectores);
        }
        return "";
    }

    @Override
    void on_update(String tag) {
        if (tag.equals("tipologia") || tag.equals("sector")) {
            String tipo = CTabelas.Tipologia.lookup(0, this.getByName((String)"tipologia").v, 2);
            String sector = CTabelas.Sectores.lookup(0, this.getByName((String)"sector").v, 4);
            if (CBData.Doc2.started) {
                CBData.Doc2.getByName("doc_2051").setStringValue(tipo.equals("M") && sector.equals("A") ? "1" : "");
            }
        }
        if (tag.equals("tem_iso") && CBData.Doc3.started) {
            CBData.Doc3.getByName("doc_3181").setStringValue(this.getByName((String)tag).v.equals("1") ? "1" : "");
        }
        if (tag.equals("data_inicio") || tag.equals("data_fim") || tag.equals("ano_cruz")) {
            CBData.on_update_proj_ind();
        }
    }

    CHValid_Grp validar_1(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.getByName("designacao").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("designacao", "Designa\u00e7\u00e3o - %o"));
        }
        if (this.getByName("tipologia").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("tipologia", "Tipologia - %o"));
        }
        if (this.getByName("natureza").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("natureza", "Natureza - %o"));
        }
        if (this.getByName("sector").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("sector", "Fileira - %o"));
        }
        return err_list;
    }

    CHValid_Grp validar_2(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.getByName("data_inicio").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("data_inicio", "Data de In\u00edcio do Investimento - %o"));
        }
        if (this.getByName("data_fim").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("data_fim", "Data de Fim do Investimento - %o"));
        }
        if (this.getByName("ano_cruz").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("ano_cruz", "Ano Cruzeiro - %o"));
        }
        if (this.getByName("ano_conc").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("ano_conc", "Ano de Termo da Opera\u00e7\u00e3o - %o"));
        }
        Date data_inicio = CFType_Data.parse_date(this.getByName((String)"data_inicio").v);
        Date data_fim = CFType_Data.parse_date(this.getByName((String)"data_fim").v);
        Date min_inv = CFType_Data.parse_date("2007-01-01");
        Date min_cruz = CFType_Data.parse_date("2008-01-01");
        Date data_cruz = CFType_Data.parse_date(String.valueOf(this.getByName((String)"ano_cruz").v) + "-12-31");
        Date data_conc = CFType_Data.parse_date(String.valueOf(this.getByName((String)"ano_conc").v) + "-12-31");
        if (data_inicio != null && data_inicio.before(min_inv)) {
            err_list.add_msg(new CHValid_Msg("data_inicio", "In\u00edcio do Investimento n\u00e3o pode ser anterior a 2007"));
        }
        if (data_inicio != null && data_fim != null && data_fim.before(data_inicio)) {
            err_list.add_msg(new CHValid_Msg("data_fim", "Conclus\u00e3o do Investimento n\u00e3o pode ser anterior ao In\u00edcio"));
        }
        if (data_cruz != null && data_cruz.before(min_cruz)) {
            err_list.add_msg(new CHValid_Msg("data_cruz", "Ano Cruzeiro n\u00e3o pode ser anterior a 2008"));
        }
        if (data_fim != null && data_cruz != null && data_cruz.before(data_fim)) {
            err_list.add_msg(new CHValid_Msg("ano_cruz", "Ano Cruzeiro n\u00e3o pode ser anterior ao Fim do Investimento"));
        }
        if (data_cruz != null && data_conc != null && data_conc.before(data_cruz)) {
            err_list.add_msg(new CHValid_Msg("ano_conc", "Ano de Termo n\u00e3o pode ser anterior ao Ano Cruzeiro"));
        }
        return err_list;
    }

    CHValid_Grp validar_3(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.getByName("tem_iso").isEmpty()) {
            err_list.add_msg(new CHValid_Msg("tem_iso", "Certifica\u00e7\u00e3o NP EN ISO 14001:2004 - %o"));
        }
        return err_list;
    }
}

