/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;

public class JRDesignStyle
extends JRBaseStyle {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DEFAULT = "default";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_PARENT_STYLE = "parentStyle";
    public static final String PROPERTY_PARENT_STYLE_NAME_REFERENCE = "parentStyleNameReference";
    public static final String PROPERTY_CONDITIONAL_STYLES = "conditionalStyles";
    private List conditionalStylesList = new ArrayList();

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getEventSupport().firePropertyChange(PROPERTY_NAME, old, this.name);
    }

    public void setDefault(boolean isDefault) {
        boolean old = this.isDefault;
        this.isDefault = isDefault;
        this.getEventSupport().firePropertyChange(PROPERTY_DEFAULT, old, this.isDefault);
    }

    public void setParentStyle(JRStyle parentStyle) {
        JRStyle old = this.getStyle();
        super.setParentStyle(parentStyle);
        this.getEventSupport().firePropertyChange(PROPERTY_PARENT_STYLE, old, this.getStyle());
    }

    public void addConditionalStyle(JRConditionalStyle conditionalStyle) {
        this.conditionalStylesList.add(conditionalStyle);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CONDITIONAL_STYLES, conditionalStyle, this.conditionalStylesList.size() - 1);
    }

    public boolean removeConditionalStyle(JRConditionalStyle conditionalStyle) {
        int idx = this.conditionalStylesList.indexOf(conditionalStyle);
        if (idx >= 0) {
            this.conditionalStylesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CONDITIONAL_STYLES, conditionalStyle, idx);
            return true;
        }
        return false;
    }

    public JRConditionalStyle[] getConditionalStyles() {
        return this.conditionalStylesList.toArray(new JRDesignConditionalStyle[this.conditionalStylesList.size()]);
    }

    public List getConditionalStyleList() {
        return this.conditionalStylesList;
    }

    public void setParentStyleNameReference(String styleName) {
        String old = this.parentStyleNameReference;
        this.parentStyleNameReference = styleName;
        this.getEventSupport().firePropertyChange(PROPERTY_PARENT_STYLE_NAME_REFERENCE, old, this.parentStyleNameReference);
    }

    public Object clone() {
        JRDesignStyle clone = (JRDesignStyle)super.clone();
        if (this.conditionalStylesList != null) {
            clone.conditionalStylesList = new ArrayList(this.conditionalStylesList.size());
            Iterator it = this.conditionalStylesList.iterator();
            while (it.hasNext()) {
                JRConditionalStyle style = (JRConditionalStyle)it.next();
                JRConditionalStyle styleClone = (JRConditionalStyle)style.clone();
                clone.conditionalStylesList.add(styleClone);
            }
        }
        return clone;
    }
}

