/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_QInvAgr;
import fme.SteppedComboBox;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;

class CBTabela_QInvAgr
extends CBTabela {
    JComboBox cboEstabs = null;
    Frame_QInvAgr PAG = null;
    CBTabela geo = null;
    String pag = "QInvAgr";
    boolean iva = false;

    @Override
    public String getPagina() {
        return this.pag;
    }

    CBTabela_QInvAgr(CBTabela geo) {
        this.tag = "QInvAgr";
        this.PAG = (Frame_QInvAgr)fmeFrame.Paginas.getPage(this.pag);
        this.geo = geo;
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.PAG.getJTable_QInvAgr().tab = this;
        this.PAG.getJTable_QInvAgr().setName(this.tag);
        this.PAG.getJTable_QInvAgr().addKeyListener(new TableKeyListener(this));
        this.on_update_colunas();
        this.init_dados(14);
    }

    void on_update_colunas(boolean iva) {
        this.iva = iva;
        this.on_update_colunas();
    }

    void on_update_colunas() {
        if (!this.started) {
            return;
        }
        this.cols = new CHTabColModel[20];
        this.ordCol = 0;
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba no<br>Dossier", true, false, true, null);
        this.cols[1] = new CHTabColModel("design", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[2] = new CHTabColModel("rubinv", null, true, false, false, null);
        this.cols[3] = new CHTabColModel("rubinv_d", "Rubrica de<br>Investimento", true, true, true, null);
        this.cols[4] = new CHTabColModel("aplic", null, true, false, false, null);
        this.cols[5] = new CHTabColModel("aplic_d", "Tipo de<br>Investi\u00ad<br>mento", true, true, true, null);
        this.cols[6] = new CHTabColModel("sem_iva", this.iva ? "Investimento<br>sem IVA" : "Investimento<br>Total", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[7] = new CHTabColModel("escalao", null, true, true, false, null);
        this.cols[8] = new CHTabColModel("taxa_iva", "Taxa<br>IVA", 2, true, this.iva, null);
        this.cols[9] = new CHTabColModel("montante", "Investimento<br>com IVA eleg\u00edvel", 2, false, this.iva, (CFType)CFLib.VLD_VALOR_0);
        this.cols[10] = new CHTabColModel("elegivel", "Investimento<br>Eleg\u00edvel", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[11] = new CHTabColModel("residual", "Valor<br>Residual", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[12] = new CHTabColModel("n_estab", "N\u00ba do<br>Local", true, true, true, null);
        this.cols[13] = new CHTabColModel("poligono", "N\u00ba de<br>Pol\u00edgono", true, true, true, null);
        this.cols[14] = new CHTabColModel("geo", "GEO", true, false, this.PAG.geo, null);
        this.cols[15] = new CHTabColModel("geo_dir", "Cartografia [GEO]", true, true, false, null);
        this.cols[16] = new CHTabColModel("unidade", null, true, true, false, null);
        this.cols[17] = new CHTabColModel("unidade_d", "Unidade", true, true, true, null);
        this.cols[18] = new CHTabColModel("quantidade", "Quant.", true, true, true, (CFType)CFLib.VLD_VALOR);
        this.cols[19] = new CHTabColModel("calendario", "Realiza\u00e7\u00e3o<br>(aaaa-mm)", true, true, true, (CFType)CFLib.VLD_ANO_MES);
        this.init_handler(this.PAG.getJTable_QInvAgr());
        this.handler.width = this.PAG.getJScrollPane_QInvAgr().getWidth() - 21;
        this.handler.set_col_text(0, 0.075, "C");
        this.handler.set_col_text(1, 0.25, null);
        this.handler.set_col_comboS(3, 0.28, null, CTabelas.DespAgr, 1, 680);
        this.handler.set_col_comboF(5, 0.1, null, CTabelas.GenEsp, 1, 0);
        this.handler.set_col_text(6, 0.15, "R");
        if (this.iva) {
            this.handler.set_col_comboS(8, 0.075, "C", CTabelas.Iva, 1, 0);
        }
        if (this.iva) {
            this.handler.set_col_text(9, 0.15, "R");
        }
        this.handler.set_col_text(10, 0.15, "R");
        this.handler.set_col_text(11, 0.15, "R");
        this.cboEstabs = this.handler.set_col_comboD(12, 0.075, "C", CTabelas.EstabAgr, 0, 200);
        this.handler.set_col_text(13, 0.18, null);
        if (this.PAG.geo) {
            this.handler.set_col_check(14, 0.07);
        }
        this.handler.set_col_comboS(17, 0.14, null, CTabelas.UniExp, 1, 120);
        this.handler.set_col_text(18, 0.12, "R");
        this.handler.set_col_text(19, 0.1, "C");
        if (CBData.QInvAgr == null) {
            return;
        }
        int i = 0;
        while (i < this.dados.size()) {
            this.refresh_row(i);
            ++i;
        }
        CBData.calc_dados_proj_agr();
    }

    void refresh_row(int nRow) {
        String montante = this.getColValue("sem_iva", nRow);
        if (this.iva) {
            String escalao = this.getColValue("escalao", nRow);
            if (escalao.length() == 0) {
                montante = "";
            } else if (montante.length() != 0) {
                String taxa_iva = CTabelas.Iva.lookup(0, escalao, 2);
                double valor = Double.parseDouble(montante);
                double taxa = Double.parseDouble(taxa_iva);
                double rata = 0.0;
                if (CBData.Promotor.getByName((String)"regime_iva").v.equals("2")) {
                    rata = CBData.Promotor.getByName("pro_rata").valueAsDouble() / 100.0;
                }
                montante = _lib.to_number(valor * (1.0 + taxa * (1.0 - rata)));
            }
        }
        this.setColValue("montante", nRow, montante);
    }

    void _filter_populate_aplic(SteppedComboBox cboFiltered, int row) {
        String rubinv = this.getColValue("rubinv", row);
        String aplic = this.getColValue("aplic", row);
        if (rubinv.length() == 0 || !CTabelas.DespAgr.lookup(0, rubinv, 2).equals("M")) {
            CTabelas.GenEspF1.clear_combo();
        } else {
            CTabelas.GenEspF1.clear_filter();
        }
        CTabelas.GenEspF1._populateComboBox((JComboBox)cboFiltered, aplic);
    }

    @Override
    boolean on_del_row() {
        if (!super.on_del_row()) {
            return false;
        }
        this.analisar();
        CBData.calc_dados_proj_agr();
        return true;
    }

    @Override
    boolean on_copy_row() {
        if (!super.on_copy_row()) {
            return false;
        }
        CBData.calc_dados_proj_agr();
        return true;
    }

    void analisar() {
        String construcoes = "";
        String electrific = "";
        String barragens = "";
        int c = this.getColIndex("rubinv");
        int i = 0;
        while (i < this.dados.size()) {
            String[] row = (String[])this.dados.elementAt(i);
            if (row[c].length() > 0) {
                int cod = Integer.parseInt(row[c]);
                if (cod == 95) {
                    electrific = "1";
                }
                if (cod >= 100 && cod < 120) {
                    barragens = "1";
                }
                if (cod == 120) {
                    barragens = "1";
                }
                if (cod >= 130 && cod < 160) {
                    barragens = "1";
                }
                if (cod >= 250 && cod < 330) {
                    construcoes = "1";
                }
            }
            ++i;
        }
        if (CBData.Doc3.started) {
            CBData.Doc3.getByName("doc_2095").setStringValue(construcoes);
            CBData.Doc3.getByName("doc_2103").setStringValue(electrific);
            CBData.Doc3.getByName("doc_2135").setStringValue(barragens);
        }
    }

    @Override
    void on_update(String colname, int nRow, String v, String x) {
        String rubinv;
        super.on_update(colname, nRow, v, x);
        if (colname.equals("rubinv_d") && !(rubinv = CTabelas.DespAgr.lookup(1, v, 0)).equals(this.getColValue("rubinv", nRow))) {
            this.setColValue("rubinv", nRow, rubinv);
            this.updateValue("aplic_d", nRow, "");
        }
        if (colname.equals("aplic_d")) {
            String aplic = CTabelas.GenEsp.lookup(1, v, 0);
            this.setColValue("aplic", nRow, aplic);
        }
        if (colname.equals("sem_iva")) {
            this.refresh_row(nRow);
        }
        if (colname.equals("escalao")) {
            String taxa_iva = CTabelas.Iva.lookup(0, v, 1);
            this.setColValue("taxa_iva", nRow, taxa_iva);
            this.refresh_row(nRow);
        }
        if (colname.equals("taxa_iva")) {
            String escalao = CTabelas.Iva.lookup(1, v, 0);
            this.setColValue("escalao", nRow, escalao);
            this.refresh_row(nRow);
        }
        if (colname.equals("unidade_d")) {
            String unidade = CTabelas.UniExp.lookup(1, v, 0);
            this.setColValue("unidade", nRow, unidade);
        }
        if (colname.equals("geo_dir")) {
            this.setColValue("geo", nRow, v.length() == 0 ? "" : "1");
        }
        this.numerar();
        this.analisar();
        CBData.calc_dados_proj_agr();
    }

    CHValid_Grp validar(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("quadro", "Lista vazia"));
        } else {
            Calendar cal = Calendar.getInstance();
            int r = this.getColIndex("rubinv");
            int p = this.getColIndex("poligono");
            int n = this.getColIndex("n_estab");
            int u = this.getColIndex("unidade");
            int q = this.getColIndex("quantidade");
            int c = this.getColIndex("calendario");
            int v = this.getColIndex("elegivel");
            int m = this.getColIndex("montante");
            int g = this.getColIndex("geo_dir");
            int h = this.getColIndex("geo");
            Date data_inicio = CFType_Data.parse_date(CBData.ProjAgr.getByName((String)"data_inicio").v);
            Date data_fim = CFType_Data.parse_date(CBData.ProjAgr.getByName((String)"data_fim").v);
            int i = 0;
            while (i < this.dados.size()) {
                if (!this.isRowEmpty(i)) {
                    String[] row = (String[])this.dados.elementAt(i);
                    StringBuffer mask = new StringBuffer("-R-R-R------R----RRR");
                    if (row[r].length() > 0 && !CTabelas.DespAgr.lookup(0, row[r], 2).equals("M")) {
                        mask.setCharAt(this.getColIndex("aplic_d"), 'N');
                    }
                    TabError[] e = this.isIncompletAll(i, mask.toString());
                    int ii = 0;
                    while (e != null && ii < e.length) {
                        err_list.add_msg(new CHValid_Msg(e[ii]));
                        ++ii;
                    }
                    if (row[c].length() == 7) {
                        Date dt_qi = CFType_Data.parse_date(String.valueOf(row[c]) + "-01");
                        cal.setTime(dt_qi);
                        cal.add(2, 1);
                        cal.add(5, -1);
                        Date dt_qf = cal.getTime();
                        if (data_inicio != null && dt_qf.before(data_inicio)) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, c, this), "Linha %L: Ano-m\u00eas de Realiza\u00e7\u00e3o anterior \u00e0 Data de In\u00edcio do Investimento"));
                        }
                        if (data_fim != null && dt_qi.after(data_fim)) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, c, this), "Linha %L: Ano-m\u00eas de Realiza\u00e7\u00e3o posterior \u00e0 Data de Fim do Investimento"));
                        }
                    }
                    if (row[p].length() > 0 && !row[p].matches("\\d{13}") && !row[p].matches("\\d{13}-\\d{3}")) {
                        err_list.add_msg(new CHValid_Msg(new TabError(i, p, this), "Linha %L: %T - Deve ter 13 d\u00edgitos ou 13 d\u00edgitos - (tra\u00e7o) 3 d\u00edgitos"));
                    }
                    if (this.PAG.geo && row[p].length() == 0 && row[n].length() != 0) {
                        int nn = this.geo.getColIndex("n_estab");
                        int gg = this.geo.getColIndex("geo_dir");
                        int j = 0;
                        while (j < this.geo.dados.size()) {
                            String[] one = (String[])this.geo.dados.elementAt(j);
                            if (one[nn].equals(row[n]) && row[g].length() == 0 && row[p].length() == 0 && CTabelas.DespAgr.lookup(0, row[r], 3).equals("S")) {
                                if (one[gg].length() != 0) break;
                                err_list.add_msg(new CHValid_Msg(new TabError(i, p, this), "Linha %L: %T ou GEO - Necess\u00e1rio se a Localiza\u00e7\u00e3o n\u00e3o tem ficheiro georeferenciado"));
                                break;
                            }
                            ++j;
                        }
                    }
                    double eleg = _lib.to_double(row[v]);
                    double inv = _lib.to_double(row[m]);
                    if (_lib.round(eleg) > _lib.round(inv)) {
                        err_list.add_msg(new CHValid_Msg(new TabError(i, v, this), "Linha %L: o Eleg\u00edvel n\u00e3o pode ser superior ao Investimento"));
                    }
                    if (this.PAG.geo) {
                        if (row[g].length() == 0 && CTabelas.DespAgr.lookup(0, row[r], 3).equals("D") && (row[n].length() == 0 || row[q].length() == 0 || !row[u].equals("041") || Double.parseDouble(row[q]) != CBData.LocalAgr.getArea(row[n])) && row[p].length() == 0) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, u, this), "Linha %L incompleta: Cartografia [GEO] ou N\u00ba de pol\u00edgono - Preenchimento necess\u00e1rio se a \u00e1rea, em hectares, \u00e9 diferente da indicada na Localiza\u00e7\u00e3o [N\u00ba do Local]"));
                        }
                        this.check_geo(err_list, row[g], i, h);
                    }
                }
                ++i;
            }
        }
        return err_list;
    }
}

