/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_SocJovem;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.util.Calendar;
import java.util.Date;

class CBTabela_SocJovem
extends CBTabela {
    Frame_SocJovem PAG = null;
    String pag = "SocJovem";

    public String getPagina() {
        return this.pag;
    }

    CBTabela_SocJovem() {
        this.tag = "SocJovem";
        this.PAG = (Frame_SocJovem)fmeFrame.Paginas.getPage(this.pag);
        if (this.PAG == null) {
            return;
        }
        this.PAG.CBData_SocJovem = this;
        this.started = true;
        this.cols = new CHTabColModel[21];
        this.ordCol = 0;
        this.cols[0] = new CHTabColModel("n_socio", null, true, false, false, null);
        this.cols[1] = new CHTabColModel("nome", "Nome", true, true, true, null);
        this.cols[2] = new CHTabColModel("funcao", "Fun\u00e7\u00e3o", true, true, true, null);
        this.cols[3] = new CHTabColModel("genero", null, true, false, false, null);
        this.cols[4] = new CHTabColModel("genero_d", "G\u00e9nero", true, true, true, null);
        this.cols[5] = new CHTabColModel("nasceu", "Data de<br>Nascimento", true, true, true, (CFType)CFLib.VLD_DATA);
        this.cols[6] = new CHTabColModel("nif_soc", "NIF", true, true, true, (CFType)CFLib.VLD_NIF);
        this.cols[7] = new CHTabColModel("perc", "% Particip.", true, true, true, (CFType)CFLib.VLD_PERC);
        this.cols[8] = new CHTabColModel("movel", "Telefone", true, true, true, null);
        this.cols[9] = new CHTabColModel("email", "E-Mail", true, true, true, (CFType)CFLib.VLD_EMAIL);
        this.cols[10] = new CHTabColModel("escsec", "Escolaridade 9\u00ba-12\u00ba ano", true, false, false, null);
        this.cols[11] = new CHTabColModel("escsup", null, true, false, false, null);
        this.cols[12] = new CHTabColModel("escsna", null, true, false, false, null);
        this.cols[13] = new CHTabColModel("empagr", null, true, false, false, null);
        this.cols[14] = new CHTabColModel("expagr", "Experi\u00eancia agr\u00edcola", true, false, false, null);
        this.cols[15] = new CHTabColModel("expinv", "Experi\u00eancia na \u00e1rea", true, false, false, null);
        this.cols[16] = new CHTabColModel("adequada", null, true, false, false, null);
        this.cols[17] = new CHTabColModel("basica", null, true, false, false, null);
        this.cols[18] = new CHTabColModel("especif", null, true, false, false, null);
        this.cols[19] = new CHTabColModel("gestao", null, true, false, false, null);
        this.cols[20] = new CHTabColModel("pratica", null, true, false, false, null);
        this.init_dados(6);
        this.init_handler(this.PAG.getJTable_Socios());
        this.PAG.getJTable_Socios().tab = this;
        this.PAG.getJTable_Socios().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Socios().getWidth() - 21;
        this.handler.set_col_text(1, 0.375, null);
        this.handler.set_col_text(2, 0.2, null);
        this.handler.set_col_comboS(4, 0.09, null, CTabelas.Genero, 1, 0);
        this.handler.set_col_text(5, 0.12, null);
        this.handler.set_col_text(6, 0.12, null);
        this.handler.set_col_text(7, 0.1, "R");
        this.handler.set_col_text(8, 0.12, null);
        this.handler.set_col_text(9, 0.26, null);
        this.PAG.enable_SocJovem();
    }

    boolean on_del_row() {
        if (!super.on_del_row()) {
            return false;
        }
        this.PAG.enable_SocJovem();
        this.analisar();
        return true;
    }

    boolean on_ins_row() {
        if (!super.on_ins_row()) {
            return false;
        }
        this.PAG.enable_SocJovem();
        return true;
    }

    void analisar() {
        if (!this.started || this.PAG.individual || !CBData.DocJ.started) {
            return;
        }
        String diploma = "";
        String certific = "";
        String declcomp = "";
        String declagr = "";
        String declinv = "";
        int i = 0;
        while (i < this.dados.size()) {
            if (!this.isRowEmpty(i)) {
                String[] row = (String[])this.dados.elementAt(i);
                if (row[this.getColIndex("escsec")].length() != 0) {
                    diploma = "1";
                }
                if (row[this.getColIndex("escsup")].length() != 0) {
                    diploma = "1";
                }
                if (row[this.getColIndex("escsna")].length() != 0) {
                    diploma = "1";
                }
                if (row[this.getColIndex("empagr")].length() != 0) {
                    certific = "1";
                }
                if (row[this.getColIndex("expagr")].equals("1")) {
                    declagr = "1";
                }
                if (row[this.getColIndex("expagr")].equals("1")) {
                    declinv = "1";
                }
                if (row[this.getColIndex("adequada")].length() == 0) {
                    declcomp = "1";
                }
            }
            ++i;
        }
        CBData.DocJ.getByName("doc_1121").setStringValue(diploma);
        CBData.DocJ.getByName("doc_1122").setStringValue(certific);
        CBData.DocJ.getByName("doc_1125").setStringValue(declagr);
        CBData.DocJ.getByName("doc_1126").setStringValue(declinv);
        CBData.DocJ.getByName("doc_1129").setStringValue(declcomp);
    }

    void numerar() {
        String[] velho = new String[this.dados.size()];
        String[] novo = new String[this.dados.size()];
        int n = 0;
        int i = 0;
        while (i < this.dados.size()) {
            velho[i] = ((String[])this.dados.elementAt(i))[this.ordCol];
            novo[i] = this.isRowEmpty(i) ? "" : Integer.toString(++n);
            ((String[])this.dados.elementAt((int)i))[this.ordCol] = novo[i];
            ++i;
        }
        CTabelas.SocJovem.refresh();
        this.update_key(CBData.Voluntaria, CBData.Voluntaria.cboSocios, CTabelas.SocJovem, 1, "n_socio", "nome", velho, novo);
    }

    void on_update(String colname, int nRow, String v, String x) {
        if (colname.equals("genero_d")) {
            String genero = CTabelas.Genero.lookup(1, v, 0);
            this.setColValue("genero", nRow, genero);
        }
        if (this.isRowEmpty(nRow)) {
            this.on_change(-1);
        }
        this.PAG.enable_SocJovem();
        this.numerar();
        this.analisar();
    }

    void on_change(int nRow) {
        if (CBData.QualJovem == null || !CBData.QualJovem.started) {
            return;
        }
        String escsec = "";
        String escsup = "";
        String escsna = "";
        String empagr = "";
        String expagr = "";
        String expinv = "";
        boolean was_dirty = CBData.dirty;
        if (nRow != -1) {
            escsec = this.getColValue("escsec", nRow);
            escsup = this.getColValue("escsup", nRow);
            escsna = this.getColValue("escsna", nRow);
            empagr = this.getColValue("empagr", nRow);
            expagr = this.getColValue("expagr", nRow);
            expinv = this.getColValue("expinv", nRow);
        }
        CBData.QualJovem.getByName("escsec").setStringValue(escsec);
        CBData.QualJovem.getByName("escsup").setStringValue(escsup);
        CBData.QualJovem.getByName("escsna").setStringValue(escsna);
        CBData.QualJovem.getByName("empagr").setStringValue(empagr);
        CBData.QualJovem.getByName("expagr").setStringValue(expagr);
        CBData.QualJovem.getByName("expinv").setStringValue(expinv);
        CBData.QualJovem.on_change();
        CBData.dirty = was_dirty;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("socios", "Lista vazia"));
        } else {
            String mask = "-RR-RRRR--R---RR-";
            Calendar nasceu = Calendar.getInstance();
            Calendar hoje = Calendar.getInstance();
            int a = this.getColIndex("expagr");
            int s = this.getColIndex("expinv");
            int d = this.getColIndex("nasceu");
            int p = this.getColIndex("perc");
            double pt = 0.0;
            double pj = 0.0;
            int i = 0;
            while (i < this.dados.size()) {
                if (!this.isRowEmpty(i)) {
                    double pc;
                    TabError[] e = this.isIncompletAll(i, mask);
                    int ii = 0;
                    while (e != null && ii < e.length) {
                        err_list.add_msg(new CHValid_Msg(e[ii]));
                        ++ii;
                    }
                    String[] row = (String[])this.dados.elementAt(i);
                    Date data = CFType_Data.parse_date(row[d]);
                    int idade = Integer.MAX_VALUE;
                    if (data != null) {
                        nasceu.setTime(data);
                        idade = hoje.get(1) - nasceu.get(1);
                        nasceu.add(1, idade);
                        if (nasceu.after(hoje)) {
                            --idade;
                        }
                        if (idade < 18 || idade > 108) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, d, this), "A idade deve ser razo\u00e1vel, a partir de 18 anos"));
                        }
                    }
                    double d2 = pc = row[p].length() == 0 ? 0.0 : Double.parseDouble(row[p]);
                    if (idade < 40) {
                        pj += pc;
                    }
                    pt += pc;
                    if (row[a].equals("2") && row[s].equals("1")) {
                        err_list.add_msg(new CHValid_Msg(new TabError(i, a, this), "Experi\u00eancia na \u00e1rea de instala\u00e7\u00e3o implica experi\u00eancia agr\u00edcola"));
                    }
                }
                ++i;
            }
            if (_lib.round(pt) > 100.0) {
                err_list.add_msg(new CHValid_Msg("perc", "As participa\u00e7\u00f5es declaradas correspondem a mais de 100% do capital social"));
            }
            if (_lib.round(pj) <= 50.0) {
                err_list.add_msg(new CHValid_Msg("perc", "N\u00e3o existem s\u00f3cios gerentes com menos de 40 anos detentores da maioria do capital social"));
            }
            if (!this.isUnique("nif_soc")) {
                err_list.add_msg(new CHValid_Msg("nif_soc", "N\u00e3o devem existir NIF's repetidos"));
            }
        }
        return err_list;
    }
}

