/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CFType;
import fme.CFType_Data;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_QInv;
import fme.TabError;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;

class CBTabela_QInv
extends CBTabela {
    JComboBox cboEstabs = null;
    Frame_QInv PAG = null;
    String pag = "QInv";

    public String getPagina() {
        return this.pag;
    }

    CBTabela_QInv() {
        this.tag = "Inv";
        this.PAG = (Frame_QInv)fmeFrame.Paginas.getPage(this.pag);
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.cols = new CHTabColModel[14];
        this.ordCol = 0;
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba no<br>Dossier", true, false, true, null);
        this.cols[1] = new CHTabColModel("unidades", "N\u00ba de<br>Unidades", true, true, true, (CFType)CFLib.VLD_INT);
        this.cols[2] = new CHTabColModel("descricao", "Designa\u00e7\u00e3o", true, true, true, null);
        this.cols[3] = new CHTabColModel("unicap", null, true, true, false, null);
        this.cols[4] = new CHTabColModel("unicap_d", "Unidade de<br>Capacidade", true, true, true, null);
        this.cols[5] = new CHTabColModel("quantidade", "Capacidade", true, true, true, (CFType)CFLib.VLD_QUANT);
        this.cols[6] = new CHTabColModel("calendario", "Aquisi\u00e7\u00e3o<br>(aaaa-mm)", true, true, true, (CFType)CFLib.VLD_ANO_MES);
        this.cols[7] = new CHTabColModel("montante", "Investimento", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[8] = new CHTabColModel("elegivel", "Eleg\u00edvel", true, true, true, (CFType)CFLib.VLD_VALOR_0);
        this.cols[9] = new CHTabColModel("classe", null, true, true, false, null);
        this.cols[10] = new CHTabColModel("classe_d", "Classifica\u00e7\u00e3o", true, true, true, null);
        this.cols[11] = new CHTabColModel("n_estab", "Local", true, true, true, null);
        this.cols[12] = new CHTabColModel("concelho", null, true, true, false, null);
        this.cols[13] = new CHTabColModel("concelho_d", "Concelho", true, false, true, null);
        this.init_dados(16);
        this.init_handler(this.PAG.getJTable_QInv());
        this.PAG.getJTable_QInv().tab = this;
        this.PAG.getJTable_QInv().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_QInv().getWidth();
        this.handler.set_col_text(0, 0.065, "C");
        this.handler.set_col_text(1, 0.08, "R");
        this.handler.set_col_text(2, 0.235, null);
        this.handler.set_col_comboS(4, 0.105, null, CTabelas.UniInd, 1, 100);
        this.handler.set_col_text(5, 0.115, "R");
        this.handler.set_col_text(6, 0.1, "C");
        this.handler.set_col_text(7, 0.135, "R");
        this.handler.set_col_text(8, 0.135, "R");
        this.handler.set_col_comboS(10, 0.275, null, CTabelas.DespInd, 1, 750);
        this.cboEstabs = this.handler.set_col_comboD(11, 0.075, "C", CTabelas.EstabInd, 0, 200);
        this.handler.set_col_text(13, 0.2, null);
    }

    boolean on_del_row() {
        if (!super.on_del_row()) {
            return false;
        }
        this.analisar();
        CBData.calc_dados_proj_ind();
        return true;
    }

    boolean on_copy_row() {
        if (!super.on_copy_row()) {
            return false;
        }
        CBData.calc_dados_proj_ind();
        return true;
    }

    void analisar() {
        String quer_iso = "";
        int c = this.getColIndex("classe");
        int v = this.getColIndex("elegivel");
        int i = 0;
        while (i < this.dados.size()) {
            String[] row = (String[])this.dados.elementAt(i);
            if (row[c].length() > 0 && row[v].length() > 0 && row[c].equals("130") && Double.parseDouble(row[v]) > 0.0) {
                quer_iso = "1";
            }
            ++i;
        }
        if (CBData.Doc3.started) {
            CBData.Doc3.getByName("doc_3183").setStringValue(quer_iso);
        }
    }

    void on_update(String colname, int nRow, String v, String x) {
        if (colname.equals("unicap_d")) {
            String unicap = CTabelas.UniInd.lookup(1, v, 0);
            this.setColValue("unicap", nRow, unicap);
        }
        if (colname.equals("classe_d")) {
            String classe = CTabelas.DespInd.lookup(1, v, 0);
            this.setColValue("classe", nRow, classe);
        }
        if (colname.equals("n_estab")) {
            String concelho = CTabelas.EstabInd.lookup(0, v, 2);
            this.updateValue("concelho", nRow, concelho);
        }
        if (colname.equals("concelho")) {
            String concelho_d = CTabelas.Concelhos.lookup(0, v, 1);
            this.setColValue("concelho_d", nRow, concelho_d);
        }
        this.numerar();
        this.analisar();
        CBData.calc_dados_proj_ind();
    }

    CHValid_Grp validar(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("quadro", "Lista vazia"));
        } else {
            Calendar cal = Calendar.getInstance();
            int u = this.getColIndex("unicap");
            int q = this.getColIndex("quantidade");
            int c = this.getColIndex("calendario");
            int g = this.getColIndex("elegivel");
            int m = this.getColIndex("montante");
            Date data_inicio = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"data_inicio").v);
            Date data_fim = CFType_Data.parse_date(CBData.ProjInd.getByName((String)"data_fim").v);
            int i = 0;
            while (i < this.dados.size()) {
                if (!this.isRowEmpty(i)) {
                    String[] row = (String[])this.dados.elementAt(i);
                    StringBuffer mask = new StringBuffer("-RR-RRRRR-RR--");
                    if (CTabelas.UniInd.lookup(0, row[u], 2).equals("N")) {
                        mask.setCharAt(q, '-');
                    }
                    TabError[] e = this.isIncompletAll(i, mask.toString());
                    int ii = 0;
                    while (e != null && ii < e.length) {
                        err_list.add_msg(new CHValid_Msg(e[ii]));
                        ++ii;
                    }
                    if (row[c].length() == 7) {
                        Date dt_qi = CFType_Data.parse_date(String.valueOf(row[c]) + "-01");
                        cal.setTime(dt_qi);
                        cal.add(2, 1);
                        cal.add(5, -1);
                        Date dt_qf = cal.getTime();
                        if (data_inicio != null && dt_qf.before(data_inicio)) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, c, this), "Linha %L: Ano-m\u00eas de de Realiza\u00e7\u00e3o anterior \u00e0 Data de In\u00edcio do Investimento"));
                        }
                        if (data_fim != null && dt_qi.after(data_fim)) {
                            err_list.add_msg(new CHValid_Msg(new TabError(i, c, this), "Linha %L: Ano-m\u00eas de Realiza\u00e7\u00e3o posterior \u00e0 Data de Fim do Investimento"));
                        }
                    }
                    double eleg = _lib.to_double(row[g]);
                    double inv = _lib.to_double(row[m]);
                    if (_lib.round(eleg) > _lib.round(inv)) {
                        err_list.add_msg(new CHValid_Msg(new TabError(i, g, this), "Linha %L: o Eleg\u00edvel n\u00e3o pode ser superior ao Investimento"));
                    }
                }
                ++i;
            }
        }
        return err_list;
    }
}

