/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBGrupo_Total;
import fme.CBTabela;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.FileUtil;
import fme.Frame_Grupo;
import fme.OneFileFilter;
import fme.TableKeyListener;
import fme.XMLDataHandler;
import fme.XMLParser;
import fme.fmeFrame;
import fme.fmeMain;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class CBTabela_Grupo
extends CBTabela {
    Frame_Grupo PAG = null;
    String pag = "Grupo";
    boolean dirty = false;

    public String getPagina() {
        return this.pag;
    }

    CBTabela_Grupo() {
        this.tag = "Lista";
        this.PAG = (Frame_Grupo)fmeFrame.Paginas.getPage(this.pag);
        if (this.PAG == null) {
            return;
        }
        this.started = true;
        this.cols = new CHTabColModel[6];
        this.cols[0] = new CHTabColModel("nif", null, true, true, false, null);
        this.cols[1] = new CHTabColModel("promotor", "Promotor", true, false, true, null);
        this.cols[2] = new CHTabColModel("componente", null, true, true, false, null);
        this.cols[3] = new CHTabColModel("componente_d", "Componentes", false, false, true, null);
        this.cols[4] = new CHTabColModel("entrada", null, true, true, false, null);
        this.cols[5] = new CHTabColModel("valido", "V\u00e1lido", true, false, true, null);
        this.init();
        this.init_handler(this.PAG.getJTable_Grupo());
        this.PAG.getJTable_Grupo().tab = this;
        this.PAG.getJTable_Grupo().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.PAG.getJScrollPane_Grupo().getWidth() - 21;
        this.handler.set_col_text(1, 0.6, null);
        this.handler.set_col_text(3, 0.3, null);
        this.handler.set_col_check(5, 0.1);
    }

    public void init() {
        fmeMain.frame.enable_Grupo(true);
        fmeMain.totais = new Vector();
        fmeMain.entrada = null;
        fmeMain.n_grupo = -1;
        this.dirty = false;
        this.init_dados(0);
    }

    boolean on_import_row() {
        boolean done = false;
        File temp = null;
        int n = this.handler.j.getRowCount();
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        JFileChooser fc = new JFileChooser();
        try {
            fc.setCurrentDirectory(new File(new File(".").getCanonicalPath()));
            fc.setDialogTitle("Escolha a candidatura que pretende importar");
            fc.addChoosableFileFilter(new OneFileFilter());
            int returnVal = fc.showOpenDialog(fmeMain.frame);
            if (returnVal == 0) {
                File source = fc.getSelectedFile();
                if (!source.exists()) {
                    JOptionPane.showMessageDialog(fmeMain.frame, "A candidatura " + source.getName() + " n\u00e3o existe.");
                } else {
                    temp = File.createTempFile("fmt", "");
                    if (!temp.delete()) {
                        throw new IOException();
                    }
                    if (!temp.mkdir()) {
                        throw new IOException();
                    }
                    XMLParser.unzip(source, temp);
                    String tempSlash = String.valueOf(temp.getCanonicalPath()) + File.separator;
                    File xml = new File(String.valueOf(tempSlash) + "candidatura_isolada" + ".xml");
                    if (!xml.exists()) {
                        JOptionPane.showMessageDialog(fmeMain.frame, "Formato desconhecido.");
                    } else if (super.on_add_row()) {
                        this.setColValue("entrada", n, fmeMain.nova_entrada());
                        CBData.before_open();
                        CBData.clearCand();
                        fmeMain.n_grupo = n;
                        fmeMain.totais.addElement(null);
                        fmeMain.entrada = this.getColValue("entrada", n);
                        xml.renameTo(fmeMain.tempFile(String.valueOf(fmeMain.entrada) + ".xml"));
                        File folder = new File(String.valueOf(tempSlash) + "candidatura_isolada");
                        if (folder.exists()) {
                            folder.renameTo(fmeMain.tempFile(fmeMain.entrada));
                        }
                        fmeMain.frame.reconfig(new String[]{CBData.cfg_grupo, CBData.cfg_param});
                        CBData.xml_parser.loadFromTemp(fmeMain.entrada);
                        CBData.after_open();
                        fmeFrame.guarda_cand(false);
                        fmeMain.entrada = null;
                        fmeMain.n_grupo = -1;
                        this.dirty = true;
                        done = true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erro '" + e.getMessage() + "' ao importar candidatura.");
        }
        if (temp != null) {
            try {
                FileUtil.delete(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.PAG.setCursor(Cursor.getDefaultCursor());
        this.PAG.enable_Grupo();
        return done;
    }

    boolean on_export_row() {
        boolean done = false;
        File temp = null;
        int n = this.handler.j.getSelectedRow();
        if (n < 0) {
            return false;
        }
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        JFileChooser fc = new JFileChooser();
        try {
            fc.setCurrentDirectory(new File(new File(".").getCanonicalPath()));
            fc.setDialogTitle("D\u00ea um nome \u00e0 candidatura que pretende exportar");
            fc.addChoosableFileFilter(new OneFileFilter());
            int returnVal = fc.showSaveDialog(fmeMain.frame);
            if (returnVal == 0) {
                String ext;
                File target = fc.getSelectedFile();
                String path = target.getAbsolutePath();
                if (!path.endsWith(ext = "." + CBData.isolada)) {
                    target = new File(String.valueOf(path) + ext);
                }
                int opt = 0;
                if (target.exists()) {
                    Object[] yes_no = new Object[]{"   Sim   ", "   N\u00e3o   "};
                    opt = JOptionPane.showOptionDialog(fmeMain.frame, "J\u00e1 existe um ficheiro com esse nome.\nDeseja sobrep\u00f4r?", "Exportar", 0, 3, null, yes_no, yes_no[1]);
                }
                if (opt == 0) {
                    temp = File.createTempFile("fmt", "");
                    if (!temp.delete()) {
                        throw new IOException();
                    }
                    if (!temp.mkdir()) {
                        throw new IOException();
                    }
                    fmeMain.n_grupo = n;
                    fmeMain.entrada = this.getColValue("entrada", n);
                    String tempSlash = String.valueOf(temp.getCanonicalPath()) + File.separator;
                    File xml = fmeMain.tempFile(String.valueOf(fmeMain.entrada) + ".xml");
                    FileUtil.copy(xml, new File(String.valueOf(tempSlash) + "candidatura_isolada" + ".xml"));
                    File folder = fmeMain.tempFile(fmeMain.entrada);
                    if (folder.exists()) {
                        FileUtil.copy(folder, new File(String.valueOf(tempSlash) + "candidatura_isolada"));
                    }
                    XMLParser.zip(temp, target);
                    fmeMain.entrada = null;
                    fmeMain.n_grupo = -1;
                    done = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Erro '" + e.getMessage() + "' ao exportar candidatura.");
        }
        if (temp != null) {
            try {
                FileUtil.delete(temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.PAG.setCursor(Cursor.getDefaultCursor());
        this.PAG.enable_Grupo();
        return done;
    }

    boolean on_edit_row() {
        int n = this.handler.j.getSelectedRow();
        if (n < 0) {
            return false;
        }
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        CBData.before_open();
        CBData.clearCand();
        fmeMain.n_grupo = n;
        fmeMain.entrada = this.getColValue("entrada", n);
        fmeMain.frame.reconfig(new String[]{CBData.cfg_grupo, CBData.cfg_param});
        CBData.xml_parser.loadFromTemp(fmeMain.entrada);
        CBData.after_open();
        this.PAG.setCursor(Cursor.getDefaultCursor());
        fmeMain.frame.select_page(CBData.pagina);
        fmeMain.frame.enable_Grupo(false);
        this.PAG.enable_Grupo();
        return true;
    }

    boolean on_copy_row() {
        int n = this.handler.j.getSelectedRow();
        if (!super.on_copy_row()) {
            return false;
        }
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        fmeMain.totais.insertElementAt(null, n + 1);
        String entrada = fmeMain.nova_entrada();
        this.setColValue("entrada", n + 1, entrada);
        this.setColValue("valido", n + 1, "");
        try {
            File xml = fmeMain.tempFile(String.valueOf(this.getColValue("entrada", n)) + ".xml");
            FileUtil.copy(xml, fmeMain.tempFile(String.valueOf(this.getColValue("entrada", n + 1)) + ".xml"));
            File folder = fmeMain.tempFile(this.getColValue("entrada", n));
            if (folder.exists()) {
                FileUtil.copy(folder, fmeMain.tempFile(this.getColValue("entrada", n + 1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.PAG.setCursor(Cursor.getDefaultCursor());
        this.PAG.enable_Grupo();
        this.dirty = true;
        return true;
    }

    boolean on_up_row() {
        int n = this.handler.j.getSelectedRow();
        if (!super.on_up_row()) {
            return false;
        }
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        CBGrupo_Total row_1 = (CBGrupo_Total)fmeMain.totais.elementAt(n - 1);
        CBGrupo_Total row_2 = (CBGrupo_Total)fmeMain.totais.elementAt(n);
        fmeMain.totais.setElementAt(row_2, n - 1);
        fmeMain.totais.setElementAt(row_1, n);
        this.PAG.setCursor(Cursor.getDefaultCursor());
        this.PAG.enable_Grupo();
        this.dirty = true;
        return true;
    }

    boolean on_add_row() {
        int n = this.handler.j.getRowCount();
        if (!super.on_add_row()) {
            return false;
        }
        this.setColValue("entrada", n, fmeMain.nova_entrada());
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        CBData.clearCand();
        fmeMain.n_grupo = n;
        fmeMain.totais.addElement(null);
        fmeMain.entrada = this.getColValue("entrada", n);
        fmeMain.frame.reconfig(new String[]{CBData.cfg_grupo, CBData.cfg_param});
        this.PAG.setCursor(Cursor.getDefaultCursor());
        fmeMain.frame.enable_Grupo(false);
        fmeMain.frame.select_page(1);
        this.PAG.enable_Grupo();
        this.dirty = true;
        return true;
    }

    boolean on_ins_row() {
        int n = this.handler.j.getSelectedRow();
        if (!super.on_ins_row()) {
            return false;
        }
        this.setColValue("entrada", n, fmeMain.nova_entrada());
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        CBData.clearCand();
        fmeMain.n_grupo = n;
        fmeMain.totais.insertElementAt(null, n);
        fmeMain.entrada = this.getColValue("entrada", n);
        fmeMain.frame.reconfig(new String[]{CBData.cfg_grupo, CBData.cfg_param});
        this.PAG.setCursor(Cursor.getDefaultCursor());
        fmeMain.frame.enable_Grupo(false);
        fmeMain.frame.select_page(1);
        this.PAG.enable_Grupo();
        this.dirty = true;
        return true;
    }

    boolean on_del_row() {
        int m;
        String entrada;
        int n = this.handler.j.getSelectedRow();
        String string = entrada = n < (m = this.handler.j.getRowCount()) && n != -1 ? this.getColValue("entrada", n) : "";
        if (!super.on_del_row(true)) {
            return false;
        }
        this.PAG.setCursor(Cursor.getPredefinedCursor(3));
        fmeMain.delete(String.valueOf(entrada) + ".xml");
        fmeMain.delete(entrada);
        fmeMain.totais.removeElementAt(n);
        this.PAG.setCursor(Cursor.getDefaultCursor());
        this.PAG.enable_Grupo();
        this.dirty = true;
        return true;
    }

    void on_update(String colname, int row, String v, String x) {
        if (colname.equals("componente_d")) {
            String componente = CTabelas.Componentes.lookup(1, v, 0);
            if (componente.length() == 0) {
                this.setColValue(colname, row, "");
            }
            this.setColValue("componente", row, componente);
        }
        if (colname.equals("componente")) {
            String componente_d = CTabelas.Componentes.lookup(0, v, 1);
            if (componente_d.length() == 0) {
                this.setColValue(colname, row, "");
            }
            this.setColValue("componente_d", row, componente_d);
        }
    }

    String xmlPrintInternal(int row) {
        String xml = "";
        xml = String.valueOf(xml) + "<Totais>\n";
        xml = String.valueOf(xml) + ((CBGrupo_Total)fmeMain.totais.elementAt(row)).xmlPrint();
        xml = String.valueOf(xml) + "</Totais>\n";
        return xml;
    }

    public XMLDataHandler getHandler(String path) {
        if (path.endsWith("/Lista/Reg")) {
            fmeMain.totais.addElement(new CBGrupo_Total());
        }
        if (path.endsWith("/Totais")) {
            return (CBGrupo_Total)fmeMain.totais.lastElement();
        }
        return null;
    }

    CHValid_Grp validar(CHValid_Grp err_list, String err_text) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, err_text);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("grupo", "Lista vazia"));
        }
        int i = 0;
        while (i < this.dados.size()) {
            String[] row = (String[])this.dados.elementAt(i);
            if (!row[this.getColIndex("valido")].equals("1")) {
                err_list.add_msg(new CHValid_Msg("grupo", "Todas as candidaturas devem ser validadas individualmente."));
                break;
            }
            ++i;
        }
        if (!this.isUnique("nif")) {
            err_list.add_msg(new CHValid_Msg("grupo", "Existem n\u00fameros de identifica\u00e7\u00e3o fiscal repetidos."));
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int i2 = 0;
        while (i2 < fmeMain.totais.size()) {
            CBGrupo_Total t = (CBGrupo_Total)fmeMain.totais.elementAt(i2);
            if (t.anoInd != -1 && t.anoInd < min) {
                min = t.anoInd;
            }
            if (t.anoInd != -1 && t.anoInd > max) {
                max = t.anoInd;
            }
            if (t.anoAgr != -1 && t.anoAgr < min) {
                min = t.anoAgr;
            }
            if (t.anoAgr != -1 && t.anoAgr > max) {
                max = t.anoAgr;
            }
            ++i2;
        }
        int m = max - min + 20;
        double[] vc = new double[m];
        double[] vv = new double[m];
        double[] vp = new double[m];
        double[] vg = new double[m];
        boolean fileira = false;
        boolean conjunto = false;
        i2 = 0;
        while (i2 < fmeMain.totais.size()) {
            int k;
            CBGrupo_Total t = (CBGrupo_Total)fmeMain.totais.elementAt(i2);
            if (t.compras_ind != null) {
                fileira = true;
                int j = 0;
                while (j < t.compras_ind.length) {
                    int n = t.anoInd - min + j;
                    vc[n] = vc[n] + t.compras_ind[j];
                    ++j;
                }
                k = t.anoInd - min + j;
                while (k < m) {
                    int n = k++;
                    vc[n] = vc[n] + t.compras_ind[j - 1];
                }
            }
            if (t.vendas_exp != null) {
                int j = 0;
                while (j < t.vendas_exp.length) {
                    int n = t.anoAgr - min + j;
                    vv[n] = vv[n] + t.vendas_exp[j];
                    ++j;
                }
                k = t.anoAgr - min + j;
                while (k < m) {
                    int n = k++;
                    vv[n] = vv[n] + t.vendas_exp[j - 1];
                }
            }
            if (t.paga_serv != null) {
                int j = 0;
                while (j < t.paga_serv.length) {
                    int n = t.anoAgr - min + j;
                    vp[n] = vp[n] + t.paga_serv[j];
                    ++j;
                }
                k = t.anoAgr - min + j;
                while (k < m) {
                    int n = k++;
                    vp[n] = vp[n] + t.paga_serv[j - 1];
                }
            }
            if (t.gestao != null) {
                conjunto = true;
                int j = 0;
                while (j < t.gestao.length) {
                    int n = t.anoAgr - min + j;
                    vg[n] = vg[n] + t.gestao[j];
                    ++j;
                }
                k = t.anoAgr - min + j;
                while (k < m) {
                    int n = k++;
                    vg[n] = vg[n] + t.gestao[j - 1];
                }
            }
            ++i2;
        }
        if (conjunto) {
            int j = 0;
            while (j < max - min + 20) {
                if (Math.abs(vp[j] - vg[j]) > Math.abs(vp[j] + vg[j]) / 2.0 / 100.0) {
                    err_list.add_msg(new CHValid_Msg("grupo", "Os pagamentos de servi\u00e7os \u00e0 entidade gestora [" + vp[j] + "] s\u00e3o diferentes das presta\u00e7\u00f5es de servi\u00e7os \u00e0 mesma [" + vg[j] + "] para o ano " + (min + j) + "."));
                    break;
                }
                ++j;
            }
        }
        if (CBData.Grupo.dados.size() < 2) {
            err_list.add_msg(new CHValid_Msg("grupo", "O pedido de apoio deve ser apresentado por dois ou mais promotores"));
        }
        if (CBData.agrupamento.equals("11F") && !fileira) {
            err_list.add_msg(new CHValid_Msg("grupo", "Um dos promotores deve apresentar investimentos na componente 2"));
        }
        return err_list;
    }
}

